/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.websocket.config;

import com.lenovo.cloud.framework.mq.redis.config.LenovoRedisMQConsumerAutoConfiguration;
import com.lenovo.cloud.framework.mq.redis.core.RedisMQTemplate;
import com.lenovo.cloud.framework.websocket.config.WebSocketProperties;
import com.lenovo.cloud.framework.websocket.core.handler.JsonWebSocketMessageHandler;
import com.lenovo.cloud.framework.websocket.core.listener.WebSocketMessageListener;
import com.lenovo.cloud.framework.websocket.core.security.LoginUserHandshakeInterceptor;
import com.lenovo.cloud.framework.websocket.core.security.WebSocketAuthorizeRequestsCustomizer;
import com.lenovo.cloud.framework.websocket.core.sender.kafka.KafkaWebSocketMessageConsumer;
import com.lenovo.cloud.framework.websocket.core.sender.kafka.KafkaWebSocketMessageSender;
import com.lenovo.cloud.framework.websocket.core.sender.local.LocalWebSocketMessageSender;
import com.lenovo.cloud.framework.websocket.core.sender.rabbitmq.RabbitMQWebSocketMessageConsumer;
import com.lenovo.cloud.framework.websocket.core.sender.rabbitmq.RabbitMQWebSocketMessageSender;
import com.lenovo.cloud.framework.websocket.core.sender.redis.RedisWebSocketMessageConsumer;
import com.lenovo.cloud.framework.websocket.core.sender.redis.RedisWebSocketMessageSender;
import com.lenovo.cloud.framework.websocket.core.sender.rocketmq.RocketMQWebSocketMessageConsumer;
import com.lenovo.cloud.framework.websocket.core.sender.rocketmq.RocketMQWebSocketMessageSender;
import com.lenovo.cloud.framework.websocket.core.session.WebSocketSessionHandlerDecorator;
import com.lenovo.cloud.framework.websocket.core.session.WebSocketSessionManager;
import com.lenovo.cloud.framework.websocket.core.session.WebSocketSessionManagerImpl;
import java.util.List;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.server.HandshakeInterceptor;

@AutoConfiguration(before={LenovoRedisMQConsumerAutoConfiguration.class})
@EnableWebSocket
@ConditionalOnProperty(prefix="lenovo.websocket", value={"enable"}, matchIfMissing=true)
@EnableConfigurationProperties(value={WebSocketProperties.class})
public class LenovoWebSocketAutoConfiguration {
    @Bean
    public WebSocketConfigurer webSocketConfigurer(HandshakeInterceptor[] handshakeInterceptorArray, WebSocketHandler webSocketHandler, WebSocketProperties webSocketProperties) {
        return webSocketHandlerRegistry -> webSocketHandlerRegistry.addHandler(webSocketHandler, new String[]{webSocketProperties.getPath()}).addInterceptors(handshakeInterceptorArray).setAllowedOriginPatterns(new String[]{"*"});
    }

    @Bean
    public HandshakeInterceptor handshakeInterceptor() {
        return new LoginUserHandshakeInterceptor();
    }

    @Bean
    public WebSocketHandler webSocketHandler(WebSocketSessionManager webSocketSessionManager, List<? extends WebSocketMessageListener<?>> list) {
        JsonWebSocketMessageHandler jsonWebSocketMessageHandler = new JsonWebSocketMessageHandler(list);
        return new WebSocketSessionHandlerDecorator((WebSocketHandler)jsonWebSocketMessageHandler, webSocketSessionManager);
    }

    @Bean
    public WebSocketSessionManager webSocketSessionManager() {
        return new WebSocketSessionManagerImpl();
    }

    @Bean
    public WebSocketAuthorizeRequestsCustomizer webSocketAuthorizeRequestsCustomizer(WebSocketProperties webSocketProperties) {
        return new WebSocketAuthorizeRequestsCustomizer(webSocketProperties);
    }

    @Configuration
    @ConditionalOnProperty(prefix="lenovo.websocket", name={"sender-type"}, havingValue="kafka")
    public class KafkaWebSocketMessageSenderConfiguration {
        @Bean
        public KafkaWebSocketMessageSender kafkaWebSocketMessageSender(WebSocketSessionManager webSocketSessionManager, KafkaTemplate<Object, Object> kafkaTemplate, @Value(value="${lenovo.websocket.sender-kafka.topic}") String string) {
            return new KafkaWebSocketMessageSender(webSocketSessionManager, kafkaTemplate, string);
        }

        @Bean
        public KafkaWebSocketMessageConsumer kafkaWebSocketMessageConsumer(KafkaWebSocketMessageSender kafkaWebSocketMessageSender) {
            return new KafkaWebSocketMessageConsumer(kafkaWebSocketMessageSender);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="lenovo.websocket", name={"sender-type"}, havingValue="rabbitmq")
    public class RabbitMQWebSocketMessageSenderConfiguration {
        @Bean
        public RabbitMQWebSocketMessageSender rabbitMQWebSocketMessageSender(WebSocketSessionManager webSocketSessionManager, RabbitTemplate rabbitTemplate, TopicExchange topicExchange) {
            return new RabbitMQWebSocketMessageSender(webSocketSessionManager, rabbitTemplate, topicExchange);
        }

        @Bean
        public RabbitMQWebSocketMessageConsumer rabbitMQWebSocketMessageConsumer(RabbitMQWebSocketMessageSender rabbitMQWebSocketMessageSender) {
            return new RabbitMQWebSocketMessageConsumer(rabbitMQWebSocketMessageSender);
        }

        @Bean
        public TopicExchange websocketTopicExchange(@Value(value="${lenovo.websocket.sender-rabbitmq.exchange}") String string) {
            return new TopicExchange(string, true, false);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="lenovo.websocket", name={"sender-type"}, havingValue="rocketmq")
    public class RocketMQWebSocketMessageSenderConfiguration {
        @Bean
        public RocketMQWebSocketMessageSender rocketMQWebSocketMessageSender(WebSocketSessionManager webSocketSessionManager, RocketMQTemplate rocketMQTemplate, @Value(value="${lenovo.websocket.sender-rocketmq.topic}") String string) {
            return new RocketMQWebSocketMessageSender(webSocketSessionManager, rocketMQTemplate, string);
        }

        @Bean
        public RocketMQWebSocketMessageConsumer rocketMQWebSocketMessageConsumer(RocketMQWebSocketMessageSender rocketMQWebSocketMessageSender) {
            return new RocketMQWebSocketMessageConsumer(rocketMQWebSocketMessageSender);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="lenovo.websocket", name={"sender-type"}, havingValue="redis")
    public class RedisWebSocketMessageSenderConfiguration {
        @Bean
        public RedisWebSocketMessageSender redisWebSocketMessageSender(WebSocketSessionManager webSocketSessionManager, RedisMQTemplate redisMQTemplate) {
            return new RedisWebSocketMessageSender(webSocketSessionManager, redisMQTemplate);
        }

        @Bean
        public RedisWebSocketMessageConsumer redisWebSocketMessageConsumer(RedisWebSocketMessageSender redisWebSocketMessageSender) {
            return new RedisWebSocketMessageConsumer(redisWebSocketMessageSender);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="lenovo.websocket", name={"sender-type"}, havingValue="local")
    public class LocalWebSocketMessageSenderConfiguration {
        @Bean
        public LocalWebSocketMessageSender localWebSocketMessageSender(WebSocketSessionManager webSocketSessionManager) {
            return new LocalWebSocketMessageSender(webSocketSessionManager);
        }
    }
}

