/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.websocket.core.sender;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.framework.websocket.core.message.JsonWebSocketMessage;
import com.lenovo.cloud.framework.websocket.core.sender.WebSocketMessageSender;
import com.lenovo.cloud.framework.websocket.core.session.WebSocketSessionManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public abstract class AbstractWebSocketMessageSender
implements WebSocketMessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractWebSocketMessageSender.class);
    private final WebSocketSessionManager sessionManager;

    @Override
    public void send(Integer n, Long l, String string, String string2) {
        this.send(null, n, l, string, string2);
    }

    @Override
    public void send(Integer n, String string, String string2) {
        this.send(null, n, null, string, string2);
    }

    @Override
    public void send(String string, String string2, String string3) {
        this.send(string, null, null, string2, string3);
    }

    public void send(String string, Integer n, Long l, String string2, String string3) {
        List list = Collections.emptyList();
        if (StrUtil.isNotEmpty((CharSequence)string)) {
            WebSocketSession webSocketSession = this.sessionManager.getSession(string);
            if (webSocketSession != null) {
                list = Collections.singletonList(webSocketSession);
            }
        } else if (n != null && l != null) {
            list = (List)this.sessionManager.getSessionList(n, l);
        } else if (n != null) {
            list = (List)this.sessionManager.getSessionList(n);
        }
        if (CollUtil.isEmpty(list) && log.isDebugEnabled()) {
            log.debug("[send][sessionId({}) userType({}) userId({}) messageType({}) messageContent({}) \u672a\u5339\u914d\u5230\u4f1a\u8bdd]", new Object[]{string, n, l, string2, string3});
        }
        this.doSend(list, string2, string3);
    }

    public void doSend(Collection<WebSocketSession> collection, String string, String string2) {
        JsonWebSocketMessage jsonWebSocketMessage = new JsonWebSocketMessage().setType(string).setContent(string2);
        String string3 = JsonUtils.toJsonString((Object)jsonWebSocketMessage);
        collection.forEach(webSocketSession -> {
            if (webSocketSession == null) {
                log.error("[doSend][session \u4e3a\u7a7a, message({})]", (Object)jsonWebSocketMessage);
                return;
            }
            if (!webSocketSession.isOpen()) {
                log.error("[doSend][session({}) \u5df2\u5173\u95ed, message({})]", (Object)webSocketSession.getId(), (Object)jsonWebSocketMessage);
                return;
            }
            try {
                webSocketSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)string3));
                log.info("[doSend][session({}) \u53d1\u9001\u6d88\u606f\u6210\u529f\uff0cmessage({})]", (Object)webSocketSession.getId(), (Object)jsonWebSocketMessage);
            }
            catch (IOException iOException) {
                log.error("[doSend][session({}) \u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0cmessage({})]", new Object[]{webSocketSession.getId(), jsonWebSocketMessage, iOException});
            }
        });
    }

    @Generated
    public AbstractWebSocketMessageSender(WebSocketSessionManager webSocketSessionManager) {
        this.sessionManager = webSocketSessionManager;
    }
}

