/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.websocket.core.session;

import com.lenovo.cloud.framework.websocket.core.session.WebSocketSessionManager;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;

public class WebSocketSessionHandlerDecorator
extends WebSocketHandlerDecorator {
    private static final Integer SEND_TIME_LIMIT = 5000;
    private static final Integer BUFFER_SIZE_LIMIT = 102400;
    private final WebSocketSessionManager sessionManager;

    public WebSocketSessionHandlerDecorator(WebSocketHandler webSocketHandler, WebSocketSessionManager webSocketSessionManager) {
        super(webSocketHandler);
        this.sessionManager = webSocketSessionManager;
    }

    public void afterConnectionEstablished(WebSocketSession webSocketSession) {
        webSocketSession = new ConcurrentWebSocketSessionDecorator(webSocketSession, SEND_TIME_LIMIT.intValue(), BUFFER_SIZE_LIMIT.intValue());
        this.sessionManager.addSession(webSocketSession);
    }

    public void afterConnectionClosed(WebSocketSession webSocketSession, CloseStatus closeStatus) {
        this.sessionManager.removeSession(webSocketSession);
    }
}

