/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.websocket.core.session;

import cn.hutool.core.collection.CollUtil;
import com.lenovo.cloud.framework.security.core.LoginUser;
import com.lenovo.cloud.framework.tenant.core.context.TenantContextHolder;
import com.lenovo.cloud.framework.websocket.core.session.WebSocketSessionManager;
import com.lenovo.cloud.framework.websocket.core.util.WebSocketFrameworkUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketSessionManagerImpl
implements WebSocketSessionManager {
    private final ConcurrentMap<String, WebSocketSession> idSessions = new ConcurrentHashMap<String, WebSocketSession>();
    private final ConcurrentMap<Integer, ConcurrentMap<Long, CopyOnWriteArrayList<WebSocketSession>>> userSessions = new ConcurrentHashMap<Integer, ConcurrentMap<Long, CopyOnWriteArrayList<WebSocketSession>>>();

    @Override
    public void addSession(WebSocketSession webSocketSession) {
        CopyOnWriteArrayList copyOnWriteArrayList;
        this.idSessions.put(webSocketSession.getId(), webSocketSession);
        LoginUser loginUser = WebSocketFrameworkUtils.getLoginUser(webSocketSession);
        if (loginUser == null) {
            return;
        }
        ConcurrentMap concurrentMap = (ConcurrentHashMap<Long, CopyOnWriteArrayList>)this.userSessions.get(loginUser.getUserType());
        if (concurrentMap == null) {
            concurrentMap = new ConcurrentHashMap<Long, CopyOnWriteArrayList>();
            if (this.userSessions.putIfAbsent(loginUser.getUserType(), concurrentMap) != null) {
                concurrentMap = (ConcurrentMap)this.userSessions.get(loginUser.getUserType());
            }
        }
        if ((copyOnWriteArrayList = (CopyOnWriteArrayList)concurrentMap.get(loginUser.getId())) == null) {
            copyOnWriteArrayList = new CopyOnWriteArrayList();
            if (concurrentMap.putIfAbsent(loginUser.getId(), copyOnWriteArrayList) != null) {
                copyOnWriteArrayList = (CopyOnWriteArrayList)concurrentMap.get(loginUser.getId());
            }
        }
        copyOnWriteArrayList.add(webSocketSession);
    }

    @Override
    public void removeSession(WebSocketSession webSocketSession) {
        this.idSessions.remove(webSocketSession.getId());
        LoginUser loginUser = WebSocketFrameworkUtils.getLoginUser(webSocketSession);
        if (loginUser == null) {
            return;
        }
        ConcurrentMap concurrentMap = (ConcurrentMap)this.userSessions.get(loginUser.getUserType());
        if (concurrentMap == null) {
            return;
        }
        CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)concurrentMap.get(loginUser.getId());
        copyOnWriteArrayList.removeIf(webSocketSession2 -> webSocketSession2.getId().equals(webSocketSession.getId()));
        if (CollUtil.isEmpty((Collection)copyOnWriteArrayList)) {
            concurrentMap.remove(loginUser.getId(), copyOnWriteArrayList);
        }
    }

    @Override
    public WebSocketSession getSession(String string) {
        return (WebSocketSession)this.idSessions.get(string);
    }

    @Override
    public Collection<WebSocketSession> getSessionList(Integer n) {
        ConcurrentMap concurrentMap = (ConcurrentMap)this.userSessions.get(n);
        if (CollUtil.isEmpty((Map)concurrentMap)) {
            return new ArrayList<WebSocketSession>();
        }
        LinkedList<WebSocketSession> linkedList = new LinkedList<WebSocketSession>();
        Long l = TenantContextHolder.getTenantId();
        for (List list : concurrentMap.values()) {
            Long l2;
            if (CollUtil.isEmpty((Collection)list) || l != null && !l.equals(l2 = WebSocketFrameworkUtils.getTenantId((WebSocketSession)list.get(0)))) continue;
            linkedList.addAll(list);
        }
        return linkedList;
    }

    @Override
    public Collection<WebSocketSession> getSessionList(Integer n, Long l) {
        ConcurrentMap concurrentMap = (ConcurrentMap)this.userSessions.get(n);
        if (CollUtil.isEmpty((Map)concurrentMap)) {
            return new ArrayList<WebSocketSession>();
        }
        CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)concurrentMap.get(l);
        return CollUtil.isNotEmpty((Collection)copyOnWriteArrayList) ? new ArrayList<WebSocketSession>(copyOnWriteArrayList) : new ArrayList();
    }
}

