/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSigGenericPKCS;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PdfSignatureAppearance {
    public static final PdfName SELF_SIGNED = PdfName.ADOBE_PPKLITE;
    public static final PdfName VERISIGN_SIGNED = PdfName.VERISIGN_PPKVS;
    public static final PdfName WINCER_SIGNED = PdfName.ADOBE_PPKMS;
    private static final float topSection = 0.3f;
    private static final float margin = 2.0f;
    private Rectangle rect;
    private Rectangle pageRect;
    private PdfTemplate[] app = new PdfTemplate[5];
    private PdfTemplate frm;
    private PdfStamperImp writer;
    private String layer2Text;
    private String reason;
    private String location;
    private Calendar signDate;
    private String provider;
    private int page = 1;
    private String fieldName;
    private PrivateKey privKey;
    private Certificate[] certChain;
    private CRL[] crlList;
    private PdfName filter;
    private boolean newField;
    private ByteBuffer sigout;
    private OutputStream originalout;
    private File tempFile;
    private PdfDictionary cryptoDictionary;
    private PdfStamper stamper;
    private boolean preClosed = false;
    private PdfSigGenericPKCS sigStandard;
    private int[] range;
    private RandomAccessFile raf;
    private int rangePosition = 0;
    private byte[] bout;
    private int boutLen;
    private byte[] externalDigest;
    private byte[] externalRSAdata;
    private String digestEncryptionAlgorithm;
    private HashMap exclusionLocations;
    public static final String questionMark = "% DSUnknown\nq\n1 G\n1 g\n0.1 0 0 0.1 9 0 cm\n0 J 0 j 4 M []0 d\n1 i \n0 g\n313 292 m\n313 404 325 453 432 529 c\n478 561 504 597 504 645 c\n504 736 440 760 391 760 c\n286 760 271 681 265 626 c\n265 625 l\n100 625 l\n100 828 253 898 381 898 c\n451 898 679 878 679 650 c\n679 555 628 499 538 435 c\n488 399 467 376 467 292 c\n313 292 l\nh\n308 214 170 -164 re\nf\n0.44 G\n1.2 w\n1 1 0.4 rg\n287 318 m\n287 430 299 479 406 555 c\n451 587 478 623 478 671 c\n478 762 414 786 365 786 c\n260 786 245 707 239 652 c\n239 651 l\n74 651 l\n74 854 227 924 355 924 c\n425 924 653 904 653 676 c\n653 581 602 525 512 461 c\n462 425 441 402 441 318 c\n287 318 l\nh\n282 240 170 -164 re\nB\nQ\n";
    private String contact;
    private Font layer2Font;
    private String layer4Text;
    private boolean acro6Layers;
    private int runDirection = 1;
    private SignatureEvent signatureEvent;

    PdfSignatureAppearance(PdfStamperImp writer) {
        this.writer = writer;
        this.signDate = new GregorianCalendar();
        this.fieldName = this.getNewSigName();
    }

    public void setLayer2Text(String text) {
        this.layer2Text = text;
    }

    public String getLayer2Text() {
        return this.layer2Text;
    }

    public void setLayer4Text(String text) {
        this.layer4Text = text;
    }

    public String getLayer4Text() {
        return this.layer4Text;
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public boolean isInvisible() {
        return this.rect == null || this.rect.width() == 0.0f || this.rect.height() == 0.0f;
    }

    public void setCrypto(PrivateKey privKey, Certificate[] certChain, CRL[] crlList, PdfName filter) {
        this.privKey = privKey;
        this.certChain = certChain;
        this.crlList = crlList;
        this.filter = filter;
    }

    public void setVisibleSignature(Rectangle pageRect, int page, String fieldName) {
        if (fieldName != null) {
            AcroFields af = this.writer.getAcroFields();
            AcroFields.Item item = af.getFieldItem(fieldName);
            if (item != null) {
                throw new IllegalArgumentException("The field " + fieldName + " already exists.");
            }
            this.fieldName = fieldName;
        }
        if (page < 1 || page > this.writer.reader.getNumberOfPages()) {
            throw new IllegalArgumentException("Invalid page number: " + page);
        }
        this.pageRect = new Rectangle(pageRect);
        this.pageRect.normalize();
        this.rect = new Rectangle(this.pageRect.width(), this.pageRect.height());
        this.page = page;
        this.newField = true;
    }

    public void setVisibleSignature(String fieldName) {
        AcroFields af = this.writer.getAcroFields();
        AcroFields.Item item = af.getFieldItem(fieldName);
        if (item == null) {
            throw new IllegalArgumentException("The field " + fieldName + " does not exist.");
        }
        PdfDictionary merged = (PdfDictionary)item.merged.get(0);
        if (!PdfName.SIG.equals(PdfReader.getPdfObject(merged.get(PdfName.FT)))) {
            throw new IllegalArgumentException("The field " + fieldName + " is not a signature field.");
        }
        this.fieldName = fieldName;
        PdfArray r = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.RECT));
        ArrayList ar = r.getArrayList();
        float llx = ((PdfNumber)PdfReader.getPdfObject((PdfObject)ar.get(0))).floatValue();
        float lly = ((PdfNumber)PdfReader.getPdfObject((PdfObject)ar.get(1))).floatValue();
        float urx = ((PdfNumber)PdfReader.getPdfObject((PdfObject)ar.get(2))).floatValue();
        float ury = ((PdfNumber)PdfReader.getPdfObject((PdfObject)ar.get(3))).floatValue();
        this.pageRect = new Rectangle(llx, lly, urx, ury);
        this.pageRect.normalize();
        this.page = (Integer)item.page.get(0);
        int rotation = this.writer.reader.getPageRotation(this.page);
        Rectangle pageSize = this.writer.reader.getPageSizeWithRotation(this.page);
        switch (rotation) {
            case 90: {
                this.pageRect = new Rectangle(this.pageRect.bottom(), pageSize.top() - this.pageRect.left(), this.pageRect.top(), pageSize.top() - this.pageRect.right());
                break;
            }
            case 180: {
                this.pageRect = new Rectangle(pageSize.right() - this.pageRect.left(), pageSize.top() - this.pageRect.bottom(), pageSize.right() - this.pageRect.right(), pageSize.top() - this.pageRect.top());
                break;
            }
            case 270: {
                this.pageRect = new Rectangle(pageSize.right() - this.pageRect.bottom(), this.pageRect.left(), pageSize.right() - this.pageRect.top(), this.pageRect.right());
            }
        }
        if (rotation != 0) {
            this.pageRect.normalize();
        }
        this.rect = new Rectangle(this.pageRect.width(), this.pageRect.height());
    }

    public PdfTemplate getLayer(int layer) {
        if (layer < 0 || layer >= this.app.length) {
            return null;
        }
        PdfTemplate t = this.app[layer];
        if (t == null) {
            t = this.app[layer] = new PdfTemplate(this.writer);
            t.setBoundingBox(this.rect);
            this.writer.addDirectTemplateSimple(t, new PdfName("n" + layer));
        }
        return t;
    }

    public PdfTemplate getTopLayer() {
        if (this.frm == null) {
            this.frm = new PdfTemplate(this.writer);
            this.frm.setBoundingBox(this.rect);
            this.writer.addDirectTemplateSimple(this.frm, new PdfName("FRM"));
        }
        return this.frm;
    }

    public PdfTemplate getAppearance() throws DocumentException, IOException {
        Rectangle sr;
        PdfTemplate t;
        if (this.app[0] == null) {
            t = this.app[0] = new PdfTemplate(this.writer);
            t.setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.writer.addDirectTemplateSimple(t, new PdfName("n0"));
            t.setLiteral("% DSBlank\n");
        }
        if (this.app[1] == null && !this.acro6Layers) {
            t = this.app[1] = new PdfTemplate(this.writer);
            t.setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.writer.addDirectTemplateSimple(t, new PdfName("n1"));
            t.setLiteral(questionMark);
        }
        if (this.app[2] == null) {
            String text;
            if (this.layer2Text == null) {
                StringBuffer buf = new StringBuffer();
                buf.append("Digitally signed by ").append(PdfPKCS7.getSubjectFields((X509Certificate)this.certChain[0]).getField("CN")).append("\n");
                SimpleDateFormat sd = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
                buf.append("Date: ").append(sd.format(this.signDate.getTime()));
                if (this.reason != null) {
                    buf.append("\n").append("Reason: ").append(this.reason);
                }
                if (this.location != null) {
                    buf.append("\n").append("Location: ").append(this.location);
                }
                text = buf.toString();
            } else {
                text = this.layer2Text;
            }
            PdfTemplate t2 = this.app[2] = new PdfTemplate(this.writer);
            t2.setBoundingBox(this.rect);
            this.writer.addDirectTemplateSimple(t2, new PdfName("n2"));
            Font font = this.layer2Font == null ? new Font() : new Font(this.layer2Font);
            float size = font.size();
            if (size <= 0.0f) {
                sr = new Rectangle(this.rect.width() - 4.0f, this.rect.height() * 0.7f - 4.0f);
                size = PdfSignatureAppearance.fitText(font, text, sr, 12.0f, this.runDirection);
            }
            ColumnText ct = new ColumnText(t2);
            ct.setRunDirection(this.runDirection);
            ct.setSimpleColumn(new Phrase(text, font), 2.0f, 0.0f, this.rect.width() - 2.0f, this.rect.height() * 0.7f - 2.0f, size, 0);
            ct.go();
        }
        if (this.app[3] == null && !this.acro6Layers) {
            t = this.app[3] = new PdfTemplate(this.writer);
            t.setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.writer.addDirectTemplateSimple(t, new PdfName("n3"));
            t.setLiteral("% DSBlank\n");
        }
        if (this.app[4] == null && !this.acro6Layers) {
            t = this.app[4] = new PdfTemplate(this.writer);
            t.setBoundingBox(new Rectangle(0.0f, this.rect.height() * 0.7f, this.rect.right(), this.rect.top()));
            this.writer.addDirectTemplateSimple(t, new PdfName("n4"));
            Font font = this.layer2Font == null ? new Font() : new Font(this.layer2Font);
            float size = font.size();
            String text = "Signature Not Verified";
            if (this.layer4Text != null) {
                text = this.layer4Text;
            }
            sr = new Rectangle(this.rect.width() - 4.0f, this.rect.height() * 0.3f - 4.0f);
            size = PdfSignatureAppearance.fitText(font, text, sr, 15.0f, this.runDirection);
            ColumnText ct = new ColumnText(t);
            ct.setRunDirection(this.runDirection);
            ct.setSimpleColumn(new Phrase(text, font), 2.0f, 0.0f, this.rect.width() - 2.0f, this.rect.height() - 2.0f, size, 0);
            ct.go();
        }
        int rotation = this.writer.reader.getPageRotation(this.page);
        Rectangle rotated = new Rectangle(this.rect);
        int n = rotation;
        while (n > 0) {
            rotated = rotated.rotate();
            n -= 90;
        }
        if (this.frm == null) {
            this.frm = new PdfTemplate(this.writer);
            this.frm.setBoundingBox(rotated);
            this.writer.addDirectTemplateSimple(this.frm, new PdfName("FRM"));
            float scale = Math.min(this.rect.width(), this.rect.height()) * 0.9f;
            float x = (this.rect.width() - scale) / 2.0f;
            float y = (this.rect.height() - scale) / 2.0f;
            scale /= 100.0f;
            if (rotation == 90) {
                this.frm.concatCTM(0.0f, 1.0f, -1.0f, 0.0f, this.rect.height(), 0.0f);
            } else if (rotation == 180) {
                this.frm.concatCTM(-1.0f, 0.0f, 0.0f, -1.0f, this.rect.width(), this.rect.height());
            } else if (rotation == 270) {
                this.frm.concatCTM(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.rect.width());
            }
            this.frm.addTemplate(this.app[0], 0.0f, 0.0f);
            if (!this.acro6Layers) {
                this.frm.addTemplate(this.app[1], scale, 0.0f, 0.0f, scale, x, y);
            }
            this.frm.addTemplate(this.app[2], 0.0f, 0.0f);
            if (!this.acro6Layers) {
                this.frm.addTemplate(this.app[3], scale, 0.0f, 0.0f, scale, x, y);
                this.frm.addTemplate(this.app[4], 0.0f, 0.0f);
            }
        }
        PdfTemplate napp = new PdfTemplate(this.writer);
        napp.setBoundingBox(rotated);
        this.writer.addDirectTemplateSimple(napp, null);
        napp.addTemplate(this.frm, 0.0f, 0.0f);
        return napp;
    }

    public static float fitText(Font font, String text, Rectangle rect, float maxFontSize, int runDirection) {
        try {
            ColumnText ct = null;
            int status = 0;
            if (maxFontSize <= 0.0f) {
                int cr = 0;
                int lf = 0;
                char[] t = text.toCharArray();
                int k = 0;
                while (k < t.length) {
                    if (t[k] == '\n') {
                        ++lf;
                    } else if (t[k] == '\r') {
                        ++cr;
                    }
                    ++k;
                }
                int minLines = Math.max(cr, lf) + 1;
                maxFontSize = Math.abs(rect.height()) / (float)minLines - 0.001f;
            }
            font.setSize(maxFontSize);
            Phrase ph = new Phrase(text, font);
            ct = new ColumnText(null);
            ct.setSimpleColumn(ph, rect.left(), rect.bottom(), rect.right(), rect.top(), maxFontSize, 0);
            ct.setRunDirection(runDirection);
            status = ct.go(true);
            if ((status & 1) != 0) {
                return maxFontSize;
            }
            float precision = 0.1f;
            float min = 0.0f;
            float max = maxFontSize;
            float size = maxFontSize;
            int k = 0;
            while (k < 50) {
                size = (min + max) / 2.0f;
                ct = new ColumnText(null);
                font.setSize(size);
                ct.setSimpleColumn(new Phrase(text, font), rect.left(), rect.bottom(), rect.right(), rect.top(), size, 0);
                ct.setRunDirection(runDirection);
                status = ct.go(true);
                if ((status & 1) != 0) {
                    if (max - min < size * precision) {
                        return size;
                    }
                    min = size;
                } else {
                    max = size;
                }
                ++k;
            }
            return size;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void setExternalDigest(byte[] digest, byte[] RSAdata, String digestEncryptionAlgorithm) {
        this.externalDigest = digest;
        this.externalRSAdata = RSAdata;
        this.digestEncryptionAlgorithm = digestEncryptionAlgorithm;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public PrivateKey getPrivKey() {
        return this.privKey;
    }

    public Certificate[] getCertChain() {
        return this.certChain;
    }

    public CRL[] getCrlList() {
        return this.crlList;
    }

    public PdfName getFilter() {
        return this.filter;
    }

    public boolean isNewField() {
        return this.newField;
    }

    public int getPage() {
        return this.page;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Rectangle getPageRect() {
        return this.pageRect;
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Calendar signDate) {
        this.signDate = signDate;
    }

    ByteBuffer getSigout() {
        return this.sigout;
    }

    void setSigout(ByteBuffer sigout) {
        this.sigout = sigout;
    }

    OutputStream getOriginalout() {
        return this.originalout;
    }

    void setOriginalout(OutputStream originalout) {
        this.originalout = originalout;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    public String getNewSigName() {
        AcroFields af = this.writer.getAcroFields();
        String name = "Signature";
        int step = 0;
        boolean found = false;
        block0: while (!found) {
            String n1 = String.valueOf(name) + ++step;
            if (af.getFieldItem(n1) != null) continue;
            n1 = String.valueOf(n1) + ".";
            found = true;
            Iterator it = af.getFields().keySet().iterator();
            while (it.hasNext()) {
                String fn = (String)it.next();
                if (!fn.startsWith(n1)) continue;
                found = false;
                continue block0;
            }
        }
        name = String.valueOf(name) + step;
        return name;
    }

    public void preClose() throws IOException, DocumentException {
        this.preClose(null);
    }

    public void preClose(HashMap exclusionSizes) throws IOException, DocumentException {
        boolean fieldExists;
        if (this.preClosed) {
            throw new DocumentException("Document already pre closed.");
        }
        this.preClosed = true;
        AcroFields af = this.writer.getAcroFields();
        String name = this.getFieldName();
        boolean bl = fieldExists = !this.isInvisible() && !this.isNewField();
        if (fieldExists) {
            af.removeField(name);
        }
        this.writer.setSigFlags(3);
        PdfFormField sigField = PdfFormField.createSignature(this.writer);
        sigField.setFieldName(name);
        PdfIndirectReference refSig = this.writer.getPdfIndirectReference();
        sigField.put(PdfName.V, refSig);
        sigField.setFlags(132);
        int pagen = this.getPage();
        PdfReader reader = this.writer.reader;
        if (!this.isInvisible()) {
            sigField.setWidget(this.getPageRect(), null);
            sigField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, this.getAppearance());
        } else {
            sigField.setWidget(new Rectangle(0.0f, 0.0f), null);
        }
        sigField.setPage(pagen);
        this.writer.addAnnotation(sigField, pagen);
        this.exclusionLocations = new HashMap();
        if (this.cryptoDictionary == null) {
            if (PdfName.ADOBE_PPKLITE.equals(this.getFilter())) {
                this.sigStandard = new PdfSigGenericPKCS.PPKLite(this.getProvider());
            } else if (PdfName.ADOBE_PPKMS.equals(this.getFilter())) {
                this.sigStandard = new PdfSigGenericPKCS.PPKMS(this.getProvider());
            } else if (PdfName.VERISIGN_PPKVS.equals(this.getFilter())) {
                this.sigStandard = new PdfSigGenericPKCS.VeriSign(this.getProvider());
            } else {
                throw new IllegalArgumentException("Unknown filter: " + this.getFilter());
            }
            this.sigStandard.setExternalDigest(this.externalDigest, this.externalRSAdata, this.digestEncryptionAlgorithm);
            if (this.getReason() != null) {
                this.sigStandard.setReason(this.getReason());
            }
            if (this.getLocation() != null) {
                this.sigStandard.setLocation(this.getLocation());
            }
            if (this.getContact() != null) {
                this.sigStandard.setContact(this.getContact());
            }
            this.sigStandard.put(PdfName.M, new PdfDate(this.getSignDate()));
            this.sigStandard.setSignInfo(this.getPrivKey(), this.getCertChain(), this.getCrlList());
            PdfString contents = (PdfString)this.sigStandard.get(PdfName.CONTENTS);
            PdfLiteral lit = new PdfLiteral(contents.toString().length() * 2 + 2);
            this.exclusionLocations.put(PdfName.CONTENTS, lit);
            this.sigStandard.put(PdfName.CONTENTS, lit);
            lit = new PdfLiteral(80);
            this.exclusionLocations.put(PdfName.BYTERANGE, lit);
            this.sigStandard.put(PdfName.BYTERANGE, lit);
            if (this.signatureEvent != null) {
                this.signatureEvent.getSignatureDictionary(this.sigStandard);
            }
            this.writer.addToBody((PdfObject)this.sigStandard, refSig, false);
        } else {
            PdfLiteral lit = new PdfLiteral(80);
            this.exclusionLocations.put(PdfName.BYTERANGE, lit);
            this.cryptoDictionary.put(PdfName.BYTERANGE, lit);
            Iterator it = exclusionSizes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                PdfName key = (PdfName)entry.getKey();
                Integer v = (Integer)entry.getValue();
                lit = new PdfLiteral(v);
                this.exclusionLocations.put(key, lit);
                this.cryptoDictionary.put(key, lit);
            }
            if (this.signatureEvent != null) {
                this.signatureEvent.getSignatureDictionary(this.cryptoDictionary);
            }
            this.writer.addToBody((PdfObject)this.cryptoDictionary, refSig, false);
        }
        this.writer.close(this.stamper.getMoreInfo());
        this.range = new int[this.exclusionLocations.size() * 2];
        int byteRangePosition = ((PdfLiteral)this.exclusionLocations.get(PdfName.BYTERANGE)).getPosition();
        this.exclusionLocations.remove(PdfName.BYTERANGE);
        int idx = 1;
        Iterator it = this.exclusionLocations.values().iterator();
        while (it.hasNext()) {
            PdfLiteral lit = (PdfLiteral)it.next();
            int n = lit.getPosition();
            this.range[idx++] = n;
            this.range[idx++] = lit.getPosLength() + n;
        }
        Arrays.sort(this.range, 1, this.range.length - 1);
        int k = 3;
        while (k < this.range.length - 2) {
            int n = k;
            this.range[n] = this.range[n] - this.range[k - 1];
            k += 2;
        }
        if (this.tempFile == null) {
            this.bout = this.sigout.getBuffer();
            this.boutLen = this.sigout.size();
            this.range[this.range.length - 1] = this.boutLen - this.range[this.range.length - 2];
            ByteBuffer bf = new ByteBuffer();
            bf.append('[');
            int k2 = 0;
            while (k2 < this.range.length) {
                bf.append(this.range[k2]).append(' ');
                ++k2;
            }
            bf.append(']');
            System.arraycopy(bf.getBuffer(), 0, this.bout, byteRangePosition, bf.size());
        } else {
            try {
                this.raf = new RandomAccessFile(this.tempFile, "rw");
                int boutLen = (int)this.raf.length();
                this.range[this.range.length - 1] = boutLen - this.range[this.range.length - 2];
                ByteBuffer bf = new ByteBuffer();
                bf.append('[');
                int k3 = 0;
                while (k3 < this.range.length) {
                    bf.append(this.range[k3]).append(' ');
                    ++k3;
                }
                bf.append(']');
                this.raf.seek(byteRangePosition);
                this.raf.write(bf.getBuffer(), 0, bf.size());
            }
            catch (IOException e) {
                try {
                    this.raf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.tempFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(PdfDictionary update) throws IOException, DocumentException {
        block26: {
            block28: {
                try {
                    block27: {
                        if (!this.preClosed) {
                            throw new DocumentException("preClose() must be called first.");
                        }
                        bf = new ByteBuffer();
                        it = update.getKeys().iterator();
                        while (true) {
                            if (!it.hasNext()) {
                                if (update.size() == this.exclusionLocations.size()) break;
                                throw new IllegalArgumentException("The update dictionary has less keys than required.");
                            }
                            key = (PdfName)it.next();
                            obj = update.get(key);
                            lit = (PdfLiteral)this.exclusionLocations.get(key);
                            if (lit == null) {
                                throw new IllegalArgumentException("The key " + key.toString() + " didn't reserve space in preClose().");
                            }
                            bf.reset();
                            obj.toPdf(null, bf);
                            if (bf.size() > lit.getPosLength()) {
                                throw new IllegalArgumentException("The key " + key.toString() + " is too big.");
                            }
                            if (this.tempFile == null) {
                                System.arraycopy(bf.getBuffer(), 0, this.bout, lit.getPosition(), bf.size());
                                continue;
                            }
                            this.raf.seek(lit.getPosition());
                            this.raf.write(bf.getBuffer(), 0, bf.size());
                        }
                        if (this.tempFile != null) break block27;
                        this.originalout.write(this.bout, 0, this.boutLen);
                        ** GOTO lbl-1000
                    }
                    if (this.originalout != null) {
                        this.raf.seek(0L);
                        length = (int)this.raf.length();
                        buf = new byte[8192];
                        while (length > 0) {
                            r = this.raf.read(buf, 0, Math.min(buf.length, length));
                            if (r < 0) {
                                throw new EOFException("Unexpected EOF");
                            }
                            this.originalout.write(buf, 0, r);
                            length -= r;
                        }
                    }
                }
                catch (Throwable var8_9) {
                    var7_10 = null;
                    if (this.tempFile != null) {
                        try {
                            this.raf.close();
                        }
                        catch (Exception var9_12) {
                            // empty catch block
                        }
                        if (this.originalout != null) {
                            try {
                                this.tempFile.delete();
                            }
                            catch (Exception var9_12) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.originalout == null) throw var8_9;
                    try {
                        this.originalout.close();
                        throw var8_9;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw var8_9;
                }
lbl-1000:
                // 2 sources

                {
                    var7_11 = null;
                    if (this.tempFile == null) break block26;
                }
                ** try [egrp 1[TRYBLOCK] [2 : 400->410)] { 
lbl69:
                // 1 sources

                this.raf.close();
                break block28;
lbl71:
                // 1 sources

                catch (Exception var9_13) {
                    // empty catch block
                }
            }
            if (this.originalout != null) {
                ** try [egrp 2[TRYBLOCK] [3 : 419->430)] { 
lbl76:
                // 1 sources

                this.tempFile.delete();
                break block26;
lbl79:
                // 1 sources

                catch (Exception var9_13) {
                    // empty catch block
                }
            }
        }
        if (this.originalout == null) return;
        try {}
        catch (Exception e) {
            return;
        }
        this.originalout.close();
    }

    private static int indexArray(byte[] bout, int position, String search) {
        byte[] ss = PdfEncodings.convertToBytes(search, null);
        while (true) {
            int k = 0;
            while (k < ss.length) {
                if (ss[k] != bout[position + k]) break;
                ++k;
            }
            if (k == ss.length) {
                return position;
            }
            ++position;
        }
    }

    private static int indexFile(RandomAccessFile raf, int position, String search) throws IOException {
        byte[] ss = PdfEncodings.convertToBytes(search, null);
        while (true) {
            raf.seek(position);
            int k = 0;
            while (k < ss.length) {
                int b = raf.read();
                if (b < 0) {
                    throw new EOFException("Unexpected EOF");
                }
                if (ss[k] != (byte)b) break;
                ++k;
            }
            if (k == ss.length) {
                return position;
            }
            ++position;
        }
    }

    public InputStream getRangeStream() {
        return new RangeStream(this.raf, this.bout, this.range);
    }

    public PdfDictionary getCryptoDictionary() {
        return this.cryptoDictionary;
    }

    public void setCryptoDictionary(PdfDictionary cryptoDictionary) {
        this.cryptoDictionary = cryptoDictionary;
    }

    public PdfStamper getStamper() {
        return this.stamper;
    }

    void setStamper(PdfStamper stamper) {
        this.stamper = stamper;
    }

    public boolean isPreClosed() {
        return this.preClosed;
    }

    public PdfSigGenericPKCS getSigStandard() {
        return this.sigStandard;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public Font getLayer2Font() {
        return this.layer2Font;
    }

    public void setLayer2Font(Font layer2Font) {
        this.layer2Font = layer2Font;
    }

    public boolean isAcro6Layers() {
        return this.acro6Layers;
    }

    public void setAcro6Layers(boolean acro6Layers) {
        this.acro6Layers = acro6Layers;
    }

    public void setRunDirection(int runDirection) {
        if (runDirection < 0 || runDirection > 3) {
            throw new RuntimeException("Invalid run direction: " + runDirection);
        }
        this.runDirection = runDirection;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public SignatureEvent getSignatureEvent() {
        return this.signatureEvent;
    }

    public void setSignatureEvent(SignatureEvent signatureEvent) {
        this.signatureEvent = signatureEvent;
    }

    private static class RangeStream
    extends InputStream {
        private byte[] b = new byte[1];
        private RandomAccessFile raf;
        private byte[] bout;
        private int[] range;
        private int rangePosition = 0;

        RangeStream(RandomAccessFile raf, byte[] bout, int[] range) {
            this.raf = raf;
            this.bout = bout;
            this.range = range;
        }

        public int read() throws IOException {
            int n = this.read(this.b);
            if (n != 1) {
                return -1;
            }
            return this.b[0] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.rangePosition >= this.range[this.range.length - 2] + this.range[this.range.length - 1]) {
                return -1;
            }
            int k = 0;
            while (k < this.range.length) {
                int start = this.range[k];
                int end = start + this.range[k + 1];
                if (this.rangePosition < start) {
                    this.rangePosition = start;
                }
                if (this.rangePosition >= start && this.rangePosition < end) {
                    int lenf = Math.min(len, end - this.rangePosition);
                    if (this.raf == null) {
                        System.arraycopy(this.bout, this.rangePosition, b, off, lenf);
                    } else {
                        this.raf.seek(this.rangePosition);
                        this.raf.readFully(b, off, lenf);
                    }
                    this.rangePosition += lenf;
                    return lenf;
                }
                k += 2;
            }
            return -1;
        }
    }

    public interface SignatureEvent {
        public void getSignatureDictionary(PdfDictionary var1);
    }
}

