/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;

public class TextField {
    public static final float BORDER_WIDTH_THIN = 1.0f;
    public static final float BORDER_WIDTH_MEDIUM = 2.0f;
    public static final float BORDER_WIDTH_THICK = 3.0f;
    public static final int VISIBLE = 0;
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int READ_ONLY = 1;
    public static final int REQUIRED = 2;
    public static final int MULTILINE = 4;
    public static final int DO_NOT_SCROLL = 8;
    public static final int PASSWORD = 16;
    public static final int FILE_SELECTION = 32;
    public static final int DO_NOT_SPELL_CHECK = 64;
    public static final int EDIT = 128;
    public static final int COMB = 256;
    protected float borderWidth = 1.0f;
    protected int borderStyle = 0;
    protected Color borderColor;
    protected Color backgroundColor;
    protected Color textColor;
    protected BaseFont font;
    protected float fontSize = 0.0f;
    protected int alignment = 0;
    protected PdfWriter writer;
    protected String text;
    protected Rectangle box;
    protected int rotation = 0;
    private int visibility;
    private String fieldName;
    private String defaultText;
    private int options;
    private int maxCharacterLength;
    private String[] choices;
    private String[] choiceExports;
    private int choiceSelection;
    private int topFirst;

    public TextField(PdfWriter writer, Rectangle box, String fieldName) {
        this.writer = writer;
        this.box = box;
        this.fieldName = fieldName;
    }

    protected BaseFont getRealFont() throws IOException, DocumentException {
        if (this.font == null) {
            return BaseFont.createFont("Helvetica", "Cp1252", false);
        }
        return this.font;
    }

    protected PdfAppearance getBorderAppearance() throws IOException, DocumentException {
        PdfAppearance app = this.writer.getDirectContent().createAppearance(this.box.width(), this.box.height());
        switch (this.rotation) {
            case 90: {
                app.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, this.box.height(), 0.0f);
                break;
            }
            case 180: {
                app.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f, this.box.width(), this.box.height());
                break;
            }
            case 270: {
                app.setMatrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.box.width());
            }
        }
        if (this.backgroundColor != null) {
            app.setColorFill(this.backgroundColor);
            app.rectangle(0.0f, 0.0f, this.box.width(), this.box.height());
            app.fill();
        }
        if (this.borderStyle == 4) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                app.setColorStroke(this.borderColor);
                app.setLineWidth(this.borderWidth);
                app.moveTo(0.0f, this.borderWidth / 2.0f);
                app.lineTo(this.box.width(), this.borderWidth / 2.0f);
                app.stroke();
            }
        } else if (this.borderStyle == 2) {
            Color actual;
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                app.setColorStroke(this.borderColor);
                app.setLineWidth(this.borderWidth);
                app.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                app.stroke();
            }
            if ((actual = this.backgroundColor) == null) {
                actual = Color.white;
            }
            app.setGrayFill(1.0f);
            this.drawTopFrame(app);
            app.setColorFill(actual.darker());
            this.drawBottomFrame(app);
        } else if (this.borderStyle == 3) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                app.setColorStroke(this.borderColor);
                app.setLineWidth(this.borderWidth);
                app.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                app.stroke();
            }
            app.setGrayFill(0.5f);
            this.drawTopFrame(app);
            app.setGrayFill(0.75f);
            this.drawBottomFrame(app);
        } else if (this.borderWidth != 0.0f && this.borderColor != null) {
            if (this.borderStyle == 1) {
                app.setLineDash(3.0f, 0.0f);
            }
            app.setColorStroke(this.borderColor);
            app.setLineWidth(this.borderWidth);
            app.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
            app.stroke();
            if ((this.options & 0x100) != 0 && this.maxCharacterLength > 1) {
                float step = this.box.width() / (float)this.maxCharacterLength;
                float yb = this.borderWidth / 2.0f;
                float yt = this.box.height() - this.borderWidth / 2.0f;
                int k = 1;
                while (k < this.maxCharacterLength) {
                    float x = step * (float)k;
                    app.moveTo(x, yb);
                    app.lineTo(x, yt);
                    ++k;
                }
                app.stroke();
            }
        }
        return app;
    }

    public PdfAppearance getAppearance() throws IOException, DocumentException {
        PdfAppearance app = this.getBorderAppearance();
        app.beginVariableText();
        if (this.text == null || this.text.length() == 0) {
            app.endVariableText();
            return app;
        }
        BaseFont ufont = this.getRealFont();
        boolean borderExtra = this.borderStyle == 2 || this.borderStyle == 3;
        float h = this.box.height() - this.borderWidth * 2.0f;
        float bw2 = this.borderWidth;
        if (borderExtra) {
            h -= this.borderWidth * 2.0f;
            bw2 *= 2.0f;
        }
        float offsetX = borderExtra ? 2.0f * this.borderWidth : this.borderWidth;
        offsetX = Math.max(offsetX, 1.0f);
        float offX = Math.min(bw2, offsetX);
        app.saveState();
        app.rectangle(offX, offX, this.box.width() - 2.0f * offX, this.box.height() - 2.0f * offX);
        app.clip();
        app.newPath();
        if (this.textColor == null) {
            app.setGrayFill(0.0f);
        } else {
            app.setColorFill(this.textColor);
        }
        app.beginText();
        if ((this.options & 4) != 0) {
            float wd;
            ArrayList breaks;
            float usize = this.fontSize;
            float width = this.box.width() - 3.0f * offsetX;
            ArrayList lines = breaks = TextField.getHardBreaks(this.text);
            float factor = ufont.getFontDescriptor(8, 1.0f) - ufont.getFontDescriptor(6, 1.0f);
            if (usize == 0.0f) {
                usize = h / (float)breaks.size() / factor;
                if (usize > 4.0f) {
                    if (usize > 12.0f) {
                        usize = 12.0f;
                    }
                    float step = Math.max((usize - 4.0f) / 10.0f, 0.2f);
                    while (usize > 4.0f) {
                        lines = TextField.breakLines(breaks, ufont, usize, width);
                        if ((float)lines.size() * usize * factor <= h) break;
                        usize -= step;
                    }
                }
                if (usize <= 4.0f) {
                    usize = 4.0f;
                    lines = TextField.breakLines(breaks, ufont, usize, width);
                }
            } else {
                lines = TextField.breakLines(breaks, ufont, usize, width);
            }
            app.setFontAndSize(ufont, usize);
            app.setLeading(usize * factor);
            float offsetY = offsetX + h - ufont.getFontDescriptor(8, usize);
            String nt = (String)lines.get(0);
            if (this.alignment == 2) {
                wd = ufont.getWidthPoint(nt, usize);
                app.moveText(this.box.width() - 2.0f * offsetX - wd, offsetY);
            } else if (this.alignment == 1) {
                nt = nt.trim();
                wd = ufont.getWidthPoint(nt, usize);
                app.moveText(this.box.width() / 2.0f - wd / 2.0f, offsetY);
            } else {
                app.moveText(2.0f * offsetX, offsetY);
            }
            app.showText(nt);
            int maxline = (int)(h / usize / factor) + 1;
            maxline = Math.min(maxline, lines.size());
            int k = 1;
            while (k < maxline) {
                float wd2;
                nt = (String)lines.get(k);
                if (this.alignment == 2) {
                    wd2 = ufont.getWidthPoint(nt, usize);
                    app.moveText(this.box.width() - 2.0f * offsetX - wd2 - app.getXTLM(), 0.0f);
                } else if (this.alignment == 1) {
                    nt = nt.trim();
                    wd2 = ufont.getWidthPoint(nt, usize);
                    app.moveText(this.box.width() / 2.0f - wd2 / 2.0f - app.getXTLM(), 0.0f);
                }
                app.newlineShowText(nt);
                ++k;
            }
        } else {
            float wd;
            float usize = this.fontSize;
            if (usize == 0.0f) {
                float maxCalculatedSize = h / (ufont.getFontDescriptor(7, 1.0f) - ufont.getFontDescriptor(6, 1.0f));
                wd = ufont.getWidthPoint(this.text, 1.0f);
                usize = wd == 0.0f ? maxCalculatedSize : (this.box.width() - 2.0f * offsetX) / wd;
                if (usize > maxCalculatedSize) {
                    usize = maxCalculatedSize;
                }
                if (usize < 4.0f) {
                    usize = 4.0f;
                }
            }
            app.setFontAndSize(ufont, usize);
            float offsetY = offX + (this.box.height() - 2.0f * offX - ufont.getFontDescriptor(1, usize)) / 2.0f;
            if (offsetY < offX) {
                offsetY = offX;
            }
            if (offsetY - offX < -ufont.getFontDescriptor(3, usize)) {
                float ny = -ufont.getFontDescriptor(3, usize) + offX;
                float dy = this.box.height() - offX - ufont.getFontDescriptor(1, usize);
                offsetY = Math.min(ny, Math.max(offsetY, dy));
            }
            if ((this.options & 0x100) != 0 && this.maxCharacterLength > 0) {
                int textLen = Math.min(this.maxCharacterLength, this.text.length());
                int position = 0;
                if (this.alignment == 2) {
                    position = this.maxCharacterLength - textLen;
                } else if (this.alignment == 1) {
                    position = (this.maxCharacterLength - textLen) / 2;
                }
                float step = this.box.width() / (float)this.maxCharacterLength;
                float start = step / 2.0f + (float)position * step;
                int k = 0;
                while (k < textLen) {
                    String c = this.text.substring(k, k + 1);
                    float wd3 = ufont.getWidthPoint(c, usize);
                    app.setTextMatrix(start - wd3 / 2.0f, offsetY);
                    app.showText(c);
                    start += step;
                    ++k;
                }
            } else {
                if (this.alignment == 2) {
                    wd = ufont.getWidthPoint(this.text, usize);
                    app.moveText(this.box.width() - 2.0f * offsetX - wd, offsetY);
                } else if (this.alignment == 1) {
                    wd = ufont.getWidthPoint(this.text, usize);
                    app.moveText(this.box.width() / 2.0f - wd / 2.0f, offsetY);
                } else {
                    app.moveText(2.0f * offsetX, offsetY);
                }
                app.showText(this.text);
            }
        }
        app.endText();
        app.restoreState();
        app.endVariableText();
        return app;
    }

    PdfAppearance getListAppearance() throws IOException, DocumentException {
        PdfAppearance app = this.getBorderAppearance();
        app.beginVariableText();
        if (this.choices == null || this.choices.length == 0) {
            app.endVariableText();
            return app;
        }
        int topChoice = this.choiceSelection;
        if (topChoice >= this.choices.length) {
            topChoice = this.choices.length - 1;
        }
        if (topChoice < 0) {
            topChoice = 0;
        }
        BaseFont ufont = this.getRealFont();
        float usize = this.fontSize;
        if (usize == 0.0f) {
            usize = 12.0f;
        }
        boolean borderExtra = this.borderStyle == 2 || this.borderStyle == 3;
        float h = this.box.height() - this.borderWidth * 2.0f;
        if (borderExtra) {
            h -= this.borderWidth * 2.0f;
        }
        float offsetX = borderExtra ? 2.0f * this.borderWidth : this.borderWidth;
        float leading = ufont.getFontDescriptor(8, usize) - ufont.getFontDescriptor(6, usize);
        int maxFit = (int)(h / leading) + 1;
        int first = 0;
        int last = 0;
        last = topChoice + maxFit / 2 + 1;
        first = last - maxFit;
        if (first < 0) {
            last += first;
            first = 0;
        }
        if ((last = first + maxFit) > this.choices.length) {
            last = this.choices.length;
        }
        this.topFirst = first;
        app.saveState();
        app.rectangle(offsetX, offsetX, this.box.width() - 2.0f * offsetX, this.box.height() - 2.0f * offsetX);
        app.clip();
        app.newPath();
        Color mColor = this.textColor == null ? new GrayColor(0) : this.textColor;
        app.setColorFill(new Color(10, 36, 106));
        app.rectangle(offsetX, offsetX + h - (float)(topChoice - first + 1) * leading, this.box.width() - 2.0f * offsetX, leading);
        app.fill();
        app.beginText();
        app.setFontAndSize(ufont, usize);
        app.setLeading(leading);
        app.moveText(offsetX * 2.0f, offsetX + h - ufont.getFontDescriptor(8, usize) + leading);
        app.setColorFill(mColor);
        int idx = first;
        while (idx < last) {
            if (idx == topChoice) {
                app.setGrayFill(1.0f);
                app.newlineShowText(this.choices[idx]);
                app.setColorFill(mColor);
            } else {
                app.newlineShowText(this.choices[idx]);
            }
            ++idx;
        }
        app.endText();
        app.restoreState();
        app.endVariableText();
        return app;
    }

    protected static ArrayList getHardBreaks(String text) {
        ArrayList<String> arr = new ArrayList<String>();
        char[] cs = text.toCharArray();
        int len = cs.length;
        StringBuffer buf = new StringBuffer();
        int k = 0;
        while (k < len) {
            char c = cs[k];
            if (c == '\r') {
                if (k + 1 < len && cs[k + 1] == '\n') {
                    ++k;
                }
                arr.add(buf.toString());
                buf = new StringBuffer();
            } else if (c == '\n') {
                arr.add(buf.toString());
                buf = new StringBuffer();
            } else {
                buf.append(c);
            }
            ++k;
        }
        arr.add(buf.toString());
        return arr;
    }

    protected static void trimRight(StringBuffer buf) {
        int len = buf.length();
        while (len != 0) {
            if (buf.charAt(--len) != ' ') {
                return;
            }
            buf.setLength(len);
        }
        return;
    }

    protected static ArrayList breakLines(ArrayList breaks, BaseFont font, float fontSize, float width) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        int ck = 0;
        while (ck < breaks.size()) {
            buf.setLength(0);
            float w = 0.0f;
            char[] cs = ((String)breaks.get(ck)).toCharArray();
            int len = cs.length;
            int state = 0;
            int lastspace = -1;
            char c = '\u0000';
            int refk = 0;
            int k = 0;
            while (k < len) {
                c = cs[k];
                switch (state) {
                    case 0: {
                        w += font.getWidthPoint(c, fontSize);
                        buf.append(c);
                        if (w > width) {
                            w = 0.0f;
                            if (buf.length() > 1) {
                                buf.setLength(buf.length() - 1);
                            }
                            lines.add(buf.toString());
                            buf.setLength(0);
                            refk = --k;
                            if (c == ' ') {
                                state = 2;
                                break;
                            }
                            state = 1;
                            break;
                        }
                        if (c == ' ') break;
                        state = 1;
                        break;
                    }
                    case 1: {
                        w += font.getWidthPoint(c, fontSize);
                        buf.append(c);
                        if (c == ' ') {
                            lastspace = k;
                        }
                        if (!(w > width)) break;
                        w = 0.0f;
                        if (lastspace >= 0) {
                            k = lastspace;
                            buf.setLength(lastspace - refk);
                            TextField.trimRight(buf);
                            lines.add(buf.toString());
                            buf.setLength(0);
                            refk = k;
                            lastspace = -1;
                            state = 2;
                            break;
                        }
                        if (buf.length() > 1) {
                            buf.setLength(buf.length() - 1);
                        }
                        lines.add(buf.toString());
                        buf.setLength(0);
                        refk = --k;
                        if (c != ' ') break;
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (c == ' ') break;
                        w = 0.0f;
                        --k;
                        state = 1;
                    }
                }
                ++k;
            }
            TextField.trimRight(buf);
            lines.add(buf.toString());
            ++ck;
        }
        return lines;
    }

    public PdfFormField getTextField() throws IOException, DocumentException {
        if (this.maxCharacterLength <= 0) {
            this.options &= 0xFFFFFEFF;
        }
        if ((this.options & 0x100) != 0) {
            this.options &= 0xFFFFFFFB;
        }
        PdfFormField field = PdfFormField.createTextField(this.writer, false, false, this.maxCharacterLength);
        field.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        field.setFieldName(this.fieldName);
        switch (this.alignment) {
            case 1: {
                field.setQuadding(1);
                break;
            }
            case 2: {
                field.setQuadding(2);
            }
        }
        if (this.rotation != 0) {
            field.setMKRotation(this.rotation);
        }
        field.setValueAsString(this.text);
        if (this.defaultText != null) {
            field.setDefaultValueAsString(this.defaultText);
        }
        field.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance tp = this.getAppearance();
        field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, tp);
        PdfAppearance da = (PdfAppearance)tp.getDuplicate();
        da.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            da.setGrayFill(0.0f);
        } else {
            da.setColorFill(this.textColor);
        }
        field.setDefaultAppearanceString(da);
        if (this.borderColor != null) {
            field.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            field.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                field.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                field.setFlags(36);
                break;
            }
            default: {
                field.setFlags(4);
            }
        }
        if ((this.options & 1) != 0) {
            field.setFieldFlags(1);
        }
        if ((this.options & 2) != 0) {
            field.setFieldFlags(2);
        }
        if ((this.options & 4) != 0) {
            field.setFieldFlags(4096);
        }
        if ((this.options & 8) != 0) {
            field.setFieldFlags(0x800000);
        }
        if ((this.options & 0x10) != 0) {
            field.setFieldFlags(8192);
        }
        if ((this.options & 0x20) != 0) {
            field.setFieldFlags(0x100000);
        }
        if ((this.options & 0x40) != 0) {
            field.setFieldFlags(0x400000);
        }
        if ((this.options & 0x100) != 0) {
            field.setFieldFlags(0x1000000);
        }
        return field;
    }

    public PdfFormField getComboField() throws IOException, DocumentException {
        return this.getChoiceField(false);
    }

    public PdfFormField getListField() throws IOException, DocumentException {
        return this.getChoiceField(true);
    }

    protected PdfFormField getChoiceField(boolean isList) throws IOException, DocumentException {
        PdfAppearance tp;
        int topChoice;
        this.options &= 0xFFFFFEFB;
        String[] uchoices = this.choices;
        if (uchoices == null) {
            uchoices = new String[]{};
        }
        if ((topChoice = this.choiceSelection) >= uchoices.length) {
            topChoice = uchoices.length - 1;
        }
        this.text = "";
        if (topChoice >= 0) {
            this.text = uchoices[topChoice];
        }
        if (topChoice < 0) {
            topChoice = 0;
        }
        PdfFormField field = null;
        String[][] mix = null;
        if (this.choiceExports == null) {
            field = isList ? PdfFormField.createList(this.writer, uchoices, topChoice) : PdfFormField.createCombo(this.writer, (this.options & 0x80) != 0, uchoices, topChoice);
        } else {
            mix = new String[uchoices.length][2];
            int k = 0;
            while (k < mix.length) {
                String string = uchoices[k];
                mix[k][1] = string;
                mix[k][0] = string;
                ++k;
            }
            int top = Math.min(uchoices.length, this.choiceExports.length);
            int k2 = 0;
            while (k2 < top) {
                if (this.choiceExports[k2] != null) {
                    mix[k2][0] = this.choiceExports[k2];
                }
                ++k2;
            }
            field = isList ? PdfFormField.createList(this.writer, mix, topChoice) : PdfFormField.createCombo(this.writer, (this.options & 0x80) != 0, mix, topChoice);
        }
        field.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        field.setFieldName(this.fieldName);
        if (this.rotation != 0) {
            field.setMKRotation(this.rotation);
        }
        if (uchoices.length > 0) {
            if (mix != null) {
                field.setValueAsString(mix[topChoice][0]);
                field.setDefaultValueAsString(mix[topChoice][0]);
            } else {
                field.setValueAsString(this.text);
                field.setDefaultValueAsString(this.text);
            }
        }
        field.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        if (isList) {
            tp = this.getListAppearance();
            if (this.topFirst > 0) {
                field.put(PdfName.TI, new PdfNumber(this.topFirst));
            }
        } else {
            tp = this.getAppearance();
        }
        field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, tp);
        PdfAppearance da = (PdfAppearance)tp.getDuplicate();
        da.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            da.setGrayFill(0.0f);
        } else {
            da.setColorFill(this.textColor);
        }
        field.setDefaultAppearanceString(da);
        if (this.borderColor != null) {
            field.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            field.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                field.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                field.setFlags(36);
                break;
            }
            default: {
                field.setFlags(4);
            }
        }
        if ((this.options & 1) != 0) {
            field.setFieldFlags(1);
        }
        if ((this.options & 2) != 0) {
            field.setFieldFlags(2);
        }
        if ((this.options & 0x40) != 0) {
            field.setFieldFlags(0x400000);
        }
        return field;
    }

    private void drawTopFrame(PdfAppearance app) {
        app.moveTo(this.borderWidth, this.borderWidth);
        app.lineTo(this.borderWidth, this.box.height() - this.borderWidth);
        app.lineTo(this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
        app.lineTo(this.box.width() - 2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        app.lineTo(2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        app.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        app.lineTo(this.borderWidth, this.borderWidth);
        app.fill();
    }

    private void drawBottomFrame(PdfAppearance app) {
        app.moveTo(this.borderWidth, this.borderWidth);
        app.lineTo(this.box.width() - this.borderWidth, this.borderWidth);
        app.lineTo(this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
        app.lineTo(this.box.width() - 2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        app.lineTo(this.box.width() - 2.0f * this.borderWidth, 2.0f * this.borderWidth);
        app.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        app.lineTo(this.borderWidth, this.borderWidth);
        app.fill();
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public BaseFont getFont() {
        return this.font;
    }

    public void setFont(BaseFont font) {
        this.font = font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Rectangle getBox() {
        return this.box;
    }

    public void setBox(Rectangle box) {
        this.box = box;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("Rotation must be a multiple of 90.");
        }
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        this.rotation = rotation;
    }

    public void setRotationFromPage(Rectangle page) {
        this.setRotation(page.getRotation());
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setVisibility(int visibility) {
        this.visibility = visibility;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public int getMaxCharacterLength() {
        return this.maxCharacterLength;
    }

    public void setMaxCharacterLength(int maxCharacterLength) {
        this.maxCharacterLength = maxCharacterLength;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public void setChoices(String[] choices) {
        this.choices = choices;
    }

    public String[] getChoiceExports() {
        return this.choiceExports;
    }

    public void setChoiceExports(String[] choiceExports) {
        this.choiceExports = choiceExports;
    }

    public int getChoiceSelection() {
        return this.choiceSelection;
    }

    public void setChoiceSelection(int choiceSelection) {
        this.choiceSelection = choiceSelection;
    }

    int getTopFirst() {
        return this.topFirst;
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PdfWriter writer) {
        this.writer = writer;
    }
}

