/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.FdfWriter;
import com.lowagie.text.pdf.FontDetails;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TextField;
import com.lowagie.text.pdf.XfdfReader;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AcroFields {
    PdfReader reader;
    PdfWriter writer;
    HashMap fields;
    private int topFirst;
    private HashMap sigNames;
    private boolean append;
    private static final int DA_FONT = 0;
    private static final int DA_SIZE = 1;
    private static final int DA_COLOR = 2;
    private HashMap extensionFonts = new HashMap();
    public static final int FIELD_TYPE_NONE = 0;
    public static final int FIELD_TYPE_PUSHBUTTON = 1;
    public static final int FIELD_TYPE_CHECKBOX = 2;
    public static final int FIELD_TYPE_RADIOBUTTON = 3;
    public static final int FIELD_TYPE_TEXT = 4;
    public static final int FIELD_TYPE_LIST = 5;
    public static final int FIELD_TYPE_COMBO = 6;
    public static final int FIELD_TYPE_SIGNATURE = 7;
    private boolean lastWasString;
    private boolean generateAppearances = true;
    private HashMap localFonts = new HashMap();
    private float extraMarginLeft;
    private float extraMarginTop;
    private ArrayList substitutionFonts;
    private static final HashMap stdFieldFontNames = new HashMap();
    private int totalRevisions;
    private HashMap fieldCache;

    AcroFields(PdfReader pdfReader, PdfWriter pdfWriter) {
        this.reader = pdfReader;
        this.writer = pdfWriter;
        if (pdfWriter instanceof PdfStamperImp) {
            this.append = ((PdfStamperImp)pdfWriter).isAppend();
        }
        this.fill();
    }

    void fill() {
        this.fields = new HashMap();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (pdfDictionary == null) {
            return;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.FIELDS));
        if (pdfArray == null || pdfArray.size() == 0) {
            return;
        }
        pdfArray = null;
        for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
            PdfDictionary pdfDictionary2;
            PdfArray pdfArray2;
            if (i % 100 == 0) {
                System.out.println(i);
            }
            if ((pdfArray2 = (PdfArray)PdfReader.getPdfObjectRelease((pdfDictionary2 = this.reader.getPageNRelease(i)).get(PdfName.ANNOTS), pdfDictionary2)) == null) continue;
            ArrayList arrayList = pdfArray2.getArrayList();
            for (int j = 0; j < arrayList.size(); ++j) {
                Object object;
                PdfObject pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(j), pdfArray2);
                if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect()) {
                    PdfReader.releaseLastXrefPartial((PdfObject)arrayList.get(j));
                    continue;
                }
                PdfDictionary pdfDictionary3 = (PdfDictionary)pdfObject;
                if (!PdfName.WIDGET.equals(pdfDictionary3.get(PdfName.SUBTYPE))) {
                    PdfReader.releaseLastXrefPartial((PdfObject)arrayList.get(j));
                    continue;
                }
                PdfDictionary pdfDictionary4 = pdfDictionary3;
                PdfDictionary pdfDictionary5 = new PdfDictionary();
                pdfDictionary5.putAll(pdfDictionary3);
                String string = "";
                PdfDictionary pdfDictionary6 = null;
                PdfObject pdfObject2 = null;
                while (pdfDictionary3 != null) {
                    pdfDictionary5.mergeDifferent(pdfDictionary3);
                    object = (PdfString)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.T));
                    if (object != null) {
                        string = ((PdfString)object).toUnicodeString() + "." + string;
                    }
                    if (pdfObject2 == null && pdfDictionary3.get(PdfName.V) != null) {
                        pdfObject2 = PdfReader.getPdfObjectRelease(pdfDictionary3.get(PdfName.V));
                    }
                    if (pdfDictionary6 == null && object != null) {
                        pdfDictionary6 = pdfDictionary3;
                        if (pdfDictionary3.get(PdfName.V) == null && pdfObject2 != null) {
                            pdfDictionary6.put(PdfName.V, pdfObject2);
                        }
                    }
                    pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.PARENT), pdfDictionary3);
                }
                if (string.length() > 0) {
                    string = string.substring(0, string.length() - 1);
                }
                if ((object = (Item)this.fields.get(string)) == null) {
                    object = new Item();
                    this.fields.put(string, object);
                }
                if (pdfDictionary6 == null) {
                    ((Item)object).values.add(pdfDictionary4);
                } else {
                    ((Item)object).values.add(pdfDictionary6);
                }
                ((Item)object).widgets.add(pdfDictionary4);
                ((Item)object).widget_refs.add(arrayList.get(j));
                if (pdfDictionary != null) {
                    pdfDictionary5.mergeDifferent(pdfDictionary);
                }
                ((Item)object).merged.add(pdfDictionary5);
                ((Item)object).page.add(new Integer(i));
                ((Item)object).tabOrder.add(new Integer(j));
            }
        }
    }

    public String[] getAppearanceStates(String string) {
        PdfObject pdfObject;
        int n;
        ArrayList arrayList;
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        PdfDictionary pdfDictionary = (PdfDictionary)item.values.get(0);
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.OPT));
        if (pdfObject2 != null) {
            if (pdfObject2.isString()) {
                hashMap.put(((PdfString)pdfObject2).toUnicodeString(), null);
            } else if (pdfObject2.isArray()) {
                arrayList = ((PdfArray)pdfObject2).getArrayList();
                for (n = 0; n < arrayList.size(); ++n) {
                    pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                    if (pdfObject == null || !pdfObject.isString()) continue;
                    hashMap.put(((PdfString)pdfObject).toUnicodeString(), null);
                }
            }
        }
        arrayList = item.widgets;
        for (n = 0; n < arrayList.size(); ++n) {
            PdfObject pdfObject3;
            pdfObject = (PdfDictionary)arrayList.get(n);
            if ((pdfObject = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.AP))) == null || (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.N))) == null || !pdfObject3.isDictionary()) continue;
            pdfObject = (PdfDictionary)pdfObject3;
            Iterator iterator = ((PdfDictionary)pdfObject).getKeys().iterator();
            while (iterator.hasNext()) {
                String string2 = PdfName.decodeName(((PdfName)iterator.next()).toString());
                hashMap.put(string2, null);
            }
        }
        String[] stringArray = new String[hashMap.size()];
        return hashMap.keySet().toArray(stringArray);
    }

    private String[] getListOption(String string, int n) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.OPT));
        if (pdfObject == null || !pdfObject.isArray()) {
            return null;
        }
        PdfArray pdfArray = (PdfArray)pdfObject;
        String[] stringArray = new String[pdfArray.size()];
        ArrayList arrayList = pdfArray.getArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(i));
            try {
                if (pdfObject.isArray()) {
                    pdfObject = (PdfObject)((PdfArray)pdfObject).getArrayList().get(n);
                }
                if (pdfObject.isString()) {
                    stringArray[i] = ((PdfString)pdfObject).toUnicodeString();
                    continue;
                }
                stringArray[i] = pdfObject.toString();
                continue;
            }
            catch (Exception exception) {
                stringArray[i] = "";
            }
        }
        return stringArray;
    }

    public String[] getListOptionExport(String string) {
        return this.getListOption(string, 0);
    }

    public String[] getListOptionDisplay(String string) {
        return this.getListOption(string, 1);
    }

    public boolean setListOption(String string, String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray == null && stringArray2 == null) {
            return false;
        }
        if (stringArray != null && stringArray2 != null && stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("The export and the display array must have the same size.");
        }
        int n2 = this.getFieldType(string);
        if (n2 != 6 && n2 != 5) {
            return false;
        }
        Item item = (Item)this.fields.get(string);
        String[] stringArray3 = null;
        if (stringArray == null && stringArray2 != null) {
            stringArray3 = stringArray2;
        } else if (stringArray != null && stringArray2 == null) {
            stringArray3 = stringArray;
        }
        PdfArray pdfArray = new PdfArray();
        if (stringArray3 != null) {
            for (n = 0; n < stringArray3.length; ++n) {
                pdfArray.add(new PdfString(stringArray3[n], "UnicodeBig"));
            }
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                PdfArray pdfArray2 = new PdfArray();
                pdfArray2.add(new PdfString(stringArray[n], "UnicodeBig"));
                pdfArray2.add(new PdfString(stringArray2[n], "UnicodeBig"));
                pdfArray.add(pdfArray2);
            }
        }
        ((PdfDictionary)item.values.get(0)).put(PdfName.OPT, pdfArray);
        for (n = 0; n < item.merged.size(); ++n) {
            ((PdfDictionary)item.merged.get(n)).put(PdfName.OPT, pdfArray);
        }
        return true;
    }

    public int getFieldType(String string) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return 0;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (pdfObject == null) {
            return 0;
        }
        int n = 0;
        PdfObject pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
        if (pdfObject2 != null && pdfObject2.type() == 2) {
            n = ((PdfNumber)pdfObject2).intValue();
        }
        if (PdfName.BTN.equals(pdfObject)) {
            if ((n & 0x10000) != 0) {
                return 1;
            }
            if ((n & 0x8000) != 0) {
                return 3;
            }
            return 2;
        }
        if (PdfName.TX.equals(pdfObject)) {
            return 4;
        }
        if (PdfName.CH.equals(pdfObject)) {
            if ((n & 0x20000) != 0) {
                return 6;
            }
            return 5;
        }
        if (PdfName.SIG.equals(pdfObject)) {
            return 7;
        }
        return 0;
    }

    public void exportAsFdf(FdfWriter fdfWriter) {
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Item item = (Item)entry.getValue();
            String string = (String)entry.getKey();
            PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
            if (pdfObject == null) continue;
            String string2 = this.getField(string);
            if (this.lastWasString) {
                fdfWriter.setFieldAsString(string, string2);
                continue;
            }
            fdfWriter.setFieldAsName(string, string2);
        }
    }

    public boolean renameField(String string, String string2) {
        int n;
        int n2 = string.lastIndexOf(46) + 1;
        if (n2 != (n = string2.lastIndexOf(46) + 1)) {
            return false;
        }
        if (!string.substring(0, n2).equals(string2.substring(0, n))) {
            return false;
        }
        if (this.fields.containsKey(string2)) {
            return false;
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        string2 = string2.substring(n);
        PdfString pdfString = new PdfString(string2, "UnicodeBig");
        for (int i = 0; i < item.merged.size(); ++i) {
            PdfDictionary pdfDictionary = (PdfDictionary)item.values.get(i);
            pdfDictionary.put(PdfName.T, pdfString);
            this.markUsed(pdfDictionary);
            pdfDictionary = (PdfDictionary)item.merged.get(i);
            pdfDictionary.put(PdfName.T, pdfString);
        }
        this.fields.remove(string);
        this.fields.put(string2, item);
        return true;
    }

    private static Object[] splitDAelements(String string) {
        try {
            PRTokeniser pRTokeniser = new PRTokeniser(PdfEncodings.convertToBytes(string, null));
            ArrayList<String> arrayList = new ArrayList<String>();
            Object[] objectArray = new Object[3];
            while (pRTokeniser.nextToken()) {
                if (pRTokeniser.getTokenType() == 4) continue;
                if (pRTokeniser.getTokenType() == 10) {
                    float f;
                    float f2;
                    float f3;
                    String string2 = pRTokeniser.getStringValue();
                    if (string2.equals("Tf")) {
                        if (arrayList.size() >= 2) {
                            objectArray[0] = arrayList.get(arrayList.size() - 2);
                            objectArray[1] = new Float((String)arrayList.get(arrayList.size() - 1));
                        }
                    } else if (string2.equals("g")) {
                        if (arrayList.size() >= 1 && (f3 = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue()) != 0.0f) {
                            objectArray[2] = new GrayColor(f3);
                        }
                    } else if (string2.equals("rg")) {
                        if (arrayList.size() >= 3) {
                            f3 = new Float((String)arrayList.get(arrayList.size() - 3)).floatValue();
                            f2 = new Float((String)arrayList.get(arrayList.size() - 2)).floatValue();
                            f = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue();
                            objectArray[2] = new Color(f3, f2, f);
                        }
                    } else if (string2.equals("k") && arrayList.size() >= 4) {
                        f3 = new Float((String)arrayList.get(arrayList.size() - 4)).floatValue();
                        f2 = new Float((String)arrayList.get(arrayList.size() - 3)).floatValue();
                        f = new Float((String)arrayList.get(arrayList.size() - 2)).floatValue();
                        float f4 = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue();
                        objectArray[2] = new CMYKColor(f3, f2, f, f4);
                    }
                    arrayList.clear();
                    continue;
                }
                arrayList.add(pRTokeniser.getStringValue());
            }
            return objectArray;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    PdfAppearance getAppearance(PdfDictionary pdfDictionary, String string, String string2) throws IOException, DocumentException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        PdfObject pdfObject;
        this.topFirst = 0;
        int n = 0;
        TextField textField = null;
        if (this.fieldCache == null || !this.fieldCache.containsKey(string2)) {
            Object object7;
            Object object8;
            textField = new TextField(this.writer, null, null);
            textField.setExtraMargin(this.extraMarginLeft, this.extraMarginTop);
            textField.setBorderWidth(0.0f);
            textField.setSubstitutionFonts(this.substitutionFonts);
            pdfObject = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DA));
            if (pdfObject != null) {
                object6 = AcroFields.splitDAelements(((PdfString)pdfObject).toUnicodeString());
                if (object6[1] != null) {
                    textField.setFontSize(((Float)object6[1]).floatValue());
                }
                if (object6[2] != null) {
                    textField.setTextColor((Color)object6[2]);
                }
                if (object6[0] != null && (object5 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DR))) != null && (object5 = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)object5).get(PdfName.FONT))) != null) {
                    object4 = ((PdfDictionary)object5).get(new PdfName((String)object6[0]));
                    if (object4 != null && ((PdfObject)object4).type() == 10) {
                        PdfDictionary pdfDictionary2;
                        PdfDictionary pdfDictionary3;
                        object8 = (PRIndirectReference)object4;
                        object7 = new DocumentFont((PRIndirectReference)object4);
                        textField.setFont((BaseFont)object7);
                        object3 = new Integer(((PdfIndirectReference)object8).getNumber());
                        object2 = (BaseFont)this.extensionFonts.get(object3);
                        if (object2 == null && !this.extensionFonts.containsKey(object3) && (pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject((pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)object4)).get(PdfName.FONTDESCRIPTOR))) != null) {
                            PRStream pRStream = (PRStream)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.FONTFILE2));
                            if (pRStream == null) {
                                pRStream = (PRStream)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.FONTFILE3));
                            }
                            if (pRStream == null) {
                                this.extensionFonts.put(object3, null);
                            } else {
                                try {
                                    object2 = BaseFont.createFont("font.ttf", "Identity-H", true, false, PdfReader.getStreamBytes(pRStream), null);
                                }
                                catch (Exception exception) {
                                    object2 = null;
                                }
                                this.extensionFonts.put(object3, object2);
                            }
                        }
                        textField.setExtensionFont((BaseFont)object2);
                    } else {
                        object8 = (BaseFont)this.localFonts.get(object6[0]);
                        if (object8 == null) {
                            object7 = (String[])stdFieldFontNames.get(object6[0]);
                            if (object7 != null) {
                                try {
                                    object3 = "winansi";
                                    if (((Object)object7).length > 1) {
                                        object3 = object7[1];
                                    }
                                    object8 = BaseFont.createFont((String)object7[0], (String)object3, false);
                                    textField.setFont((BaseFont)object8);
                                }
                                catch (Exception exception) {}
                            }
                        } else {
                            textField.setFont((BaseFont)object8);
                        }
                    }
                }
            }
            if ((object6 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MK))) != null) {
                object5 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object6).get(PdfName.BC));
                object4 = this.getMKColor((PdfArray)object5);
                textField.setBorderColor((Color)object4);
                if (object4 != null) {
                    textField.setBorderWidth(1.0f);
                }
                object5 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object6).get(PdfName.BG));
                textField.setBackgroundColor(this.getMKColor((PdfArray)object5));
                object8 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object6).get(PdfName.R));
                if (object8 != null) {
                    textField.setRotation(((PdfNumber)object8).intValue());
                }
            }
            if ((object5 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FF))) != null) {
                n = ((PdfNumber)object5).intValue();
            }
            textField.setOptions(((n & 0x1000) == 0 ? 0 : 4) | ((n & 0x1000000) == 0 ? 0 : 256));
            if ((n & 0x1000000) != 0) {
                object4 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MAXLEN));
                int n2 = 0;
                if (object4 != null) {
                    n2 = ((PdfNumber)object4).intValue();
                }
                textField.setMaxCharacterLength(n2);
            }
            if ((object5 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.Q))) != null) {
                if (((PdfNumber)object5).intValue() == 1) {
                    textField.setAlignment(1);
                } else if (((PdfNumber)object5).intValue() == 2) {
                    textField.setAlignment(2);
                }
            }
            if ((object4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BS))) != null) {
                object = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.W));
                if (object != null) {
                    textField.setBorderWidth(((PdfNumber)object).floatValue());
                }
                if (PdfName.D.equals(object7 = (PdfName)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.S)))) {
                    textField.setBorderStyle(1);
                } else if (PdfName.B.equals(object7)) {
                    textField.setBorderStyle(2);
                } else if (PdfName.I.equals(object7)) {
                    textField.setBorderStyle(3);
                } else if (PdfName.U.equals(object7)) {
                    textField.setBorderStyle(4);
                }
            } else {
                object = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BORDER));
                if (object != null) {
                    object7 = ((PdfArray)object).getArrayList();
                    if (((ArrayList)object7).size() >= 3) {
                        textField.setBorderWidth(((PdfNumber)((ArrayList)object7).get(2)).floatValue());
                    }
                    if (((ArrayList)object7).size() >= 4) {
                        textField.setBorderStyle(1);
                    }
                }
            }
            object = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT));
            object7 = PdfReader.getNormalizedRectangle((PdfArray)object);
            if (textField.getRotation() == 90 || textField.getRotation() == 270) {
                object7 = ((Rectangle)object7).rotate();
            }
            textField.setBox((Rectangle)object7);
            if (this.fieldCache != null) {
                this.fieldCache.put(string2, textField);
            }
        } else {
            textField = (TextField)this.fieldCache.get(string2);
            textField.setWriter(this.writer);
        }
        if (PdfName.TX.equals(pdfObject = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FT)))) {
            textField.setText(string);
            return textField.getAppearance();
        }
        if (!PdfName.CH.equals(pdfObject)) {
            throw new DocumentException("An appearance was requested without a variable text field.");
        }
        object6 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.OPT));
        if ((n & 0x20000) != 0 && object6 == null) {
            textField.setText(string);
            return textField.getAppearance();
        }
        if (object6 != null) {
            int n3;
            object5 = ((PdfArray)object6).getArrayList();
            object4 = new String[((ArrayList)object5).size()];
            object = new String[((ArrayList)object5).size()];
            for (n3 = 0; n3 < ((ArrayList)object5).size(); ++n3) {
                object3 = (PdfObject)((ArrayList)object5).get(n3);
                if (((PdfObject)object3).isString()) {
                    object4[n3] = object[n3] = ((PdfString)object3).toUnicodeString();
                    continue;
                }
                object2 = ((PdfArray)object3).getArrayList();
                object[n3] = ((PdfString)((ArrayList)object2).get(0)).toUnicodeString();
                object4[n3] = ((PdfString)((ArrayList)object2).get(1)).toUnicodeString();
            }
            if ((n & 0x20000) != 0) {
                for (n3 = 0; n3 < ((String[])object4).length; ++n3) {
                    if (!string.equals(object[n3])) continue;
                    string = object4[n3];
                    break;
                }
                textField.setText(string);
                return textField.getAppearance();
            }
            n3 = 0;
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (!string.equals(object[i])) continue;
                n3 = i;
                break;
            }
            textField.setChoices((String[])object4);
            textField.setChoiceExports((String[])object);
            textField.setChoiceSelection(n3);
        }
        object5 = textField.getListAppearance();
        this.topFirst = textField.getTopFirst();
        return object5;
    }

    Color getMKColor(PdfArray pdfArray) {
        if (pdfArray == null) {
            return null;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        switch (arrayList.size()) {
            case 1: {
                return new GrayColor(((PdfNumber)arrayList.get(0)).floatValue());
            }
            case 3: {
                return new Color(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue());
            }
            case 4: {
                return new CMYKColor(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue(), ((PdfNumber)arrayList.get(3)).floatValue());
            }
        }
        return null;
    }

    public String getField(String string) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        this.lastWasString = false;
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
        if (pdfObject == null) {
            return "";
        }
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.BTN.equals(pdfName)) {
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            int n = 0;
            if (pdfNumber != null) {
                n = pdfNumber.intValue();
            }
            if ((n & 0x10000) != 0) {
                return "";
            }
            String string2 = "";
            if (pdfObject.isName()) {
                string2 = PdfName.decodeName(pdfObject.toString());
            } else if (pdfObject.isString()) {
                string2 = ((PdfString)pdfObject).toUnicodeString();
            }
            PdfObject pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)item.values.get(0)).get(PdfName.OPT));
            if (pdfObject2 != null && pdfObject2.isArray()) {
                ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string2);
                    PdfString pdfString = (PdfString)arrayList.get(n2);
                    string2 = pdfString.toUnicodeString();
                    this.lastWasString = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string2;
        }
        if (pdfObject.isString()) {
            this.lastWasString = true;
            return ((PdfString)pdfObject).toUnicodeString();
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    public boolean setFieldProperty(String string, String string2, Object object, int[] nArray) {
        if (this.writer == null) {
            throw new RuntimeException("This AcroFields instance is read-only.");
        }
        try {
            Item item = (Item)this.fields.get(string);
            if (item == null) {
                return false;
            }
            InstHit instHit = new InstHit(nArray);
            if (string2.equalsIgnoreCase("textfont")) {
                for (int i = 0; i < item.merged.size(); ++i) {
                    Object object2;
                    PdfDictionary pdfDictionary;
                    if (!instHit.isHit(i)) continue;
                    PdfString pdfString = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(i)).get(PdfName.DA));
                    PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(i)).get(PdfName.DR));
                    if (pdfString == null || pdfDictionary2 == null) continue;
                    Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                    PdfAppearance pdfAppearance = new PdfAppearance();
                    if (objectArray[0] == null) continue;
                    BaseFont baseFont = (BaseFont)object;
                    PdfName pdfName = (PdfName)PdfAppearance.stdFieldFontNames.get(baseFont.getPostscriptFontName());
                    if (pdfName == null) {
                        pdfName = new PdfName(baseFont.getPostscriptFontName());
                    }
                    if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FONT))) == null) {
                        pdfDictionary = new PdfDictionary();
                        pdfDictionary2.put(PdfName.FONT, pdfDictionary);
                    }
                    PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)pdfDictionary.get(pdfName);
                    PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
                    this.markUsed(pdfDictionary3);
                    pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.DR));
                    if (pdfDictionary2 == null) {
                        pdfDictionary2 = new PdfDictionary();
                        pdfDictionary3.put(PdfName.DR, pdfDictionary2);
                    }
                    this.markUsed(pdfDictionary2);
                    PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FONT));
                    if (pdfDictionary4 == null) {
                        pdfDictionary4 = new PdfDictionary();
                        pdfDictionary2.put(PdfName.FONT, pdfDictionary4);
                    }
                    this.markUsed(pdfDictionary4);
                    PdfIndirectReference pdfIndirectReference2 = (PdfIndirectReference)pdfDictionary4.get(pdfName);
                    if (pdfIndirectReference2 != null) {
                        if (pdfIndirectReference == null) {
                            pdfDictionary.put(pdfName, pdfIndirectReference2);
                        }
                    } else if (pdfIndirectReference == null) {
                        if (baseFont.getFontType() == 4) {
                            object2 = new FontDetails(null, ((DocumentFont)baseFont).getIndirectReference(), baseFont);
                        } else {
                            baseFont.setSubset(false);
                            object2 = this.writer.addSimple(baseFont);
                            this.localFonts.put(pdfName.toString().substring(1), baseFont);
                        }
                        pdfDictionary4.put(pdfName, ((FontDetails)object2).getIndirectReference());
                        pdfDictionary.put(pdfName, ((FontDetails)object2).getIndirectReference());
                    }
                    object2 = pdfAppearance.getInternalBuffer();
                    ((ByteBuffer)object2).append(pdfName.getBytes()).append(' ').append(((Float)objectArray[1]).floatValue()).append(" Tf ");
                    if (objectArray[2] != null) {
                        pdfAppearance.setColorFill((Color)objectArray[2]);
                    }
                    PdfString pdfString2 = new PdfString(pdfAppearance.toString());
                    ((PdfDictionary)item.merged.get(i)).put(PdfName.DA, pdfString2);
                    ((PdfDictionary)item.widgets.get(i)).put(PdfName.DA, pdfString2);
                    this.markUsed((PdfDictionary)item.widgets.get(i));
                }
            } else if (string2.equalsIgnoreCase("textcolor")) {
                for (int i = 0; i < item.merged.size(); ++i) {
                    PdfString pdfString;
                    if (!instHit.isHit(i) || (pdfString = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(i)).get(PdfName.DA))) == null) continue;
                    Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                    PdfAppearance pdfAppearance = new PdfAppearance();
                    if (objectArray[0] == null) continue;
                    ByteBuffer byteBuffer = pdfAppearance.getInternalBuffer();
                    byteBuffer.append(new PdfName((String)objectArray[0]).getBytes()).append(' ').append(((Float)objectArray[1]).floatValue()).append(" Tf ");
                    pdfAppearance.setColorFill((Color)object);
                    PdfString pdfString3 = new PdfString(pdfAppearance.toString());
                    ((PdfDictionary)item.merged.get(i)).put(PdfName.DA, pdfString3);
                    ((PdfDictionary)item.widgets.get(i)).put(PdfName.DA, pdfString3);
                    this.markUsed((PdfDictionary)item.widgets.get(i));
                }
            } else if (string2.equalsIgnoreCase("textsize")) {
                for (int i = 0; i < item.merged.size(); ++i) {
                    PdfString pdfString;
                    if (!instHit.isHit(i) || (pdfString = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(i)).get(PdfName.DA))) == null) continue;
                    Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                    PdfAppearance pdfAppearance = new PdfAppearance();
                    if (objectArray[0] == null) continue;
                    ByteBuffer byteBuffer = pdfAppearance.getInternalBuffer();
                    byteBuffer.append(new PdfName((String)objectArray[0]).getBytes()).append(' ').append(((Float)object).floatValue()).append(" Tf ");
                    if (objectArray[2] != null) {
                        pdfAppearance.setColorFill((Color)objectArray[2]);
                    }
                    PdfString pdfString4 = new PdfString(pdfAppearance.toString());
                    ((PdfDictionary)item.merged.get(i)).put(PdfName.DA, pdfString4);
                    ((PdfDictionary)item.widgets.get(i)).put(PdfName.DA, pdfString4);
                    this.markUsed((PdfDictionary)item.widgets.get(i));
                }
            } else if (string2.equalsIgnoreCase("bgcolor") || string2.equalsIgnoreCase("bordercolor")) {
                PdfName pdfName = string2.equalsIgnoreCase("bgcolor") ? PdfName.BG : PdfName.BC;
                for (int i = 0; i < item.merged.size(); ++i) {
                    if (!instHit.isHit(i)) continue;
                    PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(i)).get(PdfName.MK));
                    this.markUsed(pdfObject);
                    PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                    if (pdfDictionary == null) {
                        if (object == null) {
                            return true;
                        }
                        pdfDictionary = new PdfDictionary();
                        ((PdfDictionary)item.merged.get(i)).put(PdfName.MK, pdfDictionary);
                        ((PdfDictionary)item.widgets.get(i)).put(PdfName.MK, pdfDictionary);
                        this.markUsed((PdfDictionary)item.widgets.get(i));
                    }
                    if (object == null) {
                        pdfDictionary.remove(pdfName);
                        continue;
                    }
                    pdfDictionary.put(pdfName, PdfFormField.getMKColor((Color)object));
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public boolean setFieldProperty(String string, String string2, int n, int[] nArray) {
        if (this.writer == null) {
            throw new RuntimeException("This AcroFields instance is read-only.");
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        InstHit instHit = new InstHit(nArray);
        if (string2.equalsIgnoreCase("flags")) {
            PdfNumber pdfNumber = new PdfNumber(n);
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                ((PdfDictionary)item.merged.get(i)).put(PdfName.F, pdfNumber);
                ((PdfDictionary)item.widgets.get(i)).put(PdfName.F, pdfNumber);
                this.markUsed((PdfDictionary)item.widgets.get(i));
            }
        } else if (string2.equalsIgnoreCase("setflags")) {
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.widgets.get(i)).get(PdfName.F));
                int n2 = 0;
                if (pdfNumber != null) {
                    n2 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n2 | n);
                ((PdfDictionary)item.merged.get(i)).put(PdfName.F, pdfNumber);
                ((PdfDictionary)item.widgets.get(i)).put(PdfName.F, pdfNumber);
                this.markUsed((PdfDictionary)item.widgets.get(i));
            }
        } else if (string2.equalsIgnoreCase("clrflags")) {
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.widgets.get(i)).get(PdfName.F));
                int n3 = 0;
                if (pdfNumber != null) {
                    n3 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n3 & ~n);
                ((PdfDictionary)item.merged.get(i)).put(PdfName.F, pdfNumber);
                ((PdfDictionary)item.widgets.get(i)).put(PdfName.F, pdfNumber);
                this.markUsed((PdfDictionary)item.widgets.get(i));
            }
        } else if (string2.equalsIgnoreCase("fflags")) {
            PdfNumber pdfNumber = new PdfNumber(n);
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                ((PdfDictionary)item.merged.get(i)).put(PdfName.FF, pdfNumber);
                ((PdfDictionary)item.values.get(i)).put(PdfName.FF, pdfNumber);
                this.markUsed((PdfDictionary)item.values.get(i));
            }
        } else if (string2.equalsIgnoreCase("setfflags")) {
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.values.get(i)).get(PdfName.FF));
                int n4 = 0;
                if (pdfNumber != null) {
                    n4 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n4 | n);
                ((PdfDictionary)item.merged.get(i)).put(PdfName.FF, pdfNumber);
                ((PdfDictionary)item.values.get(i)).put(PdfName.FF, pdfNumber);
                this.markUsed((PdfDictionary)item.values.get(i));
            }
        } else if (string2.equalsIgnoreCase("clrfflags")) {
            for (int i = 0; i < item.merged.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.values.get(i)).get(PdfName.FF));
                int n5 = 0;
                if (pdfNumber != null) {
                    n5 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n5 & ~n);
                ((PdfDictionary)item.merged.get(i)).put(PdfName.FF, pdfNumber);
                ((PdfDictionary)item.values.get(i)).put(PdfName.FF, pdfNumber);
                this.markUsed((PdfDictionary)item.values.get(i));
            }
        } else {
            return false;
        }
        return true;
    }

    public void setFields(FdfReader fdfReader) throws IOException, DocumentException {
        HashMap hashMap = fdfReader.getFields();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = fdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public void setFields(XfdfReader xfdfReader) throws IOException, DocumentException {
        HashMap hashMap = xfdfReader.getFields();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = xfdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public boolean setField(String string, String string2) throws IOException, DocumentException {
        return this.setField(string, string2, string2);
    }

    public boolean setField(String string, String string2, String string3) throws IOException, DocumentException {
        int n;
        PdfObject pdfObject;
        if (this.writer == null) {
            throw new DocumentException("This AcroFields instance is read-only.");
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.TX.equals(pdfName)) {
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.MAXLEN));
            n = 0;
            if (pdfObject != null) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            if (n > 0) {
                string2 = string2.substring(0, Math.min(n, string2.length()));
            }
        }
        if (PdfName.TX.equals(pdfName) || PdfName.CH.equals(pdfName)) {
            pdfObject = new PdfString(string2, "UnicodeBig");
            for (n = 0; n < item.values.size(); ++n) {
                PdfDictionary pdfDictionary = (PdfDictionary)item.values.get(n);
                pdfDictionary.put(PdfName.V, pdfObject);
                pdfDictionary.remove(PdfName.I);
                this.markUsed(pdfDictionary);
                PdfDictionary pdfDictionary2 = (PdfDictionary)item.merged.get(n);
                pdfDictionary2.remove(PdfName.I);
                pdfDictionary2.put(PdfName.V, pdfObject);
                PdfDictionary pdfDictionary3 = (PdfDictionary)item.widgets.get(n);
                if (this.generateAppearances) {
                    PdfObject pdfObject2;
                    PdfAppearance pdfAppearance = this.getAppearance(pdfDictionary2, string3, string);
                    if (PdfName.CH.equals(pdfName)) {
                        pdfObject2 = new PdfNumber(this.topFirst);
                        pdfDictionary3.put(PdfName.TI, pdfObject2);
                        pdfDictionary2.put(PdfName.TI, pdfObject2);
                    }
                    if ((pdfObject2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.AP))) == null) {
                        pdfObject2 = new PdfDictionary();
                        pdfDictionary3.put(PdfName.AP, pdfObject2);
                        pdfDictionary2.put(PdfName.AP, pdfObject2);
                    }
                    ((PdfDictionary)pdfObject2).put(PdfName.N, pdfAppearance.getIndirectReference());
                    this.writer.releaseTemplate(pdfAppearance);
                } else {
                    pdfDictionary3.remove(PdfName.AP);
                    pdfDictionary2.remove(PdfName.AP);
                }
                this.markUsed(pdfDictionary3);
            }
            return true;
        }
        if (PdfName.BTN.equals(pdfName)) {
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            n = 0;
            if (pdfObject != null) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            if ((n & 0x10000) != 0) {
                return true;
            }
            PdfName pdfName2 = new PdfName(string2);
            if ((n & 0x8000) == 0) {
                for (int i = 0; i < item.values.size(); ++i) {
                    ((PdfDictionary)item.values.get(i)).put(PdfName.V, pdfName2);
                    this.markUsed((PdfDictionary)item.values.get(i));
                    PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(i);
                    pdfDictionary.put(PdfName.V, pdfName2);
                    pdfDictionary.put(PdfName.AS, pdfName2);
                    PdfDictionary pdfDictionary4 = (PdfDictionary)item.widgets.get(i);
                    if (this.isInAP(pdfDictionary4, pdfName2)) {
                        pdfDictionary4.put(PdfName.AS, pdfName2);
                    } else {
                        pdfDictionary4.put(PdfName.AS, PdfName.Off);
                    }
                    this.markUsed(pdfDictionary4);
                }
            } else {
                PdfObject pdfObject3;
                ArrayList<String> arrayList = new ArrayList<String>();
                PdfObject pdfObject4 = PdfReader.getPdfObject(((PdfDictionary)item.values.get(0)).get(PdfName.OPT));
                if (pdfObject4 != null && pdfObject4.isArray()) {
                    ArrayList arrayList2 = ((PdfArray)pdfObject4).getArrayList();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        pdfObject3 = PdfReader.getPdfObject((PdfObject)arrayList2.get(i));
                        if (pdfObject3 != null && pdfObject3.isString()) {
                            arrayList.add(((PdfString)pdfObject3).toUnicodeString());
                            continue;
                        }
                        arrayList.add(null);
                    }
                }
                int n2 = arrayList.indexOf(string2);
                PdfName pdfName3 = null;
                if (n2 >= 0) {
                    pdfName3 = new PdfName(String.valueOf(n2));
                    pdfObject3 = pdfName3;
                } else {
                    pdfObject3 = pdfName2;
                }
                for (int i = 0; i < item.values.size(); ++i) {
                    PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(i);
                    PdfDictionary pdfDictionary5 = (PdfDictionary)item.widgets.get(i);
                    this.markUsed((PdfDictionary)item.values.get(i));
                    if (pdfName3 != null) {
                        PdfString pdfString = new PdfString(string2, "UnicodeBig");
                        ((PdfDictionary)item.values.get(i)).put(PdfName.V, pdfString);
                        pdfDictionary.put(PdfName.V, pdfString);
                    } else {
                        ((PdfDictionary)item.values.get(i)).put(PdfName.V, pdfName2);
                        pdfDictionary.put(PdfName.V, pdfName2);
                    }
                    this.markUsed(pdfDictionary5);
                    if (this.isInAP(pdfDictionary5, (PdfName)pdfObject3)) {
                        pdfDictionary.put(PdfName.AS, pdfObject3);
                        pdfDictionary5.put(PdfName.AS, pdfObject3);
                        continue;
                    }
                    pdfDictionary.put(PdfName.AS, PdfName.Off);
                    pdfDictionary5.put(PdfName.AS, PdfName.Off);
                }
            }
            return true;
        }
        return false;
    }

    boolean isInAP(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
        if (pdfDictionary2 == null) {
            return false;
        }
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.N));
        return pdfDictionary3 != null && pdfDictionary3.get(pdfName) != null;
    }

    public HashMap getFields() {
        return this.fields;
    }

    public Item getFieldItem(String string) {
        return (Item)this.fields.get(string);
    }

    public float[] getFieldPositions(String string) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        float[] fArray = new float[item.page.size() * 5];
        int n = 0;
        for (int i = 0; i < item.page.size(); ++i) {
            try {
                PdfDictionary pdfDictionary = (PdfDictionary)item.widgets.get(i);
                PdfArray pdfArray = (PdfArray)pdfDictionary.get(PdfName.RECT);
                if (pdfArray == null) continue;
                Rectangle rectangle = PdfReader.getNormalizedRectangle(pdfArray);
                fArray[n] = ((Integer)item.page.get(i)).floatValue();
                int n2 = ++n;
                fArray[n2] = rectangle.left();
                int n3 = ++n;
                fArray[n3] = rectangle.bottom();
                int n4 = ++n;
                fArray[n4] = rectangle.right();
                int n5 = ++n;
                ++n;
                fArray[n5] = rectangle.top();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n < fArray.length) {
            float[] fArray2 = new float[n];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            return fArray2;
        }
        return fArray;
    }

    private int removeRefFromArray(PdfArray pdfArray, PdfObject pdfObject) {
        ArrayList arrayList = pdfArray.getArrayList();
        if (pdfObject == null || !pdfObject.isIndirect()) {
            return arrayList.size();
        }
        PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)pdfObject;
        for (int i = 0; i < arrayList.size(); ++i) {
            PdfObject pdfObject2 = (PdfObject)arrayList.get(i);
            if (!pdfObject2.isIndirect() || ((PdfIndirectReference)pdfObject2).getNumber() != pdfIndirectReference.getNumber()) continue;
            arrayList.remove(i--);
        }
        return arrayList.size();
    }

    public boolean removeFieldsFromPage(int n) {
        if (n < 1) {
            return false;
        }
        String[] stringArray = new String[this.fields.size()];
        this.fields.keySet().toArray(stringArray);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2 = this.removeField(stringArray[i], n);
            bl = bl || bl2;
        }
        return bl;
    }

    public boolean removeField(String string, int n) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog());
        if (pdfDictionary == null) {
            return false;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FIELDS), pdfDictionary);
        if (pdfArray == null) {
            return false;
        }
        for (int i = 0; i < item.widget_refs.size(); ++i) {
            PdfArray pdfArray2;
            int n2 = (Integer)item.page.get(i);
            if (n != -1 && n != n2) continue;
            PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)item.widget_refs.get(i);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference);
            PdfDictionary pdfDictionary3 = this.reader.getPageN(n2);
            PdfArray pdfArray3 = (PdfArray)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.ANNOTS), pdfDictionary3);
            if (pdfArray3 != null) {
                if (this.removeRefFromArray(pdfArray3, pdfIndirectReference) == 0) {
                    pdfDictionary3.remove(PdfName.ANNOTS);
                    this.markUsed(pdfDictionary3);
                } else {
                    this.markUsed(pdfArray3);
                }
            }
            PdfReader.killIndirect(pdfIndirectReference);
            PdfIndirectReference pdfIndirectReference2 = pdfIndirectReference;
            while ((pdfIndirectReference = (PdfIndirectReference)pdfDictionary2.get(PdfName.PARENT)) != null && this.removeRefFromArray(pdfArray2 = (PdfArray)PdfReader.getPdfObject((pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference)).get(PdfName.KIDS)), pdfIndirectReference2) == 0) {
                pdfIndirectReference2 = pdfIndirectReference;
                PdfReader.killIndirect(pdfIndirectReference);
            }
            if (pdfIndirectReference == null) {
                this.removeRefFromArray(pdfArray, pdfIndirectReference2);
                this.markUsed(pdfArray);
            }
            if (n == -1) continue;
            item.merged.remove(i);
            item.page.remove(i);
            item.values.remove(i);
            item.widget_refs.remove(i);
            item.widgets.remove(i);
            --i;
        }
        if (n == -1 || item.merged.size() == 0) {
            this.fields.remove(string);
        }
        return true;
    }

    public boolean removeField(String string) {
        return this.removeField(string, -1);
    }

    public boolean isGenerateAppearances() {
        return this.generateAppearances;
    }

    public void setGenerateAppearances(boolean bl) {
        this.generateAppearances = bl;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (bl) {
            pdfDictionary.remove(PdfName.NEEDAPPEARANCES);
        } else {
            pdfDictionary.put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
        }
    }

    public ArrayList getSignatureNames() {
        Object object;
        Object object2;
        Object[] objectArray;
        if (this.sigNames != null) {
            return new ArrayList(this.sigNames.keySet());
        }
        this.sigNames = new HashMap();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList2;
            PdfObject pdfObject;
            PdfDictionary pdfDictionary;
            PdfObject pdfObject2;
            PdfObject pdfObject3;
            objectArray = iterator.next();
            object2 = (Item)objectArray.getValue();
            object = (PdfDictionary)((Item)object2).merged.get(0);
            if (!PdfName.SIG.equals(((PdfDictionary)object).get(PdfName.FT)) || (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.V))) == null || pdfObject3.type() != 6 || (pdfObject2 = (pdfDictionary = (PdfDictionary)pdfObject3).get(PdfName.CONTENTS)) == null || pdfObject2.type() != 3 || (pdfObject = pdfDictionary.get(PdfName.BYTERANGE)) == null || pdfObject.type() != 5 || (arrayList2 = ((PdfArray)pdfObject).getArrayList()).size() < 2) continue;
            int n = ((PdfNumber)arrayList2.get(arrayList2.size() - 1)).intValue() + ((PdfNumber)arrayList2.get(arrayList2.size() - 2)).intValue();
            arrayList.add(new Object[]{objectArray.getKey(), new int[]{n, 0}});
        }
        Collections.sort(arrayList, new SorterComparator());
        if (arrayList.size() > 0) {
            this.totalRevisions = ((int[])((Object[])arrayList.get(arrayList.size() - 1))[1])[0] == this.reader.getFileLength() ? arrayList.size() : arrayList.size() + 1;
            for (int i = 0; i < arrayList.size(); ++i) {
                objectArray = (Object[])arrayList.get(i);
                object2 = (String)objectArray[0];
                object = (int[])objectArray[1];
                object[1] = i + 1;
                this.sigNames.put(object2, object);
            }
        }
        return new ArrayList(this.sigNames.keySet());
    }

    public ArrayList getBlankSignatureNames() {
        this.getSignatureNames();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Item item = (Item)entry.getValue();
            PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
            if (!PdfName.SIG.equals(pdfDictionary.get(PdfName.FT)) || this.sigNames.containsKey(entry.getKey())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public PdfDictionary getSignatureDictionary(String string) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(string)) {
            return null;
        }
        Item item = (Item)this.fields.get(string);
        PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
        return (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.V));
    }

    public boolean signatureCoversWholeDocument(String string) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(string)) {
            return false;
        }
        return ((int[])this.sigNames.get(string))[0] == this.reader.getFileLength();
    }

    public PdfPKCS7 verifySignature(String string) {
        return this.verifySignature(string, null);
    }

    public PdfPKCS7 verifySignature(String string, String string2) {
        PdfDictionary pdfDictionary = this.getSignatureDictionary(string);
        if (pdfDictionary == null) {
            return null;
        }
        try {
            PdfString pdfString;
            PdfName pdfName = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.SUBFILTER));
            PdfString pdfString2 = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
            PdfPKCS7 pdfPKCS7 = null;
            if (pdfName.equals(PdfName.ADBE_X509_RSA_SHA1)) {
                pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CERT));
                pdfPKCS7 = new PdfPKCS7(pdfString2.getOriginalBytes(), pdfString.getBytes(), string2);
            } else {
                pdfPKCS7 = new PdfPKCS7(pdfString2.getOriginalBytes(), string2);
            }
            this.updateByteRange(pdfPKCS7, pdfDictionary);
            pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.M));
            if (pdfString != null) {
                pdfPKCS7.setSignDate(PdfDate.decode(pdfString.toString()));
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAME))) != null) {
                pdfPKCS7.setSignName(pdfString.toUnicodeString());
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.REASON))) != null) {
                pdfPKCS7.setReason(pdfString.toUnicodeString());
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.LOCATION))) != null) {
                pdfPKCS7.setLocation(pdfString.toUnicodeString());
            }
            return pdfPKCS7;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private void updateByteRange(PdfPKCS7 pdfPKCS7, PdfDictionary pdfDictionary) {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BYTERANGE));
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byte[] byArray = new byte[8192];
            ArrayList arrayList = pdfArray.getArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                int n;
                int n2 = ((PdfNumber)arrayList.get(i)).intValue();
                randomAccessFileOrArray.seek(n2);
                for (int j = ((PdfNumber)arrayList.get(++i)).intValue(); j > 0 && (n = randomAccessFileOrArray.read(byArray, 0, Math.min(j, byArray.length))) > 0; j -= n) {
                    pdfPKCS7.update(byArray, 0, n);
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    private void markUsed(PdfObject pdfObject) {
        if (!this.append) {
            return;
        }
        ((PdfStamperImp)this.writer).markUsed(pdfObject);
    }

    public int getTotalRevisions() {
        this.getSignatureNames();
        return this.totalRevisions;
    }

    public int getRevision(String string) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(string)) {
            return 0;
        }
        return ((int[])this.sigNames.get(string))[1];
    }

    public InputStream extractRevision(String string) throws IOException {
        this.getSignatureNames();
        int n = ((int[])this.sigNames.get(string))[0];
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        randomAccessFileOrArray.reOpen();
        randomAccessFileOrArray.seek(0);
        return new RevisionStream(randomAccessFileOrArray, n);
    }

    public HashMap getFieldCache() {
        return this.fieldCache;
    }

    public void setFieldCache(HashMap hashMap) {
        this.fieldCache = hashMap;
    }

    public void setExtraMargin(float f, float f2) {
        this.extraMarginLeft = f;
        this.extraMarginTop = f2;
    }

    public void addSubstitutionFont(BaseFont baseFont) {
        if (this.substitutionFonts == null) {
            this.substitutionFonts = new ArrayList();
        }
        this.substitutionFonts.add(baseFont);
    }

    public ArrayList getSubstitutionFonts() {
        return this.substitutionFonts;
    }

    public void setSubstitutionFonts(ArrayList arrayList) {
        this.substitutionFonts = arrayList;
    }

    static {
        stdFieldFontNames.put("CoBO", new String[]{"Courier-BoldOblique"});
        stdFieldFontNames.put("CoBo", new String[]{"Courier-Bold"});
        stdFieldFontNames.put("CoOb", new String[]{"Courier-Oblique"});
        stdFieldFontNames.put("Cour", new String[]{"Courier"});
        stdFieldFontNames.put("HeBO", new String[]{"Helvetica-BoldOblique"});
        stdFieldFontNames.put("HeBo", new String[]{"Helvetica-Bold"});
        stdFieldFontNames.put("HeOb", new String[]{"Helvetica-Oblique"});
        stdFieldFontNames.put("Helv", new String[]{"Helvetica"});
        stdFieldFontNames.put("Symb", new String[]{"Symbol"});
        stdFieldFontNames.put("TiBI", new String[]{"Times-BoldItalic"});
        stdFieldFontNames.put("TiBo", new String[]{"Times-Bold"});
        stdFieldFontNames.put("TiIt", new String[]{"Times-Italic"});
        stdFieldFontNames.put("TiRo", new String[]{"Times-Roman"});
        stdFieldFontNames.put("ZaDb", new String[]{"ZapfDingbats"});
        stdFieldFontNames.put("HySm", new String[]{"HYSMyeongJo-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("HyGo", new String[]{"HYGoThic-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaGo", new String[]{"HeiseiKakuGo-W5", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaMi", new String[]{"HeiseiMin-W3", "UniJIS-UCS2-H"});
        stdFieldFontNames.put("MHei", new String[]{"MHei-Medium", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("MSun", new String[]{"MSung-Light", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("STSo", new String[]{"STSong-Light", "UniGB-UCS2-H"});
    }

    private static class SorterComparator
    implements Comparator {
        private SorterComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((int[])((Object[])object)[1])[0];
            int n2 = ((int[])((Object[])object2)[1])[0];
            return n - n2;
        }
    }

    private static class RevisionStream
    extends InputStream {
        private byte[] b = new byte[1];
        private RandomAccessFileOrArray raf;
        private int length;
        private int rangePosition = 0;
        private boolean closed;

        private RevisionStream(RandomAccessFileOrArray randomAccessFileOrArray, int n) {
            this.raf = randomAccessFileOrArray;
            this.length = n;
        }

        public int read() throws IOException {
            int n = this.read(this.b);
            if (n != 1) {
                return -1;
            }
            return this.b[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.rangePosition >= this.length) {
                this.close();
                return -1;
            }
            int n3 = Math.min(n2, this.length - this.rangePosition);
            this.raf.readFully(byArray, n, n3);
            this.rangePosition += n3;
            return n3;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.raf.close();
                this.closed = true;
            }
        }
    }

    private static class InstHit {
        IntHashtable hits;

        public InstHit(int[] nArray) {
            if (nArray == null) {
                return;
            }
            this.hits = new IntHashtable();
            for (int i = 0; i < nArray.length; ++i) {
                this.hits.put(nArray[i], 1);
            }
        }

        public boolean isHit(int n) {
            if (this.hits == null) {
                return true;
            }
            return this.hits.containsKey(n);
        }
    }

    public static class Item {
        public ArrayList values = new ArrayList();
        public ArrayList widgets = new ArrayList();
        public ArrayList widget_refs = new ArrayList();
        public ArrayList merged = new ArrayList();
        public ArrayList page = new ArrayList();
        public ArrayList tabOrder = new ArrayList();
    }
}

