/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.bc.asn1;

import com.lowagie2.bc.asn1.ASN1InputStream;
import com.lowagie2.bc.asn1.DEREncodable;
import com.lowagie2.bc.asn1.DERObject;
import com.lowagie2.bc.asn1.DEROutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERApplicationSpecific
extends DERObject {
    private byte[] octets;
    private int tag;

    public DERApplicationSpecific(int tag, DEREncodable object) throws IOException {
        this.tag = tag | 0x20;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(baos);
        dos.writeObject(object);
        this.octets = baos.toByteArray();
    }

    public DERApplicationSpecific(int tag, byte[] octets) {
        this.tag = tag;
        this.octets = octets;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(0x40 | this.tag, this.octets);
    }

    public int getApplicationTag() {
        return this.tag & 0x1F;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(new ByteArrayInputStream(this.getContents())).readObject();
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }
}

