/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.bc.asn1;

import com.lowagie2.bc.asn1.ASN1OctetString;
import com.lowagie2.bc.asn1.ASN1TaggedObject;
import com.lowagie2.bc.asn1.DERObject;
import com.lowagie2.bc.asn1.DEROutputStream;
import com.lowagie2.bc.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERUTF8String
extends DERObject
implements DERString {
    String string;

    public DERUTF8String(String string) {
        this.string = string;
    }

    DERUTF8String(byte[] string) {
        int i = 0;
        int length = 0;
        while (i < string.length) {
            ++length;
            if ((string[i] & 0xE0) == 224) {
                i += 3;
                continue;
            }
            if ((string[i] & 0xC0) == 192) {
                i += 2;
                continue;
            }
            ++i;
        }
        char[] cs = new char[length];
        i = 0;
        length = 0;
        while (i < string.length) {
            char ch;
            if ((string[i] & 0xE0) == 224) {
                ch = (char)((string[i] & 0x1F) << 12 | (string[i + 1] & 0x3F) << 6 | string[i + 2] & 0x3F);
                i += 3;
            } else if ((string[i] & 0xC0) == 192) {
                ch = (char)((string[i] & 0x3F) << 6 | string[i + 1] & 0x3F);
                i += 2;
            } else {
                ch = (char)(string[i] & 0xFF);
                ++i;
            }
            cs[length++] = ch;
        }
        this.string = new String(cs);
    }

    void encode(DEROutputStream out) throws IOException {
        char[] c = this.string.toCharArray();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int i = 0;
        while (i != c.length) {
            char ch = c[i];
            if (ch < '\u0080') {
                bOut.write(ch);
            } else if (ch < '\u0800') {
                bOut.write(0xC0 | ch >> 6);
                bOut.write(0x80 | ch & 0x3F);
            } else {
                bOut.write(0xE0 | ch >> 12);
                bOut.write(0x80 | ch >> 6 & 0x3F);
                bOut.write(0x80 | ch & 0x3F);
            }
            ++i;
        }
        out.writeEncoded(12, bOut.toByteArray());
    }

    public boolean equals(Object o) {
        if (!(o instanceof DERUTF8String)) {
            return false;
        }
        DERUTF8String s = (DERUTF8String)o;
        return this.getString().equals(s.getString());
    }

    public static DERUTF8String getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERUTF8String.getInstance(obj.getObject());
    }

    public static DERUTF8String getInstance(Object obj) {
        if (obj == null || obj instanceof DERUTF8String) {
            return (DERUTF8String)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERUTF8String(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERUTF8String.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }
}

