/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.BadElementException;
import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.ElementListener;
import com.lowagie2.text.List;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.Table;
import com.lowagie2.text.TextElementArray;
import com.lowagie2.text.markup.MarkupParser;
import com.lowagie2.text.pdf.PdfPCell;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class Cell
extends Rectangle
implements TextElementArray {
    protected ArrayList arrayList = null;
    protected int colspan = 1;
    protected boolean groupChange = true;
    protected boolean header;
    protected int horizontalAlignment = -1;
    float leading = Float.NaN;
    protected int maxLines = Integer.MAX_VALUE;
    protected int rowspan = 1;
    String showTruncation;
    protected boolean useAscender = false;
    protected boolean useBorderPadding;
    protected boolean useDescender = false;
    protected int verticalAlignment = -1;
    protected String width;

    public Cell(Properties attributes) {
        this();
        int blue;
        int green;
        int red;
        String value = (String)attributes.remove("horizontalalign");
        if (value != null) {
            this.setHorizontalAlignment(value);
        }
        if ((value = (String)attributes.remove("verticalalign")) != null) {
            this.setVerticalAlignment(value);
        }
        if ((value = (String)attributes.remove("width")) != null) {
            this.setWidth(value);
        }
        if ((value = (String)attributes.remove("colspan")) != null) {
            this.setColspan(Integer.parseInt(value));
        }
        if ((value = (String)attributes.remove("rowspan")) != null) {
            this.setRowspan(Integer.parseInt(value));
        }
        if ((value = (String)attributes.remove("leading")) != null) {
            this.setLeading(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("header")) != null) {
            this.setHeader(new Boolean(value));
        }
        if ((value = (String)attributes.remove("nowrap")) != null) {
            this.setNoWrap(new Boolean(value));
        }
        if ((value = (String)attributes.remove("borderwidth")) != null) {
            this.setBorderWidth(Float.valueOf(value + "f").floatValue());
        }
        int border = 0;
        value = (String)attributes.remove("left");
        if (value != null && new Boolean(value).booleanValue()) {
            border |= 4;
        }
        if ((value = (String)attributes.remove("right")) != null && new Boolean(value).booleanValue()) {
            border |= 8;
        }
        if ((value = (String)attributes.remove("top")) != null && new Boolean(value).booleanValue()) {
            border |= 1;
        }
        if ((value = (String)attributes.remove("bottom")) != null && new Boolean(value).booleanValue()) {
            border |= 2;
        }
        this.setBorder(border);
        String r = (String)attributes.remove("red");
        String g = (String)attributes.remove("green");
        String b = (String)attributes.remove("blue");
        if (r != null || g != null || b != null) {
            red = 0;
            green = 0;
            blue = 0;
            if (r != null) {
                red = Integer.parseInt(r);
            }
            if (g != null) {
                green = Integer.parseInt(g);
            }
            if (b != null) {
                blue = Integer.parseInt(b);
            }
            this.setBorderColor(new Color(red, green, blue));
        } else {
            value = (String)attributes.remove("bordercolor");
            if (value != null) {
                this.setBorderColor(MarkupParser.decodeColor(value));
            }
        }
        r = (String)attributes.remove("bgred");
        g = (String)attributes.remove("bggreen");
        b = (String)attributes.remove("bgblue");
        if (r != null || g != null || b != null) {
            red = 0;
            green = 0;
            blue = 0;
            if (r != null) {
                red = Integer.parseInt(r);
            }
            if (g != null) {
                green = Integer.parseInt(g);
            }
            if (b != null) {
                blue = Integer.parseInt(b);
            }
            this.setBackgroundColor(new Color(red, green, blue));
        } else {
            value = (String)attributes.remove("backgroundcolor");
            if (value != null) {
                this.setBackgroundColor(MarkupParser.decodeColor(value));
            }
        }
        value = (String)attributes.remove("grayfill");
        if (value != null) {
            this.setGrayFill(Float.valueOf(value + "f").floatValue());
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    public Cell(Element element) throws BadElementException {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(-1);
        this.setBorderWidth(0.5f);
        if (element instanceof Phrase) {
            Phrase p = (Phrase)element;
            this.leading = p.leading();
        }
        this.arrayList = new ArrayList();
        this.addElement(element);
    }

    public Cell(String content) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(-1);
        this.setBorderWidth(0.5f);
        this.arrayList = new ArrayList();
        try {
            this.addElement(new Paragraph(content));
        }
        catch (BadElementException bee) {
        }
    }

    public Cell(boolean dummy) {
        this();
        this.arrayList.add(new Paragraph(0.0f));
    }

    public Cell() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(-1);
        this.setBorderWidth(0.5f);
        this.arrayList = new ArrayList();
    }

    public boolean add(Object o) {
        try {
            this.addElement((Element)o);
            return true;
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("You can only add objects that implement the Element interface.");
        }
        catch (BadElementException bee) {
            throw new ClassCastException(bee.getMessage());
        }
    }

    public void addElement(Element element) throws BadElementException {
        if (this.isTable()) {
            Table table = (Table)this.arrayList.get(0);
            Cell tmp = new Cell(element);
            tmp.setBorder(0);
            tmp.setColspan(table.columns());
            table.addCell(tmp);
            return;
        }
        switch (element.type()) {
            case 15: 
            case 20: 
            case 21: {
                throw new BadElementException("You can't add listitems, rows or cells to a cell.");
            }
            case 14: {
                if (Float.isNaN(this.leading)) {
                    this.leading = ((List)element).leading();
                }
                if (((List)element).size() == 0) {
                    return;
                }
                this.arrayList.add(element);
                return;
            }
            case 11: 
            case 12: 
            case 17: {
                if (Float.isNaN(this.leading)) {
                    this.leading = ((Phrase)element).leading();
                }
                if (((Phrase)element).isEmpty()) {
                    return;
                }
                this.arrayList.add(element);
                return;
            }
            case 10: {
                if (((Chunk)element).isEmpty()) {
                    return;
                }
                this.arrayList.add(element);
                return;
            }
            case 22: {
                Cell tmp;
                Table table = new Table(3);
                float[] widths = new float[3];
                widths[1] = ((Table)element).widthPercentage();
                switch (((Table)element).alignment()) {
                    case 0: {
                        widths[0] = 0.0f;
                        widths[2] = 100.0f - widths[1];
                        break;
                    }
                    case 1: {
                        widths[0] = (100.0f - widths[1]) / 2.0f;
                        widths[2] = widths[0];
                        break;
                    }
                    case 2: {
                        widths[0] = 100.0f - widths[1];
                        widths[2] = 0.0f;
                    }
                }
                table.setWidths(widths);
                if (this.arrayList.size() == 0) {
                    table.addCell(Cell.getDummyCell());
                } else {
                    tmp = new Cell();
                    tmp.setBorder(0);
                    tmp.setColspan(3);
                    Iterator i = this.arrayList.iterator();
                    while (i.hasNext()) {
                        tmp.add((Element)i.next());
                    }
                    table.addCell(tmp);
                }
                tmp = new Cell();
                tmp.setBorder(0);
                table.addCell(tmp);
                table.insertTable((Table)element);
                tmp = new Cell();
                tmp.setBorder(0);
                table.addCell(tmp);
                table.addCell(Cell.getDummyCell());
                this.clear();
                this.arrayList.add(table);
                return;
            }
        }
        this.arrayList.add(element);
    }

    public float bottom(int margin) {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float bottom() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public String cellWidth() {
        return this.width;
    }

    public void clear() {
        this.arrayList.clear();
    }

    public int colspan() {
        return this.colspan;
    }

    public PdfPCell createPdfPCell() throws BadElementException {
        if (this.rowspan > 1) {
            throw new BadElementException("PdfPCells can't have a rowspan > 1");
        }
        if (this.isTable()) {
            return new PdfPCell(((Table)this.arrayList.get(0)).createPdfPTable());
        }
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(this.verticalAlignment);
        cell.setHorizontalAlignment(this.horizontalAlignment);
        cell.setColspan(this.colspan);
        cell.setUseBorderPadding(this.useBorderPadding);
        cell.setUseDescender(this.useDescender);
        cell.setLeading(this.leading(), 0.0f);
        cell.cloneNonPositionParameters(this);
        cell.setNoWrap(this.noWrap());
        Iterator i = this.getElements();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (e.type() == 11 || e.type() == 12) {
                Paragraph p = new Paragraph((Phrase)e);
                p.setAlignment(this.horizontalAlignment);
                e = p;
            }
            cell.addElement(e);
        }
        return cell;
    }

    void fill() {
        if (this.size() == 0) {
            this.arrayList.add(new Paragraph(0.0f));
        }
    }

    public ArrayList getChunks() {
        ArrayList tmp = new ArrayList();
        Iterator i = this.arrayList.iterator();
        while (i.hasNext()) {
            tmp.addAll(((Element)i.next()).getChunks());
        }
        return tmp;
    }

    public static Cell getDummyCell() {
        Cell cell = new Cell(true);
        cell.setColspan(3);
        cell.setBorder(0);
        return cell;
    }

    public Iterator getElements() {
        return this.arrayList.iterator();
    }

    public boolean getGroupChange() {
        return this.groupChange;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public String getShowTruncation() {
        return this.showTruncation;
    }

    public boolean header() {
        return this.header;
    }

    public int horizontalAlignment() {
        return this.horizontalAlignment;
    }

    public boolean isEmpty() {
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = (Element)this.arrayList.get(0);
                switch (element.type()) {
                    case 10: {
                        return ((Chunk)element).isEmpty();
                    }
                    case 11: 
                    case 12: 
                    case 17: {
                        return ((Phrase)element).isEmpty();
                    }
                    case 14: {
                        return ((List)element).size() == 0;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean isTable() {
        return this.size() == 1 && ((Element)this.arrayList.get(0)).type() == 22;
    }

    public static boolean isTag(String tag) {
        return "cell".equals(tag);
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public boolean isUseBorderPadding() {
        return this.useBorderPadding;
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public float leading() {
        if (Float.isNaN(this.leading)) {
            return 16.0f;
        }
        return this.leading;
    }

    public float left(int margin) {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float left() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public boolean noWrap() {
        return this.maxLines == 1;
    }

    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public float right(int margin) {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float right() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public int rowspan() {
        return this.rowspan;
    }

    public void setBottom(int value) {
        throw new UnsupportedOperationException("Dimensions of a Cell are attributed automagically. See the FAQ.");
    }

    public void setColspan(int value) {
        this.colspan = value;
    }

    public void setGroupChange(boolean value) {
        this.groupChange = value;
    }

    public void setHeader(boolean value) {
        this.header = value;
    }

    public void setHorizontalAlignment(String alignment) {
        if ("Center".equalsIgnoreCase(alignment)) {
            this.horizontalAlignment = 1;
            return;
        }
        if ("Right".equalsIgnoreCase(alignment)) {
            this.horizontalAlignment = 2;
            return;
        }
        if ("Justify".equalsIgnoreCase(alignment)) {
            this.horizontalAlignment = 3;
            return;
        }
        if ("JustifyAll".equalsIgnoreCase(alignment)) {
            this.horizontalAlignment = 8;
            return;
        }
        this.horizontalAlignment = 0;
    }

    public void setHorizontalAlignment(int value) {
        this.horizontalAlignment = value;
    }

    public void setLeading(float value) {
        this.leading = value;
    }

    public void setLeft(int value) {
        throw new UnsupportedOperationException("Dimensions of a Cell are attributed automagically. See the FAQ.");
    }

    public void setMaxLines(int value) {
        this.maxLines = value;
    }

    public void setNoWrap(boolean value) {
        this.maxLines = 1;
    }

    public void setRight(int value) {
        throw new UnsupportedOperationException("Dimensions of a Cell are attributed automagically. See the FAQ.");
    }

    public void setRowspan(int value) {
        this.rowspan = value;
    }

    public void setShowTruncation(String value) {
        this.showTruncation = value;
    }

    public void setTop(int value) {
        throw new UnsupportedOperationException("Dimensions of a Cell are attributed automagically. See the FAQ.");
    }

    public void setUseAscender(boolean use) {
        this.useAscender = use;
    }

    public void setUseBorderPadding(boolean use) {
        this.useBorderPadding = use;
    }

    public void setUseDescender(boolean use) {
        this.useDescender = use;
    }

    public void setVerticalAlignment(String alignment) {
        if ("Middle".equalsIgnoreCase(alignment)) {
            this.verticalAlignment = 5;
            return;
        }
        if ("Bottom".equalsIgnoreCase(alignment)) {
            this.verticalAlignment = 6;
            return;
        }
        if ("Baseline".equalsIgnoreCase(alignment)) {
            this.verticalAlignment = 7;
            return;
        }
        this.verticalAlignment = 4;
    }

    public void setVerticalAlignment(int value) {
        this.verticalAlignment = value;
    }

    public void setWidth(String value) {
        this.width = value;
    }

    public int size() {
        return this.arrayList.size();
    }

    public float top(int margin) {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float top() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public int type() {
        return 20;
    }

    public int verticalAlignment() {
        return this.verticalAlignment;
    }
}

