/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.DocListener;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Header;
import com.lowagie2.text.HeaderFooter;
import com.lowagie2.text.Meta;
import com.lowagie2.text.PageSize;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.Watermark;
import com.lowagie2.text.rtf.RtfWriter2;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class Document
implements DocListener {
    private static final String ITEXT_VERSION = "iText 1.4.4 (by lowagie.com)";
    protected boolean close;
    public static boolean compress = true;
    protected HeaderFooter footer = null;
    protected HeaderFooter header = null;
    protected String htmlStyleClass = null;
    protected String javaScript_onLoad = null;
    protected String javaScript_onUnLoad = null;
    private ArrayList listeners = new ArrayList();
    protected float marginBottom = 0.0f;
    protected float marginLeft = 0.0f;
    protected boolean marginMirroring = false;
    protected float marginRight = 0.0f;
    protected float marginTop = 0.0f;
    protected boolean open;
    protected int pageN = 0;
    protected Rectangle pageSize;
    protected Watermark watermark = null;

    public Document(Rectangle pageSize, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.pageSize = pageSize;
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
    }

    public Document(Rectangle pageSize) {
        this(pageSize, 36.0f, 36.0f, 36.0f, 36.0f);
    }

    public Document() {
        this(PageSize.A4);
    }

    public boolean add(Watermark watermark) {
        this.watermark = watermark;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.add(watermark);
        }
        return true;
    }

    public boolean add(Element element, boolean previous, Rectangle rect, float left, float right, float top, float bottom) throws DocumentException {
        if (this.close) {
            throw new DocumentException("The document has been closed. You can't add any Elements.");
        }
        int type = element.type();
        if (this.open) {
            if (type != 10 && type != 11 && type != 12 && type != 22 && type != 23 && type != 40 && type != 17 && type != 29 && type != 16 && type != 13 && type != 14 && type != 15 && type != 30 && type != 32 && type != 34 && type != 35 && type != 39) {
                throw new DocumentException("The document is open; you can only add Elements with content.");
            }
        } else if (type != 0 && type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 7 && type != 6) {
            throw new DocumentException("The document is not open yet; you can only add Meta information.");
        }
        boolean success = false;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            if (listener instanceof RtfWriter2) {
                success |= ((RtfWriter2)listener).add(element, previous, rect, left, right, top, bottom);
                continue;
            }
            success |= listener.add(element);
        }
        return success;
    }

    public boolean add(Element element) throws DocumentException {
        if (this.close) {
            throw new DocumentException("The document has been closed. You can't add any Elements.");
        }
        int type = element.type();
        if (this.open) {
            if (type != 10 && type != 11 && type != 12 && type != 22 && type != 23 && type != 40 && type != 17 && type != 29 && type != 16 && type != 13 && type != 14 && type != 15 && type != 30 && type != 32 && type != 34 && type != 35 && type != 39) {
                throw new DocumentException("The document is open; you can only add Elements with content.");
            }
        } else if (type != 0 && type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 7 && type != 6) {
            throw new DocumentException("The document is not open yet; you can only add Meta information.");
        }
        boolean success = false;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            success |= listener.add(element);
        }
        return success;
    }

    public boolean addAuthor(String author) {
        try {
            return this.add(new Meta(4, author));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addCreationDate() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            return this.add(new Meta(6, sdf.format(new Date())));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addCreator(String creator) {
        try {
            return this.add(new Meta(7, creator));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public void addDocListener(DocListener listener) {
        this.listeners.add(listener);
    }

    public boolean addHeader(String name, String content) {
        try {
            return this.add(new Header(name, content));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addKeywords(String keywords) {
        try {
            return this.add(new Meta(3, keywords));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addProducer() {
        try {
            return this.add(new Meta(5, "iText by lowagie.com"));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addSubject(String subject) {
        try {
            return this.add(new Meta(2, subject));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addTitle(String title) {
        try {
            return this.add(new Meta(1, title));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public float bottom(float margin) {
        return this.pageSize.bottom(this.marginBottom + margin);
    }

    public float bottom() {
        return this.pageSize.bottom(this.marginBottom);
    }

    public float bottomMargin() {
        return this.marginBottom;
    }

    public void clearTextWrap() throws DocumentException {
        if (this.open && !this.close) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                DocListener listener = (DocListener)iterator.next();
                listener.clearTextWrap();
            }
        }
    }

    public void close() {
        if (!this.close) {
            this.open = false;
            this.close = true;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.close();
        }
    }

    public String getHtmlStyleClass() {
        return this.htmlStyleClass;
    }

    public String getJavaScript_onLoad() {
        return this.javaScript_onLoad;
    }

    public String getJavaScript_onUnLoad() {
        return this.javaScript_onUnLoad;
    }

    public int getPageNumber() {
        return this.pageN;
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public static final String getVersion() {
        return ITEXT_VERSION;
    }

    public boolean isMarginMirroring() {
        return this.marginMirroring;
    }

    public boolean isOpen() {
        return this.open;
    }

    public float left(float margin) {
        return this.pageSize.left(this.marginLeft + margin);
    }

    public float left() {
        return this.pageSize.left(this.marginLeft);
    }

    public float leftMargin() {
        return this.marginLeft;
    }

    public boolean newPage() throws DocumentException {
        if (!this.open || this.close) {
            return false;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.newPage();
        }
        return true;
    }

    public void open() {
        if (!this.close) {
            this.open = true;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.setPageSize(this.pageSize);
            listener.setMargins(this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
            listener.open();
        }
    }

    public void removeDocListener(DocListener listener) {
        this.listeners.remove(listener);
    }

    public void removeWatermark() {
        this.watermark = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.removeWatermark();
        }
    }

    public void resetFooter() {
        this.footer = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.resetFooter();
        }
    }

    public void resetHeader() {
        this.header = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.resetHeader();
        }
    }

    public void resetPageCount() {
        this.pageN = 0;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.resetPageCount();
        }
    }

    public float right(float margin) {
        return this.pageSize.right(this.marginRight + margin);
    }

    public float right() {
        return this.pageSize.right(this.marginRight);
    }

    public float rightMargin() {
        return this.marginRight;
    }

    public void setFooter(HeaderFooter footer) {
        this.footer = footer;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.setFooter(footer);
        }
    }

    public void setHeader(HeaderFooter header) {
        this.header = header;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.setHeader(header);
        }
    }

    public void setHtmlStyleClass(String htmlStyleClass) {
        this.htmlStyleClass = htmlStyleClass;
    }

    public void setJavaScript_onLoad(String code) {
        this.javaScript_onLoad = code;
    }

    public void setJavaScript_onUnLoad(String code) {
        this.javaScript_onUnLoad = code;
    }

    public boolean setMarginMirroring(boolean marginMirroring) {
        this.marginMirroring = marginMirroring;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.setMarginMirroring(marginMirroring);
        }
        return true;
    }

    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.setMargins(marginLeft, marginRight, marginTop, marginBottom);
        }
        return true;
    }

    public void setPageCount(int pageN) {
        this.pageN = pageN;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.setPageCount(pageN);
        }
    }

    public boolean setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DocListener listener = (DocListener)iterator.next();
            listener.setPageSize(pageSize);
        }
        return true;
    }

    public float top(float margin) {
        return this.pageSize.top(this.marginTop + margin);
    }

    public float top() {
        return this.pageSize.top(this.marginTop);
    }

    public float topMargin() {
        return this.marginTop;
    }
}

