/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.MarkupAttributes;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.Rectangle;

public class HeaderFooter
extends Rectangle
implements MarkupAttributes {
    private Phrase after = null;
    private int alignment;
    private Phrase before = null;
    private boolean numbered;
    private int pageN;

    public HeaderFooter(Phrase before, boolean numbered) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(3);
        this.setBorderWidth(1.0f);
        this.numbered = numbered;
        this.before = before;
    }

    public HeaderFooter(Phrase before, Phrase after) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(3);
        this.setBorderWidth(1.0f);
        this.numbered = true;
        this.before = before;
        this.after = after;
    }

    public int alignment() {
        return this.alignment;
    }

    public Phrase getAfter() {
        return this.after;
    }

    public Phrase getBefore() {
        return this.before;
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    public Paragraph paragraph() {
        Paragraph paragraph = new Paragraph(this.before.leading());
        paragraph.add(this.before);
        if (this.numbered) {
            paragraph.addSpecial(new Chunk(String.valueOf(this.pageN), this.before.font()));
        }
        if (this.after != null) {
            paragraph.addSpecial(this.after);
        }
        paragraph.setAlignment(this.alignment);
        return paragraph;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setPageNumber(int pageN) {
        this.pageN = pageN;
    }
}

