/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.BadElementException;
import com.lowagie2.text.Element;
import com.lowagie2.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Jpeg
extends Image
implements Element {
    public static final byte[] JFIF_ID;
    public static final int M_APP0 = 224;
    public static final int M_APPE = 238;
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS;
    public static final int NOT_A_MARKER = -1;
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS;

    static {
        VALID_MARKERS = new int[]{192, 193, 194};
        UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
        NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
        JFIF_ID = new byte[]{74, 70, 73, 70, 0};
    }

    public Jpeg(byte[] img, float width, float height) throws BadElementException, IOException {
        this(img);
        this.scaledWidth = width;
        this.scaledHeight = height;
    }

    public Jpeg(byte[] img) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = img;
        this.originalData = img;
        this.processParameters();
    }

    public Jpeg(String filename, float width, float height) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(filename), width, height);
    }

    public Jpeg(String filename) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(filename));
    }

    public Jpeg(URL url, float width, float height) throws BadElementException, IOException {
        this(url);
        this.scaledWidth = width;
        this.scaledHeight = height;
    }

    public Jpeg(URL url) throws BadElementException, IOException {
        super(url);
        this.processParameters();
    }

    Jpeg(Image image) {
        super(image);
    }

    private static final int getShort(InputStream is) throws IOException {
        return (is.read() << 8) + is.read();
    }

    private static final int marker(int marker) {
        int i = 0;
        while (i < VALID_MARKERS.length) {
            if (marker == VALID_MARKERS[i]) {
                return 0;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < NOPARAM_MARKERS.length) {
            if (marker == NOPARAM_MARKERS[i2]) {
                return 2;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < UNSUPPORTED_MARKERS.length) {
            if (marker == UNSUPPORTED_MARKERS[i3]) {
                return 1;
            }
            ++i3;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processParameters() throws BadElementException, IOException {
        this.type = 32;
        this.originalType = 1;
        InputStream is = null;
        try {
            String errorID;
            if (this.rawData == null) {
                is = this.url.openStream();
                errorID = this.url.toString();
            } else {
                is = new ByteArrayInputStream(this.rawData);
                errorID = "Byte array";
            }
            if (is.read() != 255 || is.read() != 216) {
                throw new BadElementException(errorID + " is not a valid JPEG-file.");
            }
            boolean firstPass = true;
            while (true) {
                int len;
                int v;
                if ((v = is.read()) < 0) {
                    throw new IOException("Premature EOF while reading JPG.");
                }
                if (v != 255) continue;
                int marker = is.read();
                if (firstPass && marker == 224) {
                    firstPass = false;
                    len = Jpeg.getShort(is);
                    if (len < 16) {
                        Image.skip(is, len - 2);
                        continue;
                    }
                    byte[] bcomp = new byte[JFIF_ID.length];
                    int r = is.read(bcomp);
                    if (r != bcomp.length) {
                        throw new BadElementException(errorID + " corrupted JFIF marker.");
                    }
                    boolean found = true;
                    int k = 0;
                    while (k < bcomp.length) {
                        if (bcomp[k] != JFIF_ID[k]) {
                            found = false;
                            break;
                        }
                        ++k;
                    }
                    if (!found) {
                        Image.skip(is, len - 2 - bcomp.length);
                        continue;
                    }
                    Image.skip(is, 2);
                    int units = is.read();
                    int dx = Jpeg.getShort(is);
                    int dy = Jpeg.getShort(is);
                    if (units == 1) {
                        this.dpiX = dx;
                        this.dpiY = dy;
                    } else if (units == 2) {
                        this.dpiX = (int)((float)dx * 2.54f + 0.5f);
                        this.dpiY = (int)((float)dy * 2.54f + 0.5f);
                    }
                    Image.skip(is, len - 2 - bcomp.length - 7);
                    continue;
                }
                if (marker == 238) {
                    String appe;
                    len = Jpeg.getShort(is);
                    byte[] byteappe = new byte[len];
                    int k = 0;
                    while (k < len) {
                        byteappe[k] = (byte)is.read();
                        ++k;
                    }
                    if (byteappe.length > 12 && (appe = new String(byteappe, 0, 5, "ISO-8859-1")).equals("Adobe")) {
                        this.invert = true;
                    }
                }
                firstPass = false;
                int markertype = Jpeg.marker(marker);
                if (markertype == 0) {
                    Image.skip(is, 2);
                    if (is.read() != 8) {
                        throw new BadElementException(errorID + " must have 8 bits per component.");
                    }
                    this.scaledHeight = Jpeg.getShort(is);
                    this.setTop(this.scaledHeight);
                    this.scaledWidth = Jpeg.getShort(is);
                    this.setRight(this.scaledWidth);
                    this.colorspace = is.read();
                    this.bpc = 8;
                    break;
                }
                if (markertype == 1) {
                    throw new BadElementException(errorID + ": unsupported JPEG marker: " + marker);
                }
                if (markertype == 2) continue;
                Image.skip(is, Jpeg.getShort(is) - 2);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            this.plainWidth = this.width();
            this.plainHeight = this.height();
        }
    }
}

