/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.html.simpleparser;

import com.lowagie2.text.Element;
import com.lowagie2.text.ElementListener;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.TextElementArray;
import com.lowagie2.text.html.simpleparser.ChainedProperties;
import com.lowagie2.text.html.simpleparser.FactoryProperties;
import com.lowagie2.text.pdf.PdfPCell;
import java.util.ArrayList;

public class IncCell
implements TextElementArray {
    private PdfPCell cell;
    private ArrayList chunks = new ArrayList();

    public IncCell(String tag, ChainedProperties props) {
        this.cell = new PdfPCell((Phrase)null);
        String value = props.getProperty("colspan");
        if (value != null) {
            this.cell.setColspan(Integer.parseInt(value));
        }
        value = props.getProperty("align");
        if (tag.equals("th")) {
            this.cell.setHorizontalAlignment(1);
        }
        if (value != null) {
            if ("center".equalsIgnoreCase(value)) {
                this.cell.setHorizontalAlignment(1);
            } else if ("right".equalsIgnoreCase(value)) {
                this.cell.setHorizontalAlignment(2);
            } else if ("left".equalsIgnoreCase(value)) {
                this.cell.setHorizontalAlignment(0);
            } else if ("justify".equalsIgnoreCase(value)) {
                this.cell.setHorizontalAlignment(3);
            }
        }
        value = props.getProperty("valign");
        this.cell.setVerticalAlignment(5);
        if (value != null) {
            if ("top".equalsIgnoreCase(value)) {
                this.cell.setVerticalAlignment(4);
            } else if ("bottom".equalsIgnoreCase(value)) {
                this.cell.setVerticalAlignment(6);
            }
        }
        value = props.getProperty("border");
        float border = 0.0f;
        if (value != null) {
            border = Float.valueOf(value).floatValue();
        }
        this.cell.setBorderWidth(border);
        value = props.getProperty("cellpadding");
        if (value != null) {
            this.cell.setPadding(Float.valueOf(value).floatValue());
        }
        this.cell.setUseDescender(true);
        value = props.getProperty("bgcolor");
        this.cell.setBackgroundColor(FactoryProperties.decodeColor(value));
    }

    public boolean add(Object o) {
        if (!(o instanceof Element)) {
            return false;
        }
        this.cell.addElement((Element)o);
        return true;
    }

    public PdfPCell getCell() {
        return this.cell;
    }

    public ArrayList getChunks() {
        return this.chunks;
    }

    public boolean process(ElementListener listener) {
        return true;
    }

    public int type() {
        return 0;
    }
}

