/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.DocumentException;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.pdf.ByteBuffer;
import com.lowagie2.text.pdf.CMYKColor;
import com.lowagie2.text.pdf.DocumentFont;
import com.lowagie2.text.pdf.FdfReader;
import com.lowagie2.text.pdf.FdfWriter;
import com.lowagie2.text.pdf.FontDetails;
import com.lowagie2.text.pdf.GrayColor;
import com.lowagie2.text.pdf.IntHashtable;
import com.lowagie2.text.pdf.PRIndirectReference;
import com.lowagie2.text.pdf.PRStream;
import com.lowagie2.text.pdf.PRTokeniser;
import com.lowagie2.text.pdf.PdfAppearance;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfBoolean;
import com.lowagie2.text.pdf.PdfDate;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfEncodings;
import com.lowagie2.text.pdf.PdfFormField;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfPKCS7;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfStamperImp;
import com.lowagie2.text.pdf.PdfString;
import com.lowagie2.text.pdf.PdfWriter;
import com.lowagie2.text.pdf.RandomAccessFileOrArray;
import com.lowagie2.text.pdf.TextField;
import com.lowagie2.text.pdf.XfaForm;
import com.lowagie2.text.pdf.XfdfReader;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

public class AcroFields {
    private static final int DA_COLOR = 2;
    private static final int DA_FONT = 0;
    private static final int DA_SIZE = 1;
    public static final int FIELD_TYPE_CHECKBOX = 2;
    public static final int FIELD_TYPE_COMBO = 6;
    public static final int FIELD_TYPE_LIST = 5;
    public static final int FIELD_TYPE_NONE = 0;
    public static final int FIELD_TYPE_PUSHBUTTON = 1;
    public static final int FIELD_TYPE_RADIOBUTTON = 3;
    public static final int FIELD_TYPE_SIGNATURE = 7;
    public static final int FIELD_TYPE_TEXT = 4;
    private boolean append;
    private HashMap extensionFonts = new HashMap();
    private float extraMarginLeft;
    private float extraMarginTop;
    private HashMap fieldCache;
    HashMap fields;
    private boolean generateAppearances = true;
    private boolean lastWasString;
    private HashMap localFonts = new HashMap();
    PdfReader reader;
    private HashMap sigNames;
    private static final HashMap stdFieldFontNames = new HashMap();
    private ArrayList substitutionFonts;
    private int topFirst;
    private int totalRevisions;
    PdfWriter writer;
    private XfaForm xfa;

    static {
        stdFieldFontNames.put("CoBO", new String[]{"Courier-BoldOblique"});
        stdFieldFontNames.put("CoBo", new String[]{"Courier-Bold"});
        stdFieldFontNames.put("CoOb", new String[]{"Courier-Oblique"});
        stdFieldFontNames.put("Cour", new String[]{"Courier"});
        stdFieldFontNames.put("HeBO", new String[]{"Helvetica-BoldOblique"});
        stdFieldFontNames.put("HeBo", new String[]{"Helvetica-Bold"});
        stdFieldFontNames.put("HeOb", new String[]{"Helvetica-Oblique"});
        stdFieldFontNames.put("Helv", new String[]{"Helvetica"});
        stdFieldFontNames.put("Symb", new String[]{"Symbol"});
        stdFieldFontNames.put("TiBI", new String[]{"Times-BoldItalic"});
        stdFieldFontNames.put("TiBo", new String[]{"Times-Bold"});
        stdFieldFontNames.put("TiIt", new String[]{"Times-Italic"});
        stdFieldFontNames.put("TiRo", new String[]{"Times-Roman"});
        stdFieldFontNames.put("ZaDb", new String[]{"ZapfDingbats"});
        stdFieldFontNames.put("HySm", new String[]{"HYSMyeongJo-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("HyGo", new String[]{"HYGoThic-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaGo", new String[]{"HeiseiKakuGo-W5", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaMi", new String[]{"HeiseiMin-W3", "UniJIS-UCS2-H"});
        stdFieldFontNames.put("MHei", new String[]{"MHei-Medium", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("MSun", new String[]{"MSung-Light", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("STSo", new String[]{"STSong-Light", "UniGB-UCS2-H"});
    }

    AcroFields(PdfReader reader, PdfWriter writer) {
        this.reader = reader;
        this.writer = writer;
        try {
            this.xfa = new XfaForm(reader);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        if (writer instanceof PdfStamperImp) {
            this.append = ((PdfStamperImp)writer).isAppend();
        }
        this.fill();
    }

    public void addSubstitutionFont(BaseFont font) {
        if (this.substitutionFonts == null) {
            this.substitutionFonts = new ArrayList();
        }
        this.substitutionFonts.add(font);
    }

    public void exportAsFdf(FdfWriter writer) {
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Item item = (Item)entry.getValue();
            String name = (String)entry.getKey();
            PdfObject v = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
            if (v == null) continue;
            String value = this.getField(name);
            if (this.lastWasString) {
                writer.setFieldAsString(name, value);
                continue;
            }
            writer.setFieldAsName(name, value);
        }
    }

    public InputStream extractRevision(String field) throws IOException {
        this.getSignatureNames();
        int length = ((int[])this.sigNames.get(field))[0];
        RandomAccessFileOrArray raf = this.reader.getSafeFile();
        raf.reOpen();
        raf.seek(0);
        return new RevisionStream(raf, length);
    }

    void fill() {
        this.fields = new HashMap();
        PdfDictionary top = (PdfDictionary)PdfReader.getPdfObjectRelease(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (top == null) {
            return;
        }
        PdfArray arrfds = (PdfArray)PdfReader.getPdfObjectRelease(top.get(PdfName.FIELDS));
        if (arrfds == null || arrfds.size() == 0) {
            return;
        }
        arrfds = null;
        int k = 1;
        while (k <= this.reader.getNumberOfPages()) {
            PdfDictionary page;
            PdfArray annots;
            if (k % 100 == 0) {
                System.out.println(k);
            }
            if ((annots = (PdfArray)PdfReader.getPdfObjectRelease((page = this.reader.getPageNRelease(k)).get(PdfName.ANNOTS), page)) != null) {
                ArrayList arr = annots.getArrayList();
                int j = 0;
                while (j < arr.size()) {
                    PdfObject annoto = PdfReader.getPdfObject((PdfObject)arr.get(j), annots);
                    if (annoto instanceof PdfIndirectReference && !annoto.isIndirect()) {
                        PdfReader.releaseLastXrefPartial((PdfObject)arr.get(j));
                    } else {
                        PdfDictionary annot = (PdfDictionary)annoto;
                        if (!PdfName.WIDGET.equals(annot.get(PdfName.SUBTYPE))) {
                            PdfReader.releaseLastXrefPartial((PdfObject)arr.get(j));
                        } else {
                            Item item;
                            PdfDictionary widget = annot;
                            PdfDictionary dic = new PdfDictionary();
                            dic.putAll(annot);
                            String name = "";
                            PdfDictionary value = null;
                            PdfObject lastV = null;
                            while (annot != null) {
                                dic.mergeDifferent(annot);
                                PdfString t = (PdfString)PdfReader.getPdfObject(annot.get(PdfName.T));
                                if (t != null) {
                                    name = t.toUnicodeString() + "." + name;
                                }
                                if (lastV == null && annot.get(PdfName.V) != null) {
                                    lastV = PdfReader.getPdfObjectRelease(annot.get(PdfName.V));
                                }
                                if (value == null && t != null) {
                                    value = annot;
                                    if (annot.get(PdfName.V) == null && lastV != null) {
                                        value.put(PdfName.V, lastV);
                                    }
                                }
                                annot = (PdfDictionary)PdfReader.getPdfObject(annot.get(PdfName.PARENT), annot);
                            }
                            if (name.length() > 0) {
                                name = name.substring(0, name.length() - 1);
                            }
                            if ((item = (Item)this.fields.get(name)) == null) {
                                item = new Item();
                                this.fields.put(name, item);
                            }
                            if (value == null) {
                                item.values.add(widget);
                            } else {
                                item.values.add(value);
                            }
                            item.widgets.add(widget);
                            item.widget_refs.add(arr.get(j));
                            if (top != null) {
                                dic.mergeDifferent(top);
                            }
                            item.merged.add(dic);
                            item.page.add(new Integer(k));
                            item.tabOrder.add(new Integer(j));
                        }
                    }
                    ++j;
                }
            }
            ++k;
        }
    }

    PdfAppearance getAppearance(PdfDictionary merged, String text, String fieldName) throws IOException, DocumentException {
        this.topFirst = 0;
        int flags = 0;
        TextField tx = null;
        if (this.fieldCache == null || !this.fieldCache.containsKey(fieldName)) {
            PdfDictionary bs;
            PdfNumber nfl;
            PdfDictionary mk;
            tx = new TextField(this.writer, null, null);
            tx.setExtraMargin(this.extraMarginLeft, this.extraMarginTop);
            tx.setBorderWidth(0.0f);
            tx.setSubstitutionFonts(this.substitutionFonts);
            PdfString da = (PdfString)PdfReader.getPdfObject(merged.get(PdfName.DA));
            if (da != null) {
                PdfDictionary font;
                Object[] dab = AcroFields.splitDAelements(da.toUnicodeString());
                if (dab[1] != null) {
                    tx.setFontSize(((Float)dab[1]).floatValue());
                }
                if (dab[2] != null) {
                    tx.setTextColor((Color)dab[2]);
                }
                if (dab[0] != null && (font = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.DR))) != null && (font = (PdfDictionary)PdfReader.getPdfObject(font.get(PdfName.FONT))) != null) {
                    PdfObject po = font.get(new PdfName((String)dab[0]));
                    if (po != null && po.type() == 10) {
                        PdfDictionary fo;
                        PdfDictionary fd;
                        PRIndirectReference por = (PRIndirectReference)po;
                        DocumentFont bp = new DocumentFont((PRIndirectReference)po);
                        tx.setFont(bp);
                        Integer porkey = new Integer(por.getNumber());
                        BaseFont porf = (BaseFont)this.extensionFonts.get(porkey);
                        if (porf == null && !this.extensionFonts.containsKey(porkey) && (fd = (PdfDictionary)PdfReader.getPdfObject((fo = (PdfDictionary)PdfReader.getPdfObject(po)).get(PdfName.FONTDESCRIPTOR))) != null) {
                            PRStream prs = (PRStream)PdfReader.getPdfObject(fd.get(PdfName.FONTFILE2));
                            if (prs == null) {
                                prs = (PRStream)PdfReader.getPdfObject(fd.get(PdfName.FONTFILE3));
                            }
                            if (prs == null) {
                                this.extensionFonts.put(porkey, null);
                            } else {
                                try {
                                    porf = BaseFont.createFont("font.ttf", "Identity-H", true, false, PdfReader.getStreamBytes(prs), null);
                                }
                                catch (Exception e) {
                                    porf = null;
                                }
                                this.extensionFonts.put(porkey, porf);
                            }
                        }
                        tx.setExtensionFont(porf);
                    } else {
                        BaseFont bf = (BaseFont)this.localFonts.get(dab[0]);
                        if (bf == null) {
                            String[] fn = (String[])stdFieldFontNames.get(dab[0]);
                            if (fn != null) {
                                try {
                                    String enc = "winansi";
                                    if (fn.length > 1) {
                                        enc = fn[1];
                                    }
                                    bf = BaseFont.createFont(fn[0], enc, false);
                                    tx.setFont(bf);
                                }
                                catch (Exception e) {
                                }
                            }
                        } else {
                            tx.setFont(bf);
                        }
                    }
                }
            }
            if ((mk = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.MK))) != null) {
                PdfArray ar = (PdfArray)PdfReader.getPdfObject(mk.get(PdfName.BC));
                Color border = this.getMKColor(ar);
                tx.setBorderColor(border);
                if (border != null) {
                    tx.setBorderWidth(1.0f);
                }
                ar = (PdfArray)PdfReader.getPdfObject(mk.get(PdfName.BG));
                tx.setBackgroundColor(this.getMKColor(ar));
                PdfNumber rotation = (PdfNumber)PdfReader.getPdfObject(mk.get(PdfName.R));
                if (rotation != null) {
                    tx.setRotation(rotation.intValue());
                }
            }
            if ((nfl = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.FF))) != null) {
                flags = nfl.intValue();
            }
            tx.setOptions(((flags & 0x1000) == 0 ? 0 : 4) | ((flags & 0x1000000) == 0 ? 0 : 256));
            if ((flags & 0x1000000) != 0) {
                PdfNumber maxLen = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.MAXLEN));
                int len = 0;
                if (maxLen != null) {
                    len = maxLen.intValue();
                }
                tx.setMaxCharacterLength(len);
            }
            if ((nfl = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.Q))) != null) {
                if (nfl.intValue() == 1) {
                    tx.setAlignment(1);
                } else if (nfl.intValue() == 2) {
                    tx.setAlignment(2);
                }
            }
            if ((bs = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.BS))) != null) {
                PdfName s;
                PdfNumber w = (PdfNumber)PdfReader.getPdfObject(bs.get(PdfName.W));
                if (w != null) {
                    tx.setBorderWidth(w.floatValue());
                }
                if (PdfName.D.equals(s = (PdfName)PdfReader.getPdfObject(bs.get(PdfName.S)))) {
                    tx.setBorderStyle(1);
                } else if (PdfName.B.equals(s)) {
                    tx.setBorderStyle(2);
                } else if (PdfName.I.equals(s)) {
                    tx.setBorderStyle(3);
                } else if (PdfName.U.equals(s)) {
                    tx.setBorderStyle(4);
                }
            } else {
                PdfArray bd = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.BORDER));
                if (bd != null) {
                    ArrayList ar = bd.getArrayList();
                    if (ar.size() >= 3) {
                        tx.setBorderWidth(((PdfNumber)ar.get(2)).floatValue());
                    }
                    if (ar.size() >= 4) {
                        tx.setBorderStyle(1);
                    }
                }
            }
            PdfArray rect = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.RECT));
            Rectangle box = PdfReader.getNormalizedRectangle(rect);
            if (tx.getRotation() == 90 || tx.getRotation() == 270) {
                box = box.rotate();
            }
            tx.setBox(box);
            if (this.fieldCache != null) {
                this.fieldCache.put(fieldName, tx);
            }
        } else {
            tx = (TextField)this.fieldCache.get(fieldName);
            tx.setWriter(this.writer);
        }
        PdfName fieldType = (PdfName)PdfReader.getPdfObject(merged.get(PdfName.FT));
        if (PdfName.TX.equals(fieldType)) {
            tx.setText(text);
            return tx.getAppearance();
        }
        if (!PdfName.CH.equals(fieldType)) {
            throw new DocumentException("An appearance was requested without a variable text field.");
        }
        PdfArray opt = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.OPT));
        if ((flags & 0x20000) != 0 && opt == null) {
            tx.setText(text);
            return tx.getAppearance();
        }
        if (opt != null) {
            ArrayList op = opt.getArrayList();
            String[] choices = new String[op.size()];
            String[] choicesExp = new String[op.size()];
            int k = 0;
            while (k < op.size()) {
                PdfObject obj = (PdfObject)op.get(k);
                if (obj.isString()) {
                    choices[k] = choicesExp[k] = ((PdfString)obj).toUnicodeString();
                } else {
                    ArrayList opar = ((PdfArray)obj).getArrayList();
                    choicesExp[k] = ((PdfString)opar.get(0)).toUnicodeString();
                    choices[k] = ((PdfString)opar.get(1)).toUnicodeString();
                }
                ++k;
            }
            if ((flags & 0x20000) != 0) {
                int k2 = 0;
                while (k2 < choices.length) {
                    if (text.equals(choicesExp[k2])) {
                        text = choices[k2];
                        break;
                    }
                    ++k2;
                }
                tx.setText(text);
                return tx.getAppearance();
            }
            int idx = 0;
            int k3 = 0;
            while (k3 < choicesExp.length) {
                if (text.equals(choicesExp[k3])) {
                    idx = k3;
                    break;
                }
                ++k3;
            }
            tx.setChoices(choices);
            tx.setChoiceExports(choicesExp);
            tx.setChoiceSelection(idx);
        }
        PdfAppearance app = tx.getListAppearance();
        this.topFirst = tx.getTopFirst();
        return app;
    }

    public String[] getAppearanceStates(String fieldName) {
        int k;
        Item fd = (Item)this.fields.get(fieldName);
        if (fd == null) {
            return null;
        }
        HashMap names = new HashMap();
        PdfDictionary vals = (PdfDictionary)fd.values.get(0);
        PdfObject opts = PdfReader.getPdfObject(vals.get(PdfName.OPT));
        if (opts != null) {
            if (opts.isString()) {
                names.put(((PdfString)opts).toUnicodeString(), null);
            } else if (opts.isArray()) {
                ArrayList list = ((PdfArray)opts).getArrayList();
                k = 0;
                while (k < list.size()) {
                    PdfObject v = PdfReader.getPdfObject((PdfObject)list.get(k));
                    if (v != null && v.isString()) {
                        names.put(((PdfString)v).toUnicodeString(), null);
                    }
                    ++k;
                }
            }
        }
        ArrayList wd = fd.widgets;
        k = 0;
        while (k < wd.size()) {
            PdfObject ob;
            PdfDictionary dic = (PdfDictionary)wd.get(k);
            if ((dic = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.AP))) != null && (ob = PdfReader.getPdfObject(dic.get(PdfName.N))) != null && ob.isDictionary()) {
                dic = (PdfDictionary)ob;
                Iterator it = dic.getKeys().iterator();
                while (it.hasNext()) {
                    String name = PdfName.decodeName(((PdfName)it.next()).toString());
                    names.put(name, null);
                }
            }
            ++k;
        }
        String[] out = new String[names.size()];
        return names.keySet().toArray(out);
    }

    public ArrayList getBlankSignatureNames() {
        this.getSignatureNames();
        ArrayList sigs = new ArrayList();
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Item item = (Item)entry.getValue();
            PdfDictionary merged = (PdfDictionary)item.merged.get(0);
            if (!PdfName.SIG.equals(merged.get(PdfName.FT)) || this.sigNames.containsKey(entry.getKey())) continue;
            sigs.add(entry.getKey());
        }
        return sigs;
    }

    public String getField(String name) {
        if (this.xfa.isXfaPresent()) {
            if ((name = this.xfa.findFieldName(name, this)) == null) {
                return null;
            }
            name = XfaForm.Xml2Som.getShortName(name);
            return XfaForm.getNodeText(this.xfa.findDatasetsNode(name));
        }
        Item item = (Item)this.fields.get(name);
        if (item == null) {
            return null;
        }
        this.lastWasString = false;
        PdfObject v = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
        if (v == null) {
            return "";
        }
        PdfName type = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.BTN.equals(type)) {
            PdfNumber ff = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            int flags = 0;
            if (ff != null) {
                flags = ff.intValue();
            }
            if ((flags & 0x10000) != 0) {
                return "";
            }
            String value = "";
            if (v.isName()) {
                value = PdfName.decodeName(v.toString());
            } else if (v.isString()) {
                value = ((PdfString)v).toUnicodeString();
            }
            PdfObject opts = PdfReader.getPdfObject(((PdfDictionary)item.values.get(0)).get(PdfName.OPT));
            if (opts != null && opts.isArray()) {
                ArrayList list = ((PdfArray)opts).getArrayList();
                int idx = 0;
                try {
                    idx = Integer.parseInt(value);
                    PdfString ps = (PdfString)list.get(idx);
                    value = ps.toUnicodeString();
                    this.lastWasString = true;
                }
                catch (Exception e) {
                }
            }
            return value;
        }
        if (v.isString()) {
            this.lastWasString = true;
            return ((PdfString)v).toUnicodeString();
        }
        return PdfName.decodeName(v.toString());
    }

    public HashMap getFieldCache() {
        return this.fieldCache;
    }

    public Item getFieldItem(String name) {
        return (Item)this.fields.get(name);
    }

    public float[] getFieldPositions(String name) {
        Item item = (Item)this.fields.get(name);
        if (item == null) {
            return null;
        }
        float[] ret = new float[item.page.size() * 5];
        int ptr = 0;
        int k = 0;
        while (k < item.page.size()) {
            try {
                PdfDictionary wd = (PdfDictionary)item.widgets.get(k);
                PdfArray rect = (PdfArray)wd.get(PdfName.RECT);
                if (rect != null) {
                    Rectangle r = PdfReader.getNormalizedRectangle(rect);
                    int page = (Integer)item.page.get(k);
                    int rotation = this.reader.getPageRotation(page);
                    ret[ptr++] = page;
                    if (rotation != 0) {
                        Rectangle pageSize = this.reader.getPageSize(page);
                        switch (rotation) {
                            case 270: {
                                r = new Rectangle(pageSize.top() - r.bottom(), r.left(), pageSize.top() - r.top(), r.right());
                                break;
                            }
                            case 180: {
                                r = new Rectangle(pageSize.right() - r.left(), pageSize.top() - r.bottom(), pageSize.right() - r.right(), pageSize.top() - r.top());
                                break;
                            }
                            case 90: {
                                r = new Rectangle(r.bottom(), pageSize.right() - r.left(), r.top(), pageSize.right() - r.right());
                            }
                        }
                        r.normalize();
                    }
                    ret[ptr++] = r.left();
                    ret[ptr++] = r.bottom();
                    ret[ptr++] = r.right();
                    ret[ptr++] = r.top();
                }
            }
            catch (Exception e) {
            }
            ++k;
        }
        if (ptr < ret.length) {
            float[] ret2 = new float[ptr];
            System.arraycopy(ret, 0, ret2, 0, ptr);
            return ret2;
        }
        return ret;
    }

    public int getFieldType(String fieldName) {
        Item fd = (Item)this.fields.get(fieldName);
        if (fd == null) {
            return 0;
        }
        PdfObject type = PdfReader.getPdfObject(((PdfDictionary)fd.merged.get(0)).get(PdfName.FT));
        if (type == null) {
            return 0;
        }
        int ff = 0;
        PdfObject ffo = PdfReader.getPdfObject(((PdfDictionary)fd.merged.get(0)).get(PdfName.FF));
        if (ffo != null && ffo.type() == 2) {
            ff = ((PdfNumber)ffo).intValue();
        }
        if (PdfName.BTN.equals(type)) {
            if ((ff & 0x10000) != 0) {
                return 1;
            }
            if ((ff & 0x8000) != 0) {
                return 3;
            }
            return 2;
        }
        if (PdfName.TX.equals(type)) {
            return 4;
        }
        if (PdfName.CH.equals(type)) {
            if ((ff & 0x20000) != 0) {
                return 6;
            }
            return 5;
        }
        if (PdfName.SIG.equals(type)) {
            return 7;
        }
        return 0;
    }

    public HashMap getFields() {
        return this.fields;
    }

    private String[] getListOption(String fieldName, int idx) {
        Item fd = (Item)this.fields.get(fieldName);
        if (fd == null) {
            return null;
        }
        PdfObject obj = PdfReader.getPdfObject(((PdfDictionary)fd.merged.get(0)).get(PdfName.OPT));
        if (obj == null || !obj.isArray()) {
            return null;
        }
        PdfArray ar = (PdfArray)obj;
        String[] ret = new String[ar.size()];
        ArrayList a = ar.getArrayList();
        int k = 0;
        while (k < a.size()) {
            obj = PdfReader.getPdfObject((PdfObject)a.get(k));
            try {
                if (obj.isArray()) {
                    obj = (PdfObject)((PdfArray)obj).getArrayList().get(idx);
                }
                ret[k] = obj.isString() ? ((PdfString)obj).toUnicodeString() : obj.toString();
            }
            catch (Exception e) {
                ret[k] = "";
            }
            ++k;
        }
        return ret;
    }

    public String[] getListOptionDisplay(String fieldName) {
        return this.getListOption(fieldName, 1);
    }

    public String[] getListOptionExport(String fieldName) {
        return this.getListOption(fieldName, 0);
    }

    Color getMKColor(PdfArray ar) {
        if (ar == null) {
            return null;
        }
        ArrayList cc = ar.getArrayList();
        switch (cc.size()) {
            case 1: {
                return new GrayColor(((PdfNumber)cc.get(0)).floatValue());
            }
            case 3: {
                return new Color(((PdfNumber)cc.get(0)).floatValue(), ((PdfNumber)cc.get(1)).floatValue(), ((PdfNumber)cc.get(2)).floatValue());
            }
            case 4: {
                return new CMYKColor(((PdfNumber)cc.get(0)).floatValue(), ((PdfNumber)cc.get(1)).floatValue(), ((PdfNumber)cc.get(2)).floatValue(), ((PdfNumber)cc.get(3)).floatValue());
            }
        }
        return null;
    }

    public int getRevision(String field) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(field)) {
            return 0;
        }
        return ((int[])this.sigNames.get(field))[1];
    }

    public PdfDictionary getSignatureDictionary(String name) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(name)) {
            return null;
        }
        Item item = (Item)this.fields.get(name);
        PdfDictionary merged = (PdfDictionary)item.merged.get(0);
        return (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.V));
    }

    public ArrayList getSignatureNames() {
        if (this.sigNames != null) {
            return new ArrayList(this.sigNames.keySet());
        }
        this.sigNames = new HashMap();
        ArrayList<Object[]> sorter = new ArrayList<Object[]>();
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            ArrayList ra;
            PdfObject ro;
            PdfDictionary v;
            PdfObject contents;
            PdfObject vo;
            Map.Entry entry = it.next();
            Item item = (Item)entry.getValue();
            PdfDictionary merged = (PdfDictionary)item.merged.get(0);
            if (!PdfName.SIG.equals(merged.get(PdfName.FT)) || (vo = PdfReader.getPdfObject(merged.get(PdfName.V))) == null || vo.type() != 6 || (contents = (v = (PdfDictionary)vo).get(PdfName.CONTENTS)) == null || contents.type() != 3 || (ro = v.get(PdfName.BYTERANGE)) == null || ro.type() != 5 || (ra = ((PdfArray)ro).getArrayList()).size() < 2) continue;
            int length = ((PdfNumber)ra.get(ra.size() - 1)).intValue() + ((PdfNumber)ra.get(ra.size() - 2)).intValue();
            sorter.add(new Object[]{entry.getKey(), new int[]{length, 0}});
        }
        Collections.sort(sorter, new SorterComparator());
        if (sorter.size() > 0) {
            this.totalRevisions = ((int[])((Object[])sorter.get(sorter.size() - 1))[1])[0] == this.reader.getFileLength() ? sorter.size() : sorter.size() + 1;
            int k = 0;
            while (k < sorter.size()) {
                Object[] objs = (Object[])sorter.get(k);
                String name = (String)objs[0];
                int[] p = (int[])objs[1];
                p[1] = k + 1;
                this.sigNames.put(name, p);
                ++k;
            }
        }
        return new ArrayList(this.sigNames.keySet());
    }

    public ArrayList getSubstitutionFonts() {
        return this.substitutionFonts;
    }

    public int getTotalRevisions() {
        this.getSignatureNames();
        return this.totalRevisions;
    }

    public XfaForm getXfa() {
        return this.xfa;
    }

    public boolean isGenerateAppearances() {
        return this.generateAppearances;
    }

    boolean isInAP(PdfDictionary dic, PdfName check) {
        PdfDictionary appDic = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.AP));
        if (appDic == null) {
            return false;
        }
        PdfDictionary NDic = (PdfDictionary)PdfReader.getPdfObject(appDic.get(PdfName.N));
        return NDic != null && NDic.get(check) != null;
    }

    private void markUsed(PdfObject obj) {
        if (!this.append) {
            return;
        }
        ((PdfStamperImp)this.writer).markUsed(obj);
    }

    public void mergeXfaData(Node n) throws IOException, DocumentException {
        XfaForm.Xml2SomDatasets data = new XfaForm.Xml2SomDatasets(n);
        Iterator it = data.getOrder().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String text = XfaForm.getNodeText((Node)data.getName2Node().get(name));
            this.setField(name, text);
        }
    }

    public boolean removeField(String name) {
        return this.removeField(name, -1);
    }

    public boolean removeField(String name, int page) {
        Item item = (Item)this.fields.get(name);
        if (item == null) {
            return false;
        }
        PdfDictionary acroForm = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog());
        if (acroForm == null) {
            return false;
        }
        PdfArray arrayf = (PdfArray)PdfReader.getPdfObject(acroForm.get(PdfName.FIELDS), acroForm);
        if (arrayf == null) {
            return false;
        }
        int k = 0;
        while (k < item.widget_refs.size()) {
            int pageV = (Integer)item.page.get(k);
            if (page == -1 || page == pageV) {
                PdfIndirectReference ref = (PdfIndirectReference)item.widget_refs.get(k);
                PdfDictionary wd = (PdfDictionary)PdfReader.getPdfObject(ref);
                PdfDictionary pageDic = this.reader.getPageN(pageV);
                PdfArray annots = (PdfArray)PdfReader.getPdfObject(pageDic.get(PdfName.ANNOTS), pageDic);
                if (annots != null) {
                    if (this.removeRefFromArray(annots, ref) == 0) {
                        pageDic.remove(PdfName.ANNOTS);
                        this.markUsed(pageDic);
                    } else {
                        this.markUsed(annots);
                    }
                }
                PdfReader.killIndirect(ref);
                PdfIndirectReference kid = ref;
                while ((ref = (PdfIndirectReference)wd.get(PdfName.PARENT)) != null) {
                    wd = (PdfDictionary)PdfReader.getPdfObject(ref);
                    PdfArray kids = (PdfArray)PdfReader.getPdfObject(wd.get(PdfName.KIDS));
                    if (this.removeRefFromArray(kids, kid) != 0) break;
                    kid = ref;
                    PdfReader.killIndirect(ref);
                }
                if (ref == null) {
                    this.removeRefFromArray(arrayf, kid);
                    this.markUsed(arrayf);
                }
                if (page != -1) {
                    item.merged.remove(k);
                    item.page.remove(k);
                    item.values.remove(k);
                    item.widget_refs.remove(k);
                    item.widgets.remove(k);
                    --k;
                }
            }
            ++k;
        }
        if (page == -1 || item.merged.size() == 0) {
            this.fields.remove(name);
        }
        return true;
    }

    public boolean removeFieldsFromPage(int page) {
        if (page < 1) {
            return false;
        }
        String[] names = new String[this.fields.size()];
        this.fields.keySet().toArray(names);
        boolean found = false;
        int k = 0;
        while (k < names.length) {
            boolean fr = this.removeField(names[k], page);
            found = found || fr;
            ++k;
        }
        return found;
    }

    private int removeRefFromArray(PdfArray array, PdfObject refo) {
        ArrayList ar = array.getArrayList();
        if (refo == null || !refo.isIndirect()) {
            return ar.size();
        }
        PdfIndirectReference ref = (PdfIndirectReference)refo;
        int j = 0;
        while (j < ar.size()) {
            PdfObject obj = (PdfObject)ar.get(j);
            if (obj.isIndirect() && ((PdfIndirectReference)obj).getNumber() == ref.getNumber()) {
                ar.remove(j--);
            }
            ++j;
        }
        return ar.size();
    }

    public boolean renameField(String oldName, String newName) {
        int idx2;
        int idx1 = oldName.lastIndexOf(46) + 1;
        if (idx1 != (idx2 = newName.lastIndexOf(46) + 1)) {
            return false;
        }
        if (!oldName.substring(0, idx1).equals(newName.substring(0, idx2))) {
            return false;
        }
        if (this.fields.containsKey(newName)) {
            return false;
        }
        Item item = (Item)this.fields.get(oldName);
        if (item == null) {
            return false;
        }
        newName = newName.substring(idx2);
        PdfString ss = new PdfString(newName, "UnicodeBig");
        int k = 0;
        while (k < item.merged.size()) {
            PdfDictionary dic = (PdfDictionary)item.values.get(k);
            dic.put(PdfName.T, ss);
            this.markUsed(dic);
            dic = (PdfDictionary)item.merged.get(k);
            dic.put(PdfName.T, ss);
            ++k;
        }
        this.fields.remove(oldName);
        this.fields.put(newName, item);
        return true;
    }

    public void setExtraMargin(float extraMarginLeft, float extraMarginTop) {
        this.extraMarginLeft = extraMarginLeft;
        this.extraMarginTop = extraMarginTop;
    }

    public boolean setField(String name, String value, String display) throws IOException, DocumentException {
        Item item;
        if (this.writer == null) {
            throw new DocumentException("This AcroFields instance is read-only.");
        }
        if (this.xfa.isXfaPresent()) {
            if ((name = this.xfa.findFieldName(name, this)) == null) {
                return false;
            }
            String shortName = XfaForm.Xml2Som.getShortName(name);
            this.xfa.setNodeText(this.xfa.findDatasetsNode(shortName), value);
        }
        if ((item = (Item)this.fields.get(name)) == null) {
            return false;
        }
        PdfName type = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.TX.equals(type)) {
            PdfNumber maxLen = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.MAXLEN));
            int len = 0;
            if (maxLen != null) {
                len = maxLen.intValue();
            }
            if (len > 0) {
                value = value.substring(0, Math.min(len, value.length()));
            }
        }
        if (PdfName.TX.equals(type) || PdfName.CH.equals(type)) {
            PdfString v = new PdfString(value, "UnicodeBig");
            int idx = 0;
            while (idx < item.values.size()) {
                PdfDictionary valueDic = (PdfDictionary)item.values.get(idx);
                valueDic.put(PdfName.V, v);
                valueDic.remove(PdfName.I);
                this.markUsed(valueDic);
                PdfDictionary merged = (PdfDictionary)item.merged.get(idx);
                merged.remove(PdfName.I);
                merged.put(PdfName.V, v);
                PdfDictionary widget = (PdfDictionary)item.widgets.get(idx);
                if (this.generateAppearances) {
                    PdfDictionary appDic;
                    PdfAppearance app = this.getAppearance(merged, display, name);
                    if (PdfName.CH.equals(type)) {
                        PdfNumber n = new PdfNumber(this.topFirst);
                        widget.put(PdfName.TI, n);
                        merged.put(PdfName.TI, n);
                    }
                    if ((appDic = (PdfDictionary)PdfReader.getPdfObject(widget.get(PdfName.AP))) == null) {
                        appDic = new PdfDictionary();
                        widget.put(PdfName.AP, appDic);
                        merged.put(PdfName.AP, appDic);
                    }
                    appDic.put(PdfName.N, app.getIndirectReference());
                    this.writer.releaseTemplate(app);
                } else {
                    widget.remove(PdfName.AP);
                    merged.remove(PdfName.AP);
                }
                this.markUsed(widget);
                ++idx;
            }
            return true;
        }
        if (PdfName.BTN.equals(type)) {
            PdfNumber ff = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            int flags = 0;
            if (ff != null) {
                flags = ff.intValue();
            }
            if ((flags & 0x10000) != 0) {
                return true;
            }
            PdfName v = new PdfName(value);
            if ((flags & 0x8000) == 0) {
                int idx = 0;
                while (idx < item.values.size()) {
                    ((PdfDictionary)item.values.get(idx)).put(PdfName.V, v);
                    this.markUsed((PdfDictionary)item.values.get(idx));
                    PdfDictionary merged = (PdfDictionary)item.merged.get(idx);
                    merged.put(PdfName.V, v);
                    merged.put(PdfName.AS, v);
                    PdfDictionary widget = (PdfDictionary)item.widgets.get(idx);
                    if (this.isInAP(widget, v)) {
                        widget.put(PdfName.AS, v);
                    } else {
                        widget.put(PdfName.AS, PdfName.Off);
                    }
                    this.markUsed(widget);
                    ++idx;
                }
            } else {
                ArrayList<String> lopt = new ArrayList<String>();
                PdfObject opts = PdfReader.getPdfObject(((PdfDictionary)item.values.get(0)).get(PdfName.OPT));
                if (opts != null && opts.isArray()) {
                    ArrayList list = ((PdfArray)opts).getArrayList();
                    int k = 0;
                    while (k < list.size()) {
                        PdfObject vv = PdfReader.getPdfObject((PdfObject)list.get(k));
                        if (vv != null && vv.isString()) {
                            lopt.add(((PdfString)vv).toUnicodeString());
                        } else {
                            lopt.add(null);
                        }
                        ++k;
                    }
                }
                int vidx = lopt.indexOf(value);
                PdfName valt = null;
                PdfName vt = vidx >= 0 ? (valt = new PdfName(String.valueOf(vidx))) : v;
                int idx = 0;
                while (idx < item.values.size()) {
                    PdfDictionary merged = (PdfDictionary)item.merged.get(idx);
                    PdfDictionary widget = (PdfDictionary)item.widgets.get(idx);
                    this.markUsed((PdfDictionary)item.values.get(idx));
                    if (valt != null) {
                        PdfString ps = new PdfString(value, "UnicodeBig");
                        ((PdfDictionary)item.values.get(idx)).put(PdfName.V, ps);
                        merged.put(PdfName.V, ps);
                    } else {
                        ((PdfDictionary)item.values.get(idx)).put(PdfName.V, v);
                        merged.put(PdfName.V, v);
                    }
                    this.markUsed(widget);
                    if (this.isInAP(widget, vt)) {
                        merged.put(PdfName.AS, vt);
                        widget.put(PdfName.AS, vt);
                    } else {
                        merged.put(PdfName.AS, PdfName.Off);
                        widget.put(PdfName.AS, PdfName.Off);
                    }
                    ++idx;
                }
            }
            return true;
        }
        return false;
    }

    public boolean setField(String name, String value) throws IOException, DocumentException {
        return this.setField(name, value, value);
    }

    public void setFieldCache(HashMap fieldCache) {
        this.fieldCache = fieldCache;
    }

    public boolean setFieldProperty(String field, String name, int value, int[] inst) {
        if (this.writer == null) {
            throw new RuntimeException("This AcroFields instance is read-only.");
        }
        Item item = (Item)this.fields.get(field);
        if (item == null) {
            return false;
        }
        InstHit hit = new InstHit(inst);
        if (name.equalsIgnoreCase("flags")) {
            PdfNumber num = new PdfNumber(value);
            int k = 0;
            while (k < item.merged.size()) {
                if (hit.isHit(k)) {
                    ((PdfDictionary)item.merged.get(k)).put(PdfName.F, num);
                    ((PdfDictionary)item.widgets.get(k)).put(PdfName.F, num);
                    this.markUsed((PdfDictionary)item.widgets.get(k));
                }
                ++k;
            }
        } else if (name.equalsIgnoreCase("setflags")) {
            int k = 0;
            while (k < item.merged.size()) {
                if (hit.isHit(k)) {
                    PdfNumber num = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.widgets.get(k)).get(PdfName.F));
                    int val = 0;
                    if (num != null) {
                        val = num.intValue();
                    }
                    num = new PdfNumber(val | value);
                    ((PdfDictionary)item.merged.get(k)).put(PdfName.F, num);
                    ((PdfDictionary)item.widgets.get(k)).put(PdfName.F, num);
                    this.markUsed((PdfDictionary)item.widgets.get(k));
                }
                ++k;
            }
        } else if (name.equalsIgnoreCase("clrflags")) {
            int k = 0;
            while (k < item.merged.size()) {
                if (hit.isHit(k)) {
                    PdfNumber num = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.widgets.get(k)).get(PdfName.F));
                    int val = 0;
                    if (num != null) {
                        val = num.intValue();
                    }
                    num = new PdfNumber(val & ~value);
                    ((PdfDictionary)item.merged.get(k)).put(PdfName.F, num);
                    ((PdfDictionary)item.widgets.get(k)).put(PdfName.F, num);
                    this.markUsed((PdfDictionary)item.widgets.get(k));
                }
                ++k;
            }
        } else if (name.equalsIgnoreCase("fflags")) {
            PdfNumber num = new PdfNumber(value);
            int k = 0;
            while (k < item.merged.size()) {
                if (hit.isHit(k)) {
                    ((PdfDictionary)item.merged.get(k)).put(PdfName.FF, num);
                    ((PdfDictionary)item.values.get(k)).put(PdfName.FF, num);
                    this.markUsed((PdfDictionary)item.values.get(k));
                }
                ++k;
            }
        } else if (name.equalsIgnoreCase("setfflags")) {
            int k = 0;
            while (k < item.merged.size()) {
                if (hit.isHit(k)) {
                    PdfNumber num = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.values.get(k)).get(PdfName.FF));
                    int val = 0;
                    if (num != null) {
                        val = num.intValue();
                    }
                    num = new PdfNumber(val | value);
                    ((PdfDictionary)item.merged.get(k)).put(PdfName.FF, num);
                    ((PdfDictionary)item.values.get(k)).put(PdfName.FF, num);
                    this.markUsed((PdfDictionary)item.values.get(k));
                }
                ++k;
            }
        } else if (name.equalsIgnoreCase("clrfflags")) {
            int k = 0;
            while (k < item.merged.size()) {
                if (hit.isHit(k)) {
                    PdfNumber num = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.values.get(k)).get(PdfName.FF));
                    int val = 0;
                    if (num != null) {
                        val = num.intValue();
                    }
                    num = new PdfNumber(val & ~value);
                    ((PdfDictionary)item.merged.get(k)).put(PdfName.FF, num);
                    ((PdfDictionary)item.values.get(k)).put(PdfName.FF, num);
                    this.markUsed((PdfDictionary)item.values.get(k));
                }
                ++k;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean setFieldProperty(String field, String name, Object value, int[] inst) {
        if (this.writer == null) {
            throw new RuntimeException("This AcroFields instance is read-only.");
        }
        try {
            Item item = (Item)this.fields.get(field);
            if (item == null) {
                return false;
            }
            InstHit hit = new InstHit(inst);
            if (name.equalsIgnoreCase("textfont")) {
                int k = 0;
                while (k < item.merged.size()) {
                    if (hit.isHit(k)) {
                        PdfString da = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(k)).get(PdfName.DA));
                        PdfDictionary dr = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(k)).get(PdfName.DR));
                        if (da != null && dr != null) {
                            Object[] dao = AcroFields.splitDAelements(da.toUnicodeString());
                            PdfAppearance cb = new PdfAppearance();
                            if (dao[0] != null) {
                                PdfDictionary fonts;
                                BaseFont bf = (BaseFont)value;
                                PdfName psn = (PdfName)PdfAppearance.stdFieldFontNames.get(bf.getPostscriptFontName());
                                if (psn == null) {
                                    psn = new PdfName(bf.getPostscriptFontName());
                                }
                                if ((fonts = (PdfDictionary)PdfReader.getPdfObject(dr.get(PdfName.FONT))) == null) {
                                    fonts = new PdfDictionary();
                                    dr.put(PdfName.FONT, fonts);
                                }
                                PdfIndirectReference fref = (PdfIndirectReference)fonts.get(psn);
                                PdfDictionary top = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
                                this.markUsed(top);
                                dr = (PdfDictionary)PdfReader.getPdfObject(top.get(PdfName.DR));
                                if (dr == null) {
                                    dr = new PdfDictionary();
                                    top.put(PdfName.DR, dr);
                                }
                                this.markUsed(dr);
                                PdfDictionary fontsTop = (PdfDictionary)PdfReader.getPdfObject(dr.get(PdfName.FONT));
                                if (fontsTop == null) {
                                    fontsTop = new PdfDictionary();
                                    dr.put(PdfName.FONT, fontsTop);
                                }
                                this.markUsed(fontsTop);
                                PdfIndirectReference frefTop = (PdfIndirectReference)fontsTop.get(psn);
                                if (frefTop != null) {
                                    if (fref == null) {
                                        fonts.put(psn, frefTop);
                                    }
                                } else if (fref == null) {
                                    FontDetails fd;
                                    if (bf.getFontType() == 4) {
                                        fd = new FontDetails(null, ((DocumentFont)bf).getIndirectReference(), bf);
                                    } else {
                                        bf.setSubset(false);
                                        fd = this.writer.addSimple(bf);
                                        this.localFonts.put(psn.toString().substring(1), bf);
                                    }
                                    fontsTop.put(psn, fd.getIndirectReference());
                                    fonts.put(psn, fd.getIndirectReference());
                                }
                                ByteBuffer buf = cb.getInternalBuffer();
                                buf.append(psn.getBytes()).append(' ').append(((Float)dao[1]).floatValue()).append(" Tf ");
                                if (dao[2] != null) {
                                    cb.setColorFill((Color)dao[2]);
                                }
                                PdfString s = new PdfString(cb.toString());
                                ((PdfDictionary)item.merged.get(k)).put(PdfName.DA, s);
                                ((PdfDictionary)item.widgets.get(k)).put(PdfName.DA, s);
                                this.markUsed((PdfDictionary)item.widgets.get(k));
                            }
                        }
                    }
                    ++k;
                }
            } else if (name.equalsIgnoreCase("textcolor")) {
                int k = 0;
                while (k < item.merged.size()) {
                    PdfString da;
                    if (hit.isHit(k) && (da = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(k)).get(PdfName.DA))) != null) {
                        Object[] dao = AcroFields.splitDAelements(da.toUnicodeString());
                        PdfAppearance cb = new PdfAppearance();
                        if (dao[0] != null) {
                            ByteBuffer buf = cb.getInternalBuffer();
                            buf.append(new PdfName((String)dao[0]).getBytes()).append(' ').append(((Float)dao[1]).floatValue()).append(" Tf ");
                            cb.setColorFill((Color)value);
                            PdfString s = new PdfString(cb.toString());
                            ((PdfDictionary)item.merged.get(k)).put(PdfName.DA, s);
                            ((PdfDictionary)item.widgets.get(k)).put(PdfName.DA, s);
                            this.markUsed((PdfDictionary)item.widgets.get(k));
                        }
                    }
                    ++k;
                }
            } else if (name.equalsIgnoreCase("textsize")) {
                int k = 0;
                while (k < item.merged.size()) {
                    PdfString da;
                    if (hit.isHit(k) && (da = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(k)).get(PdfName.DA))) != null) {
                        Object[] dao = AcroFields.splitDAelements(da.toUnicodeString());
                        PdfAppearance cb = new PdfAppearance();
                        if (dao[0] != null) {
                            ByteBuffer buf = cb.getInternalBuffer();
                            buf.append(new PdfName((String)dao[0]).getBytes()).append(' ').append(((Float)value).floatValue()).append(" Tf ");
                            if (dao[2] != null) {
                                cb.setColorFill((Color)dao[2]);
                            }
                            PdfString s = new PdfString(cb.toString());
                            ((PdfDictionary)item.merged.get(k)).put(PdfName.DA, s);
                            ((PdfDictionary)item.widgets.get(k)).put(PdfName.DA, s);
                            this.markUsed((PdfDictionary)item.widgets.get(k));
                        }
                    }
                    ++k;
                }
            } else if (name.equalsIgnoreCase("bgcolor") || name.equalsIgnoreCase("bordercolor")) {
                PdfName dname = name.equalsIgnoreCase("bgcolor") ? PdfName.BG : PdfName.BC;
                int k = 0;
                while (k < item.merged.size()) {
                    if (hit.isHit(k)) {
                        PdfObject obj = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(k)).get(PdfName.MK));
                        this.markUsed(obj);
                        PdfDictionary mk = (PdfDictionary)obj;
                        if (mk == null) {
                            if (value == null) {
                                return true;
                            }
                            mk = new PdfDictionary();
                            ((PdfDictionary)item.merged.get(k)).put(PdfName.MK, mk);
                            ((PdfDictionary)item.widgets.get(k)).put(PdfName.MK, mk);
                            this.markUsed((PdfDictionary)item.widgets.get(k));
                        }
                        if (value == null) {
                            mk.remove(dname);
                        } else {
                            mk.put(dname, PdfFormField.getMKColor((Color)value));
                        }
                    }
                    ++k;
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void setFields(XfdfReader xfdf) throws IOException, DocumentException {
        HashMap fd = xfdf.getFields();
        Iterator i = fd.keySet().iterator();
        while (i.hasNext()) {
            String f = (String)i.next();
            String v = xfdf.getFieldValue(f);
            if (v == null) continue;
            this.setField(f, v);
        }
    }

    public void setFields(FdfReader fdf) throws IOException, DocumentException {
        HashMap fd = fdf.getFields();
        Iterator i = fd.keySet().iterator();
        while (i.hasNext()) {
            String f = (String)i.next();
            String v = fdf.getFieldValue(f);
            if (v == null) continue;
            this.setField(f, v);
        }
    }

    public void setGenerateAppearances(boolean generateAppearances) {
        this.generateAppearances = generateAppearances;
        PdfDictionary top = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (generateAppearances) {
            top.remove(PdfName.NEEDAPPEARANCES);
        } else {
            top.put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
        }
    }

    public boolean setListOption(String fieldName, String[] exportValues, String[] displayValues) {
        int k;
        if (exportValues == null && displayValues == null) {
            return false;
        }
        if (exportValues != null && displayValues != null && exportValues.length != displayValues.length) {
            throw new IllegalArgumentException("The export and the display array must have the same size.");
        }
        int ftype = this.getFieldType(fieldName);
        if (ftype != 6 && ftype != 5) {
            return false;
        }
        Item fd = (Item)this.fields.get(fieldName);
        String[] sing = null;
        if (exportValues == null && displayValues != null) {
            sing = displayValues;
        } else if (exportValues != null && displayValues == null) {
            sing = exportValues;
        }
        PdfArray opt = new PdfArray();
        if (sing != null) {
            k = 0;
            while (k < sing.length) {
                opt.add(new PdfString(sing[k], "UnicodeBig"));
                ++k;
            }
        } else {
            k = 0;
            while (k < exportValues.length) {
                PdfArray a = new PdfArray();
                a.add(new PdfString(exportValues[k], "UnicodeBig"));
                a.add(new PdfString(displayValues[k], "UnicodeBig"));
                opt.add(a);
                ++k;
            }
        }
        ((PdfDictionary)fd.values.get(0)).put(PdfName.OPT, opt);
        int j = 0;
        while (j < fd.merged.size()) {
            ((PdfDictionary)fd.merged.get(j)).put(PdfName.OPT, opt);
            ++j;
        }
        return true;
    }

    public void setSubstitutionFonts(ArrayList substitutionFonts) {
        this.substitutionFonts = substitutionFonts;
    }

    public boolean signatureCoversWholeDocument(String name) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(name)) {
            return false;
        }
        return ((int[])this.sigNames.get(name))[0] == this.reader.getFileLength();
    }

    private static Object[] splitDAelements(String da) {
        try {
            PRTokeniser tk = new PRTokeniser(PdfEncodings.convertToBytes(da, null));
            ArrayList<String> stack = new ArrayList<String>();
            Object[] ret = new Object[3];
            while (tk.nextToken()) {
                if (tk.getTokenType() == 4) continue;
                if (tk.getTokenType() == 10) {
                    String operator = tk.getStringValue();
                    if (operator.equals("Tf")) {
                        if (stack.size() >= 2) {
                            ret[0] = stack.get(stack.size() - 2);
                            ret[1] = new Float((String)stack.get(stack.size() - 1));
                        }
                    } else if (operator.equals("g")) {
                        float gray;
                        if (stack.size() >= 1 && (gray = new Float((String)stack.get(stack.size() - 1)).floatValue()) != 0.0f) {
                            ret[2] = new GrayColor(gray);
                        }
                    } else if (operator.equals("rg")) {
                        if (stack.size() >= 3) {
                            float red = new Float((String)stack.get(stack.size() - 3)).floatValue();
                            float green = new Float((String)stack.get(stack.size() - 2)).floatValue();
                            float blue = new Float((String)stack.get(stack.size() - 1)).floatValue();
                            ret[2] = new Color(red, green, blue);
                        }
                    } else if (operator.equals("k") && stack.size() >= 4) {
                        float cyan = new Float((String)stack.get(stack.size() - 4)).floatValue();
                        float magenta = new Float((String)stack.get(stack.size() - 3)).floatValue();
                        float yellow = new Float((String)stack.get(stack.size() - 2)).floatValue();
                        float black = new Float((String)stack.get(stack.size() - 1)).floatValue();
                        ret[2] = new CMYKColor(cyan, magenta, yellow, black);
                    }
                    stack.clear();
                    continue;
                }
                stack.add(tk.getStringValue());
            }
            return ret;
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    /*
     * Loose catch block
     */
    private void updateByteRange(PdfPKCS7 pkcs7, PdfDictionary v) {
        block9: {
            PdfArray b = (PdfArray)PdfReader.getPdfObject(v.get(PdfName.BYTERANGE));
            RandomAccessFileOrArray rf = this.reader.getSafeFile();
            rf.reOpen();
            byte[] buf = new byte[8192];
            ArrayList ar = b.getArrayList();
            int k = 0;
            while (k < ar.size()) {
                int start = ((PdfNumber)ar.get(k)).intValue();
                int length = ((PdfNumber)ar.get(++k)).intValue();
                rf.seek(start);
                while (length > 0) {
                    int rd = rf.read(buf, 0, Math.min(length, buf.length));
                    if (rd <= 0) break;
                    length -= rd;
                    pkcs7.update(buf, 0, rd);
                }
                ++k;
            }
            Object var12_12 = null;
            try {
                rf.close();
            }
            catch (Exception e) {
            }
            break block9;
            {
                catch (Exception e) {
                    throw new ExceptionConverter(e);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    rf.close();
                }
                catch (Exception e) {
                }
                throw throwable;
            }
        }
    }

    public PdfPKCS7 verifySignature(String name, String provider) {
        PdfDictionary v = this.getSignatureDictionary(name);
        if (v == null) {
            return null;
        }
        try {
            PdfName sub = (PdfName)PdfReader.getPdfObject(v.get(PdfName.SUBFILTER));
            PdfString contents = (PdfString)PdfReader.getPdfObject(v.get(PdfName.CONTENTS));
            PdfPKCS7 pk = null;
            if (sub.equals(PdfName.ADBE_X509_RSA_SHA1)) {
                PdfString cert = (PdfString)PdfReader.getPdfObject(v.get(PdfName.CERT));
                pk = new PdfPKCS7(contents.getOriginalBytes(), cert.getBytes(), provider);
            } else {
                pk = new PdfPKCS7(contents.getOriginalBytes(), provider);
            }
            this.updateByteRange(pk, v);
            PdfString str = (PdfString)PdfReader.getPdfObject(v.get(PdfName.M));
            if (str != null) {
                pk.setSignDate(PdfDate.decode(str.toString()));
            }
            if ((str = (PdfString)PdfReader.getPdfObject(v.get(PdfName.NAME))) != null) {
                pk.setSignName(str.toUnicodeString());
            }
            if ((str = (PdfString)PdfReader.getPdfObject(v.get(PdfName.REASON))) != null) {
                pk.setReason(str.toUnicodeString());
            }
            if ((str = (PdfString)PdfReader.getPdfObject(v.get(PdfName.LOCATION))) != null) {
                pk.setLocation(str.toUnicodeString());
            }
            return pk;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public PdfPKCS7 verifySignature(String name) {
        return this.verifySignature(name, null);
    }

    private static class SorterComparator
    implements Comparator {
        private SorterComparator() {
        }

        public int compare(Object o1, Object o2) {
            int n1 = ((int[])((Object[])o1)[1])[0];
            int n2 = ((int[])((Object[])o2)[1])[0];
            return n1 - n2;
        }
    }

    private static class RevisionStream
    extends InputStream {
        private byte[] b = new byte[1];
        private boolean closed;
        private int length;
        private RandomAccessFileOrArray raf;
        private int rangePosition = 0;

        private RevisionStream(RandomAccessFileOrArray raf, int length) {
            this.raf = raf;
            this.length = length;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.raf.close();
                this.closed = true;
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.rangePosition >= this.length) {
                this.close();
                return -1;
            }
            int elen = Math.min(len, this.length - this.rangePosition);
            this.raf.readFully(b, off, elen);
            this.rangePosition += elen;
            return elen;
        }

        public int read() throws IOException {
            int n = this.read(this.b);
            if (n != 1) {
                return -1;
            }
            return this.b[0] & 0xFF;
        }
    }

    private static class InstHit {
        IntHashtable hits;

        public InstHit(int[] inst) {
            if (inst == null) {
                return;
            }
            this.hits = new IntHashtable();
            int k = 0;
            while (k < inst.length) {
                this.hits.put(inst[k], 1);
                ++k;
            }
        }

        public boolean isHit(int n) {
            if (this.hits == null) {
                return true;
            }
            return this.hits.containsKey(n);
        }
    }

    public static class Item {
        public ArrayList merged;
        public ArrayList page;
        public ArrayList tabOrder;
        public ArrayList values = new ArrayList();
        public ArrayList widget_refs;
        public ArrayList widgets = new ArrayList();

        public Item() {
            this.widget_refs = new ArrayList();
            this.merged = new ArrayList();
            this.page = new ArrayList();
            this.tabOrder = new ArrayList();
        }
    }
}

