/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.pdf.PdfEncodings;
import com.lowagie2.text.pdf.fonts.FontsResourceAnchor;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;

public class GlyphList {
    private static HashMap names2unicode;
    private static HashMap unicode2names;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        int size;
        unicode2names = new HashMap();
        names2unicode = new HashMap();
        InputStream is = null;
        is = BaseFont.getResourceStream("com/lowagie/text/pdf/fonts/glyphlist.txt", new FontsResourceAnchor().getClass().getClassLoader());
        if (is == null) {
            String msg = "glyphlist.txt not found as resource. (It must exist as resource in the package com.lowagie2.text.pdf.fonts)";
            System.err.println(msg);
        }
        byte[] buf = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((size = is.read(buf)) >= 0) {
            out.write(buf, 0, size);
        }
        is.close();
        is = null;
        String s = PdfEncodings.convertToString(out.toByteArray(), null);
        StringTokenizer tk = new StringTokenizer(s, "\r\n");
        while (tk.hasMoreTokens()) {
            String line = tk.nextToken();
            if (line.startsWith("#")) continue;
            StringTokenizer t2 = new StringTokenizer(line, " ;\r\n\t\f");
            String name = null;
            String hex = null;
            if (!t2.hasMoreTokens()) continue;
            name = t2.nextToken();
            if (!t2.hasMoreTokens()) continue;
            hex = t2.nextToken();
            Integer num = Integer.valueOf(hex, 16);
            unicode2names.put(num, name);
            names2unicode.put(name, new int[]{num});
        }
        unicode2names.put(new Integer(32), "space");
        Object var11_12 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (Exception e2) {
        }
        return;
        {
            catch (Exception e) {
                System.err.println("glyphlist.txt loading error: " + e.getMessage());
                Object var11_13 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (Exception e2) {
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (Exception e2) {
            }
            throw throwable;
        }
    }

    public static int[] nameToUnicode(String name) {
        return (int[])names2unicode.get(name);
    }

    public static String unicodeToName(int num) {
        return (String)unicode2names.get(new Integer(num));
    }
}

