/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.BadPdfFormatException;
import com.lowagie2.text.pdf.PdfObject;

public class PdfBoolean
extends PdfObject {
    public static final String FALSE = "false";
    public static final PdfBoolean PDFFALSE;
    public static final PdfBoolean PDFTRUE;
    public static final String TRUE = "true";
    private boolean value;

    static {
        PDFTRUE = new PdfBoolean(true);
        PDFFALSE = new PdfBoolean(false);
    }

    public PdfBoolean(String value) throws BadPdfFormatException {
        super(1, value);
        if (value.equals(TRUE)) {
            this.value = true;
        } else if (value.equals(FALSE)) {
            this.value = false;
        } else {
            throw new BadPdfFormatException("The value has to be 'true' of 'false', instead of '" + value + "'.");
        }
    }

    public PdfBoolean(boolean value) {
        super(1);
        if (value) {
            this.setContent(TRUE);
        } else {
            this.setContent(FALSE);
        }
        this.value = value;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

