/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.Document;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.pdf.BadPdfFormatException;
import com.lowagie2.text.pdf.PRIndirectReference;
import com.lowagie2.text.pdf.PRStream;
import com.lowagie2.text.pdf.PdfAnnotation;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfBoolean;
import com.lowagie2.text.pdf.PdfContents;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfDocument;
import com.lowagie2.text.pdf.PdfException;
import com.lowagie2.text.pdf.PdfImage;
import com.lowagie2.text.pdf.PdfImportedPage;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfLiteral;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfOutline;
import com.lowagie2.text.pdf.PdfPage;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfReaderInstance;
import com.lowagie2.text.pdf.PdfStream;
import com.lowagie2.text.pdf.PdfWriter;
import com.lowagie2.text.pdf.SimpleBookmark;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PdfCopy
extends PdfWriter {
    protected PdfIndirectReference acroForm;
    protected int currentObjectNum = 1;
    protected HashMap indirectMap;
    protected HashMap indirects;
    protected List newBookmarks;
    protected ArrayList pageNumbersToRefs = new ArrayList();
    protected PdfReader reader;
    protected PdfIndirectReference topPageParent;

    public PdfCopy(Document document, OutputStream os) throws DocumentException {
        super(new PdfDocument(), os);
        document.addDocListener(this.pdf);
        this.pdf.addWriter(this);
        this.indirectMap = new HashMap();
    }

    PdfIndirectReference add(PdfPage page, PdfContents contents) throws PdfException {
        return null;
    }

    public PdfIndirectReference add(PdfOutline outline) {
        return null;
    }

    PdfIndirectReference add(PdfImage pdfImage, PdfIndirectReference fixedRef) throws PdfException {
        return null;
    }

    public void addAnnotation(PdfAnnotation annot) {
    }

    public void addPage(PdfImportedPage iPage) throws IOException, BadPdfFormatException {
        PdfIndirectReference pageRef;
        int pageNum = this.setFromIPage(iPage);
        PdfDictionary thePage = this.reader.getPageN(pageNum);
        PRIndirectReference origRef = this.reader.getPageOrigRef(pageNum);
        this.reader.releasePage(pageNum);
        RefKey key = new RefKey(origRef);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            pageRef = iRef.getRef();
        } else {
            pageRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(pageRef);
            this.indirects.put(key, iRef);
        }
        this.pageReferences.add(pageRef);
        ++this.currentPageNumber;
        if (!iRef.getCopied()) {
            iRef.setCopied();
            PdfDictionary newPage = this.copyDictionary(thePage);
            newPage.put(PdfName.PARENT, this.topPageParent);
            this.addToBody((PdfObject)newPage, pageRef);
        }
        this.root.addPage(pageRef);
        this.pageNumbersToRefs.add(pageRef);
    }

    public synchronized void close() {
        if (this.open) {
            PdfReaderInstance ri = this.currentPdfReaderInstance;
            this.pdf.close();
            super.close();
            if (ri != null) {
                try {
                    ri.getReader().close();
                    ri.getReaderFile().close();
                }
                catch (IOException ioe) {
                }
            }
        }
    }

    public void copyAcroForm(PdfReader reader) throws IOException, BadPdfFormatException {
        PdfIndirectReference myRef;
        this.setFromReader(reader);
        PdfDictionary catalog = reader.getCatalog();
        PRIndirectReference hisRef = null;
        PdfObject o = catalog.get(PdfName.ACROFORM);
        if (o != null && o.type() == 10) {
            hisRef = (PRIndirectReference)o;
        }
        if (hisRef == null) {
            return;
        }
        RefKey key = new RefKey(hisRef);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            this.acroForm = myRef = iRef.getRef();
        } else {
            this.acroForm = myRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(myRef);
            this.indirects.put(key, iRef);
        }
        if (!iRef.getCopied()) {
            iRef.setCopied();
            PdfDictionary theForm = this.copyDictionary((PdfDictionary)PdfReader.getPdfObject(hisRef));
            this.addToBody((PdfObject)theForm, myRef);
        }
    }

    protected PdfArray copyArray(PdfArray in) throws IOException, BadPdfFormatException {
        PdfArray out = new PdfArray();
        Iterator i = in.getArrayList().iterator();
        while (i.hasNext()) {
            PdfObject value = (PdfObject)i.next();
            out.add(this.copyObject(value));
        }
        return out;
    }

    protected PdfDictionary copyDictionary(PdfDictionary in) throws IOException, BadPdfFormatException {
        PdfDictionary out = new PdfDictionary();
        PdfName type = (PdfName)in.get(PdfName.TYPE);
        Iterator it = in.getKeys().iterator();
        while (it.hasNext()) {
            PdfName key = (PdfName)it.next();
            PdfObject value = in.get(key);
            if (type != null && PdfName.PAGE.equals(type)) {
                if (key.equals(PdfName.PARENT)) {
                    out.put(PdfName.PARENT, this.topPageParent);
                    continue;
                }
                if (key.equals(PdfName.B)) continue;
                out.put(key, this.copyObject(value));
                continue;
            }
            out.put(key, this.copyObject(value));
        }
        return out;
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PdfIndirectReference theRef;
        RefKey key = new RefKey(in);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        iRef.setCopied();
        PdfObject obj = this.copyObject(PdfReader.getPdfObjectRelease(in));
        this.addToBody(obj, theRef);
        return theRef;
    }

    protected PdfObject copyObject(PdfObject in) throws IOException, BadPdfFormatException {
        switch (in.type) {
            case 6: {
                return this.copyDictionary((PdfDictionary)in);
            }
            case 10: {
                return this.copyIndirect((PRIndirectReference)in);
            }
            case 5: {
                return this.copyArray((PdfArray)in);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return in;
            }
            case 7: {
                return this.copyStream((PRStream)in);
            }
        }
        if (in.type < 0) {
            String lit = ((PdfLiteral)in).toString();
            if (lit.equals("true") || lit.equals("false")) {
                return new PdfBoolean(lit);
            }
            return new PdfLiteral(lit);
        }
        System.out.println("CANNOT COPY type " + in.type);
        return null;
    }

    protected PdfStream copyStream(PRStream in) throws IOException, BadPdfFormatException {
        PRStream out = new PRStream(in, null);
        Iterator it = in.getKeys().iterator();
        while (it.hasNext()) {
            PdfName key = (PdfName)it.next();
            PdfObject value = in.get(key);
            out.put(key, this.copyObject(value));
        }
        return out;
    }

    public void freeReader(PdfReader reader) throws IOException {
        this.indirectMap.remove(reader);
        if (this.currentPdfReaderInstance != null && this.currentPdfReaderInstance.getReader() == reader) {
            try {
                this.currentPdfReaderInstance.getReader().close();
                this.currentPdfReaderInstance.getReaderFile().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.currentPdfReaderInstance = null;
        }
    }

    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) {
        try {
            PdfDocument.PdfCatalog theCat = ((PdfDocument)this.document).getCatalog(rootObj);
            if (this.acroForm != null) {
                theCat.put(PdfName.ACROFORM, this.acroForm);
            }
            if (this.newBookmarks == null || this.newBookmarks.size() == 0) {
                return theCat;
            }
            PdfDictionary top = new PdfDictionary();
            PdfIndirectReference topRef = this.getPdfIndirectReference();
            Object[] kids = SimpleBookmark.iterateOutlines(this, topRef, this.newBookmarks, false);
            top.put(PdfName.FIRST, (PdfIndirectReference)kids[0]);
            top.put(PdfName.LAST, (PdfIndirectReference)kids[1]);
            top.put(PdfName.COUNT, new PdfNumber((Integer)kids[2]));
            this.addToBody((PdfObject)top, topRef);
            theCat.put(PdfName.OUTLINES, topRef);
            return theCat;
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        if (this.currentPdfReaderInstance != null) {
            if (this.currentPdfReaderInstance.getReader() != reader) {
                try {
                    this.currentPdfReaderInstance.getReader().close();
                    this.currentPdfReaderInstance.getReaderFile().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this.currentPdfReaderInstance = reader.getPdfReaderInstance(this);
            }
        } else {
            this.currentPdfReaderInstance = reader.getPdfReaderInstance(this);
        }
        return this.currentPdfReaderInstance.getImportedPage(pageNumber);
    }

    public PdfIndirectReference getPageReference(int page) {
        if (page < 0 || page > this.pageNumbersToRefs.size()) {
            throw new IllegalArgumentException("Invalid page number " + page);
        }
        return (PdfIndirectReference)this.pageNumbersToRefs.get(page - 1);
    }

    public void open() {
        super.open();
        this.topPageParent = this.getPdfIndirectReference();
        this.root.setLinearMode(this.topPageParent);
    }

    protected int setFromIPage(PdfImportedPage iPage) {
        int pageNum = iPage.getPageNumber();
        PdfReaderInstance inst = this.currentPdfReaderInstance = iPage.getPdfReaderInstance();
        this.reader = inst.getReader();
        this.setFromReader(this.reader);
        return pageNum;
    }

    protected void setFromReader(PdfReader reader) {
        this.reader = reader;
        this.indirects = (HashMap)this.indirectMap.get(reader);
        if (this.indirects == null) {
            this.indirects = new HashMap();
            this.indirectMap.put(reader, this.indirects);
            PdfDictionary catalog = reader.getCatalog();
            PRIndirectReference ref = (PRIndirectReference)catalog.get(PdfName.PAGES);
            this.indirects.put(new RefKey(ref), new IndirectReferences(this.topPageParent));
            ref = null;
            PdfObject o = catalog.get(PdfName.ACROFORM);
            if (o == null || o.type() != 10) {
                return;
            }
            ref = (PRIndirectReference)o;
            if (this.acroForm == null) {
                this.acroForm = this.body.getPdfIndirectReference();
            }
            this.indirects.put(new RefKey(ref), new IndirectReferences(this.acroForm));
        }
    }

    public void setOutlines(List outlines) {
        this.newBookmarks = outlines;
    }

    protected static class RefKey {
        int gen;
        int num;

        RefKey(PRIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        RefKey(PdfIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        RefKey(int num, int gen) {
            this.num = num;
            this.gen = gen;
        }

        public boolean equals(Object o) {
            RefKey other = (RefKey)o;
            return this.gen == other.gen && this.num == other.num;
        }

        public int hashCode() {
            return (this.gen << 16) + this.num;
        }

        public String toString() {
            return "" + this.num + " " + this.gen;
        }
    }

    static class IndirectReferences {
        boolean hasCopied;
        PdfIndirectReference theRef;

        IndirectReferences(PdfIndirectReference ref) {
            this.theRef = ref;
            this.hasCopied = false;
        }

        boolean getCopied() {
            return this.hasCopied;
        }

        PdfIndirectReference getRef() {
            return this.theRef;
        }

        void setCopied() {
            this.hasCopied = true;
        }
    }
}

