/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Image;
import com.lowagie2.text.pdf.BaseFont;

class PdfFont
implements Comparable {
    private BaseFont font;
    protected float hScale = 1.0f;
    protected Image image;
    private float size;

    PdfFont(BaseFont bf, float size) {
        this.size = size;
        this.font = bf;
    }

    public int compareTo(Object object) {
        if (this.image != null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        try {
            PdfFont pdfFont = (PdfFont)object;
            if (this.font != pdfFont.font) {
                return 1;
            }
            if (this.size() != pdfFont.size()) {
                return 2;
            }
            return 0;
        }
        catch (ClassCastException cce) {
            return -2;
        }
    }

    static PdfFont getDefaultFont() {
        try {
            BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", false);
            return new PdfFont(bf, 12.0f);
        }
        catch (Exception ee) {
            throw new ExceptionConverter(ee);
        }
    }

    BaseFont getFont() {
        return this.font;
    }

    void setHorizontalScaling(float hScale) {
        this.hScale = hScale;
    }

    void setImage(Image image) {
        this.image = image;
    }

    float size() {
        if (this.image == null) {
            return this.size;
        }
        return this.image.scaledHeight();
    }

    float width(String s) {
        if (this.image == null) {
            return this.font.getWidthPoint(s, this.size) * this.hScale;
        }
        return this.image.scaledWidth();
    }

    float width(char character) {
        if (this.image == null) {
            return this.font.getWidthPoint(character, this.size) * this.hScale;
        }
        return this.image.scaledWidth();
    }

    float width() {
        return this.width(' ');
    }
}

