/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.ByteBuffer;
import com.lowagie2.text.pdf.PdfObject;

public class PdfNumber
extends PdfObject {
    private double value;

    public PdfNumber(float value) {
        this((double)value);
    }

    public PdfNumber(double value) {
        super(2);
        this.value = value;
        this.setContent(ByteBuffer.formatDouble(value));
    }

    public PdfNumber(int value) {
        super(2);
        this.value = value;
        this.setContent(String.valueOf(value));
    }

    public PdfNumber(String content) {
        super(2);
        try {
            this.value = Double.valueOf(content.trim());
            this.setContent(content);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(content + " is not a valid number - " + nfe.toString());
        }
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public void increment() {
        this.value += 1.0;
        this.setContent(ByteBuffer.formatDouble(this.value));
    }

    public int intValue() {
        return (int)this.value;
    }
}

