/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNumberTree {
    private static final int leafSize = 64;

    private static void iterateItems(PdfDictionary dic, HashMap items) {
        block3: {
            PdfArray nn;
            block2: {
                nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.NUMS));
                if (nn == null) break block2;
                ArrayList arr = nn.getArrayList();
                int k = 0;
                while (k < arr.size()) {
                    PdfNumber s = (PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)arr.get(k++));
                    items.put(new Integer(s.intValue()), arr.get(k));
                    ++k;
                }
                break block3;
            }
            nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.KIDS));
            if (nn == null) break block3;
            ArrayList arr = nn.getArrayList();
            int k = 0;
            while (k < arr.size()) {
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)arr.get(k));
                PdfNumberTree.iterateItems(kid, items);
                ++k;
            }
        }
    }

    public static HashMap readTree(PdfDictionary dic) {
        HashMap items = new HashMap();
        if (dic != null) {
            PdfNumberTree.iterateItems(dic, items);
        }
        return items;
    }

    public static PdfDictionary writeTree(HashMap items, PdfWriter writer) throws IOException {
        if (items.size() == 0) {
            return null;
        }
        Object[] numbers = new Integer[items.size()];
        numbers = items.keySet().toArray(numbers);
        Arrays.sort(numbers);
        if (numbers.length <= 64) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            int k = 0;
            while (k < numbers.length) {
                ar.add(new PdfNumber((Integer)numbers[k]));
                ar.add((PdfObject)items.get(numbers[k]));
                ++k;
            }
            dic.put(PdfName.NUMS, ar);
            return dic;
        }
        int skip = 64;
        PdfIndirectReference[] kids = new PdfIndirectReference[(numbers.length + 64 - 1) / 64];
        int k = 0;
        while (k < kids.length) {
            int offset = k * 64;
            int end = Math.min(offset + 64, numbers.length);
            PdfDictionary dic = new PdfDictionary();
            PdfArray arr = new PdfArray();
            arr.add(new PdfNumber((Integer)numbers[offset]));
            arr.add(new PdfNumber((Integer)numbers[end - 1]));
            dic.put(PdfName.LIMITS, arr);
            arr = new PdfArray();
            while (offset < end) {
                arr.add(new PdfNumber((Integer)numbers[offset]));
                arr.add((PdfObject)items.get(numbers[offset]));
                ++offset;
            }
            dic.put(PdfName.NUMS, arr);
            kids[k] = writer.addToBody(dic).getIndirectReference();
            ++k;
        }
        int top = kids.length;
        while (true) {
            if (top <= 64) {
                PdfArray arr = new PdfArray();
                int k2 = 0;
                while (k2 < top) {
                    arr.add(kids[k2]);
                    ++k2;
                }
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.KIDS, arr);
                return dic;
            }
            int tt = (numbers.length + (skip *= 64) - 1) / skip;
            int k3 = 0;
            while (k3 < tt) {
                int offset = k3 * 64;
                int end = Math.min(offset + 64, top);
                PdfDictionary dic = new PdfDictionary();
                PdfArray arr = new PdfArray();
                arr.add(new PdfNumber((Integer)numbers[k3 * skip]));
                arr.add(new PdfNumber((Integer)numbers[Math.min((k3 + 1) * skip, numbers.length) - 1]));
                dic.put(PdfName.LIMITS, arr);
                arr = new PdfArray();
                while (offset < end) {
                    arr.add(kids[offset]);
                    ++offset;
                }
                dic.put(PdfName.KIDS, arr);
                kids[k3] = writer.addToBody(dic).getIndirectReference();
                ++k3;
            }
            top = tt;
        }
    }
}

