/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfRectangle;
import java.util.HashMap;

public class PdfPage
extends PdfDictionary {
    public static final PdfNumber INVERTEDPORTRAIT;
    public static final PdfNumber LANDSCAPE;
    public static final PdfNumber PORTRAIT;
    public static final PdfNumber SEASCAPE;
    private static final PdfName[] boxNames;
    private static final String[] boxStrings;
    PdfRectangle mediaBox;

    static {
        boxStrings = new String[]{"crop", "trim", "art", "bleed"};
        boxNames = new PdfName[]{PdfName.CROPBOX, PdfName.TRIMBOX, PdfName.ARTBOX, PdfName.BLEEDBOX};
        PORTRAIT = new PdfNumber(0);
        LANDSCAPE = new PdfNumber(90);
        INVERTEDPORTRAIT = new PdfNumber(180);
        SEASCAPE = new PdfNumber(270);
    }

    PdfPage(PdfRectangle mediaBox, HashMap boxSize, PdfDictionary resources) {
        this(mediaBox, boxSize, resources, 0);
    }

    PdfPage(PdfRectangle mediaBox, HashMap boxSize, PdfDictionary resources, int rotate) {
        super(PdfDictionary.PAGE);
        this.mediaBox = mediaBox;
        this.put(PdfName.MEDIABOX, mediaBox);
        this.put(PdfName.RESOURCES, resources);
        if (rotate != 0) {
            this.put(PdfName.ROTATE, new PdfNumber(rotate));
        }
        int k = 0;
        while (k < boxStrings.length) {
            PdfObject rect = (PdfObject)boxSize.get(boxStrings[k]);
            if (rect != null) {
                this.put(boxNames[k], rect);
            }
            ++k;
        }
    }

    void add(PdfIndirectReference contents) {
        this.put(PdfName.CONTENTS, contents);
    }

    PdfRectangle getMediaBox() {
        return this.mediaBox;
    }

    public boolean isParent() {
        return false;
    }

    PdfRectangle rotateMediaBox() {
        this.mediaBox = this.mediaBox.rotate();
        this.put(PdfName.MEDIABOX, this.mediaBox);
        return this.mediaBox;
    }
}

