/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Font;
import com.lowagie2.text.Image;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.AcroFields;
import com.lowagie2.text.pdf.ByteBuffer;
import com.lowagie2.text.pdf.ColumnText;
import com.lowagie2.text.pdf.PdfAnnotation;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfDate;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfEncodings;
import com.lowagie2.text.pdf.PdfFormField;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfLiteral;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfPKCS7;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfSigGenericPKCS;
import com.lowagie2.text.pdf.PdfStamper;
import com.lowagie2.text.pdf.PdfStamperImp;
import com.lowagie2.text.pdf.PdfString;
import com.lowagie2.text.pdf.PdfTemplate;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PdfSignatureAppearance {
    public static final PdfName SELF_SIGNED = PdfName.ADOBE_PPKLITE;
    public static final int SignatureRenderDescription = 0;
    public static final int SignatureRenderGraphicAndDescription = 2;
    public static final int SignatureRenderNameAndDescription = 1;
    public static final PdfName VERISIGN_SIGNED = PdfName.VERISIGN_PPKVS;
    public static final PdfName WINCER_SIGNED = PdfName.ADOBE_PPKMS;
    private boolean acro6Layers;
    private PdfTemplate[] app = new PdfTemplate[5];
    private byte[] bout;
    private int boutLen;
    private Certificate[] certChain;
    private boolean certified;
    private String contact;
    private CRL[] crlList;
    private PdfDictionary cryptoDictionary;
    private String digestEncryptionAlgorithm;
    private HashMap exclusionLocations;
    private byte[] externalDigest;
    private byte[] externalRSAdata;
    private String fieldName;
    private PdfName filter;
    private PdfTemplate frm;
    private Image image;
    private float imageScale;
    private Font layer2Font;
    private String layer2Text;
    private String layer4Text;
    private String location;
    private static final float margin = 2.0f;
    private boolean newField;
    private OutputStream originalout;
    private int page = 1;
    private Rectangle pageRect;
    private boolean preClosed = false;
    private PrivateKey privKey;
    private String provider;
    public static final String questionMark = "% DSUnknown\nq\n1 G\n1 g\n0.1 0 0 0.1 9 0 cm\n0 J 0 j 4 M []0 d\n1 i \n0 g\n313 292 m\n313 404 325 453 432 529 c\n478 561 504 597 504 645 c\n504 736 440 760 391 760 c\n286 760 271 681 265 626 c\n265 625 l\n100 625 l\n100 828 253 898 381 898 c\n451 898 679 878 679 650 c\n679 555 628 499 538 435 c\n488 399 467 376 467 292 c\n313 292 l\nh\n308 214 170 -164 re\nf\n0.44 G\n1.2 w\n1 1 0.4 rg\n287 318 m\n287 430 299 479 406 555 c\n451 587 478 623 478 671 c\n478 762 414 786 365 786 c\n260 786 245 707 239 652 c\n239 651 l\n74 651 l\n74 854 227 924 355 924 c\n425 924 653 904 653 676 c\n653 581 602 525 512 461 c\n462 425 441 402 441 318 c\n287 318 l\nh\n282 240 170 -164 re\nB\nQ\n";
    private RandomAccessFile raf;
    private int[] range;
    private int rangePosition = 0;
    private String reason;
    private Rectangle rect;
    private int render = 0;
    private int runDirection = 1;
    private PdfSigGenericPKCS sigStandard;
    private Calendar signDate;
    private SignatureEvent signatureEvent;
    private Image signatureGraphic = null;
    private ByteBuffer sigout;
    private PdfStamper stamper;
    private File tempFile;
    private static final float topSection = 0.3f;
    private PdfStamperImp writer;

    PdfSignatureAppearance(PdfStamperImp writer) {
        this.writer = writer;
        this.signDate = new GregorianCalendar();
        this.fieldName = this.getNewSigName();
    }

    private void addDocMDP(PdfDictionary crypto) {
        PdfDictionary reference = new PdfDictionary();
        PdfDictionary transformParams = new PdfDictionary();
        transformParams.put(PdfName.P, new PdfNumber(1));
        transformParams.put(PdfName.V, new PdfName("1.2"));
        transformParams.put(PdfName.TYPE, new PdfName("TransformParams"));
        reference.put(new PdfName("TransformMethod"), new PdfName("DocMDP"));
        reference.put(PdfName.TYPE, new PdfName("SigRef"));
        reference.put(new PdfName("TransformParams"), transformParams);
        PdfArray types = new PdfArray();
        types.add(reference);
        crypto.put(new PdfName("Reference"), types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(PdfDictionary update) throws IOException, DocumentException {
        try {
            if (!this.preClosed) {
                throw new DocumentException("preClose() must be called first.");
            }
            ByteBuffer bf = new ByteBuffer();
            Iterator it = update.getKeys().iterator();
            while (it.hasNext()) {
                PdfName key = (PdfName)it.next();
                PdfObject obj = update.get(key);
                PdfLiteral lit = (PdfLiteral)this.exclusionLocations.get(key);
                if (lit == null) {
                    throw new IllegalArgumentException("The key " + key.toString() + " didn't reserve space in preClose().");
                }
                bf.reset();
                obj.toPdf(null, bf);
                if (bf.size() > lit.getPosLength()) {
                    throw new IllegalArgumentException("The key " + key.toString() + " is too big. Is " + bf.size() + ", reserved " + lit.getPosLength());
                }
                if (this.tempFile == null) {
                    System.arraycopy(bf.getBuffer(), 0, this.bout, lit.getPosition(), bf.size());
                    continue;
                }
                this.raf.seek(lit.getPosition());
                this.raf.write(bf.getBuffer(), 0, bf.size());
            }
            if (update.size() != this.exclusionLocations.size()) {
                throw new IllegalArgumentException("The update dictionary has less keys than required.");
            }
            if (this.tempFile == null) {
                this.originalout.write(this.bout, 0, this.boutLen);
            } else if (this.originalout != null) {
                this.raf.seek(0L);
                int length = (int)this.raf.length();
                byte[] buf = new byte[8192];
                while (length > 0) {
                    int r = this.raf.read(buf, 0, Math.min(buf.length, length));
                    if (r < 0) {
                        throw new EOFException("Unexpected EOF");
                    }
                    this.originalout.write(buf, 0, r);
                    length -= r;
                }
            }
        }
        finally {
            if (this.tempFile != null) {
                try {
                    this.raf.close();
                }
                catch (Exception ee) {}
                if (this.originalout != null) {
                    try {
                        this.tempFile.delete();
                    }
                    catch (Exception ee) {
                    }
                }
            }
            if (this.originalout != null) {
                try {
                    this.originalout.close();
                }
                catch (Exception e) {
                }
            }
        }
    }

    public static float fitText(Font font, String text, Rectangle rect, float maxFontSize, int runDirection) {
        try {
            ColumnText ct = null;
            int status = 0;
            if (maxFontSize <= 0.0f) {
                int cr = 0;
                int lf = 0;
                char[] t = text.toCharArray();
                int k = 0;
                while (k < t.length) {
                    if (t[k] == '\n') {
                        ++lf;
                    } else if (t[k] == '\r') {
                        ++cr;
                    }
                    ++k;
                }
                int minLines = Math.max(cr, lf) + 1;
                maxFontSize = Math.abs(rect.height()) / (float)minLines - 0.001f;
            }
            font.setSize(maxFontSize);
            Phrase ph = new Phrase(text, font);
            ct = new ColumnText(null);
            ct.setSimpleColumn(ph, rect.left(), rect.bottom(), rect.right(), rect.top(), maxFontSize, 0);
            ct.setRunDirection(runDirection);
            status = ct.go(true);
            if ((status & 1) != 0) {
                return maxFontSize;
            }
            float precision = 0.1f;
            float min = 0.0f;
            float max = maxFontSize;
            float size = maxFontSize;
            int k = 0;
            while (k < 50) {
                size = (min + max) / 2.0f;
                ct = new ColumnText(null);
                font.setSize(size);
                ct.setSimpleColumn(new Phrase(text, font), rect.left(), rect.bottom(), rect.right(), rect.top(), size, 0);
                ct.setRunDirection(runDirection);
                status = ct.go(true);
                if ((status & 1) != 0) {
                    if (max - min < size * precision) {
                        return size;
                    }
                    min = size;
                } else {
                    max = size;
                }
                ++k;
            }
            return size;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public PdfTemplate getAppearance() throws DocumentException, IOException {
        PdfTemplate t;
        if (this.app[0] == null) {
            t = this.app[0] = new PdfTemplate(this.writer);
            t.setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.writer.addDirectTemplateSimple(t, new PdfName("n0"));
            t.setLiteral("% DSBlank\n");
        }
        if (this.app[1] == null && !this.acro6Layers) {
            t = this.app[1] = new PdfTemplate(this.writer);
            t.setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.writer.addDirectTemplateSimple(t, new PdfName("n1"));
            t.setLiteral(questionMark);
        }
        if (this.app[2] == null) {
            String text;
            if (this.layer2Text == null) {
                StringBuffer buf = new StringBuffer();
                buf.append("Digitally signed by ").append(PdfPKCS7.getSubjectFields((X509Certificate)this.certChain[0]).getField("CN")).append("\n");
                SimpleDateFormat sd = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
                buf.append("Date: ").append(sd.format(this.signDate.getTime()));
                if (this.reason != null) {
                    buf.append("\n").append("Reason: ").append(this.reason);
                }
                if (this.location != null) {
                    buf.append("\n").append("Location: ").append(this.location);
                }
                text = buf.toString();
            } else {
                text = this.layer2Text;
            }
            PdfTemplate t2 = this.app[2] = new PdfTemplate(this.writer);
            t2.setBoundingBox(this.rect);
            this.writer.addDirectTemplateSimple(t2, new PdfName("n2"));
            if (this.image != null) {
                if (this.imageScale == 0.0f) {
                    t2.addImage(this.image, this.rect.width(), 0.0f, 0.0f, this.rect.height(), 0.0f, 0.0f);
                } else {
                    float usableScale = this.imageScale;
                    if (this.imageScale < 0.0f) {
                        usableScale = Math.min(this.rect.width() / this.image.width(), this.rect.height() / this.image.height());
                    }
                    float w = this.image.width() * usableScale;
                    float h = this.image.height() * usableScale;
                    float x = (this.rect.width() - w) / 2.0f;
                    float y = (this.rect.height() - h) / 2.0f;
                    t2.addImage(this.image, w, 0.0f, 0.0f, h, x, y);
                }
            }
            Font font = this.layer2Font == null ? new Font() : new Font(this.layer2Font);
            float size = font.size();
            Rectangle dataRect = null;
            Rectangle signatureRect = null;
            if (this.render == 1 || this.render == 2 && this.signatureGraphic != null) {
                signatureRect = new Rectangle(2.0f, 2.0f, this.rect.width() / 2.0f - 2.0f, this.rect.height() - 2.0f);
                dataRect = new Rectangle(this.rect.width() / 2.0f + 1.0f, 2.0f, this.rect.width() - 1.0f, this.rect.height() - 2.0f);
                if (this.rect.height() > this.rect.width()) {
                    signatureRect = new Rectangle(2.0f, this.rect.height() / 2.0f, this.rect.width() - 2.0f, this.rect.height());
                    dataRect = new Rectangle(2.0f, 2.0f, this.rect.width() - 2.0f, this.rect.height() / 2.0f - 2.0f);
                }
            } else {
                dataRect = new Rectangle(2.0f, 2.0f, this.rect.width() - 2.0f, this.rect.height() * 0.7f - 2.0f);
            }
            if (this.render == 1) {
                String signedBy = PdfPKCS7.getSubjectFields((X509Certificate)this.certChain[0]).getField("CN");
                Rectangle sr2 = new Rectangle(signatureRect.width() - 2.0f, signatureRect.height() - 2.0f);
                float signedSize = PdfSignatureAppearance.fitText(font, signedBy, sr2, -1.0f, this.runDirection);
                ColumnText ct2 = new ColumnText(t2);
                ct2.setRunDirection(this.runDirection);
                ct2.setSimpleColumn(new Phrase(signedBy, font), signatureRect.left(), signatureRect.bottom(), signatureRect.right(), signatureRect.top(), signedSize, 0);
                ct2.go();
            } else if (this.render == 2) {
                ColumnText ct2 = new ColumnText(t2);
                ct2.setRunDirection(this.runDirection);
                ct2.setSimpleColumn(signatureRect.left(), signatureRect.bottom(), signatureRect.right(), signatureRect.top(), 0.0f, 2);
                Image im = Image.getInstance(this.signatureGraphic);
                im.scaleToFit(signatureRect.width(), signatureRect.height());
                Paragraph p = new Paragraph();
                float x = 0.0f;
                float y = -im.scaledHeight() + 15.0f;
                p.add(new Chunk(im, (x += (signatureRect.width() - im.scaledWidth()) / 2.0f) + (signatureRect.width() - im.scaledWidth()) / 2.0f, y -= (signatureRect.height() - im.scaledHeight()) / 2.0f, false));
                ct2.addElement(p);
                ct2.go();
            }
            if (size <= 0.0f) {
                Rectangle sr = new Rectangle(dataRect.width(), dataRect.height());
                size = PdfSignatureAppearance.fitText(font, text, sr, 12.0f, this.runDirection);
            }
            ColumnText ct = new ColumnText(t2);
            ct.setRunDirection(this.runDirection);
            ct.setSimpleColumn(new Phrase(text, font), dataRect.left(), dataRect.bottom(), dataRect.right(), dataRect.top(), size, 0);
            ct.go();
        }
        if (this.app[3] == null && !this.acro6Layers) {
            t = this.app[3] = new PdfTemplate(this.writer);
            t.setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.writer.addDirectTemplateSimple(t, new PdfName("n3"));
            t.setLiteral("% DSBlank\n");
        }
        if (this.app[4] == null && !this.acro6Layers) {
            t = this.app[4] = new PdfTemplate(this.writer);
            t.setBoundingBox(new Rectangle(0.0f, this.rect.height() * 0.7f, this.rect.right(), this.rect.top()));
            this.writer.addDirectTemplateSimple(t, new PdfName("n4"));
            Font font = this.layer2Font == null ? new Font() : new Font(this.layer2Font);
            float size = font.size();
            String text = "Signature Not Verified";
            if (this.layer4Text != null) {
                text = this.layer4Text;
            }
            Rectangle sr = new Rectangle(this.rect.width() - 4.0f, this.rect.height() * 0.3f - 4.0f);
            size = PdfSignatureAppearance.fitText(font, text, sr, 15.0f, this.runDirection);
            ColumnText ct = new ColumnText(t);
            ct.setRunDirection(this.runDirection);
            ct.setSimpleColumn(new Phrase(text, font), 2.0f, 0.0f, this.rect.width() - 2.0f, this.rect.height() - 2.0f, size, 0);
            ct.go();
        }
        int rotation = this.writer.reader.getPageRotation(this.page);
        Rectangle rotated = new Rectangle(this.rect);
        int n = rotation;
        while (n > 0) {
            rotated = rotated.rotate();
            n -= 90;
        }
        if (this.frm == null) {
            this.frm = new PdfTemplate(this.writer);
            this.frm.setBoundingBox(rotated);
            this.writer.addDirectTemplateSimple(this.frm, new PdfName("FRM"));
            float scale = Math.min(this.rect.width(), this.rect.height()) * 0.9f;
            float x = (this.rect.width() - scale) / 2.0f;
            float y = (this.rect.height() - scale) / 2.0f;
            scale /= 100.0f;
            if (rotation == 90) {
                this.frm.concatCTM(0.0f, 1.0f, -1.0f, 0.0f, this.rect.height(), 0.0f);
            } else if (rotation == 180) {
                this.frm.concatCTM(-1.0f, 0.0f, 0.0f, -1.0f, this.rect.width(), this.rect.height());
            } else if (rotation == 270) {
                this.frm.concatCTM(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.rect.width());
            }
            this.frm.addTemplate(this.app[0], 0.0f, 0.0f);
            if (!this.acro6Layers) {
                this.frm.addTemplate(this.app[1], scale, 0.0f, 0.0f, scale, x, y);
            }
            this.frm.addTemplate(this.app[2], 0.0f, 0.0f);
            if (!this.acro6Layers) {
                this.frm.addTemplate(this.app[3], scale, 0.0f, 0.0f, scale, x, y);
                this.frm.addTemplate(this.app[4], 0.0f, 0.0f);
            }
        }
        PdfTemplate napp = new PdfTemplate(this.writer);
        napp.setBoundingBox(rotated);
        this.writer.addDirectTemplateSimple(napp, null);
        napp.addTemplate(this.frm, 0.0f, 0.0f);
        return napp;
    }

    public Certificate[] getCertChain() {
        return this.certChain;
    }

    public String getContact() {
        return this.contact;
    }

    public CRL[] getCrlList() {
        return this.crlList;
    }

    public PdfDictionary getCryptoDictionary() {
        return this.cryptoDictionary;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public PdfName getFilter() {
        return this.filter;
    }

    public Image getImage() {
        return this.image;
    }

    public float getImageScale() {
        return this.imageScale;
    }

    public PdfTemplate getLayer(int layer) {
        if (layer < 0 || layer >= this.app.length) {
            return null;
        }
        PdfTemplate t = this.app[layer];
        if (t == null) {
            t = this.app[layer] = new PdfTemplate(this.writer);
            t.setBoundingBox(this.rect);
            this.writer.addDirectTemplateSimple(t, new PdfName("n" + layer));
        }
        return t;
    }

    public Font getLayer2Font() {
        return this.layer2Font;
    }

    public String getLayer2Text() {
        return this.layer2Text;
    }

    public String getLayer4Text() {
        return this.layer4Text;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNewSigName() {
        AcroFields af = this.writer.getAcroFields();
        String name = "Signature";
        int step = 0;
        boolean found = false;
        block0: while (!found) {
            String n1 = name + ++step;
            if (af.getFieldItem(n1) != null) continue;
            n1 = n1 + ".";
            found = true;
            Iterator it = af.getFields().keySet().iterator();
            while (it.hasNext()) {
                String fn = (String)it.next();
                if (!fn.startsWith(n1)) continue;
                found = false;
                continue block0;
            }
        }
        name = name + step;
        return name;
    }

    OutputStream getOriginalout() {
        return this.originalout;
    }

    public int getPage() {
        return this.page;
    }

    public Rectangle getPageRect() {
        return this.pageRect;
    }

    public PrivateKey getPrivKey() {
        return this.privKey;
    }

    public String getProvider() {
        return this.provider;
    }

    public InputStream getRangeStream() {
        return new RangeStream(this.raf, this.bout, this.range);
    }

    public String getReason() {
        return this.reason;
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public int getRender() {
        return this.render;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public PdfSigGenericPKCS getSigStandard() {
        return this.sigStandard;
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public SignatureEvent getSignatureEvent() {
        return this.signatureEvent;
    }

    public Image getSignatureGraphic() {
        return this.signatureGraphic;
    }

    ByteBuffer getSigout() {
        return this.sigout;
    }

    public PdfStamper getStamper() {
        return this.stamper;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public PdfTemplate getTopLayer() {
        if (this.frm == null) {
            this.frm = new PdfTemplate(this.writer);
            this.frm.setBoundingBox(this.rect);
            this.writer.addDirectTemplateSimple(this.frm, new PdfName("FRM"));
        }
        return this.frm;
    }

    private static int indexArray(byte[] bout, int position, String search) {
        byte[] ss = PdfEncodings.convertToBytes(search, null);
        while (true) {
            int k = 0;
            while (k < ss.length) {
                if (ss[k] != bout[position + k]) break;
                ++k;
            }
            if (k == ss.length) {
                return position;
            }
            ++position;
        }
    }

    private static int indexFile(RandomAccessFile raf, int position, String search) throws IOException {
        byte[] ss = PdfEncodings.convertToBytes(search, null);
        while (true) {
            raf.seek(position);
            int k = 0;
            while (k < ss.length) {
                int b = raf.read();
                if (b < 0) {
                    throw new EOFException("Unexpected EOF");
                }
                if (ss[k] != (byte)b) break;
                ++k;
            }
            if (k == ss.length) {
                return position;
            }
            ++position;
        }
    }

    public boolean isAcro6Layers() {
        return this.acro6Layers;
    }

    public boolean isCertified() {
        return this.certified;
    }

    public boolean isInvisible() {
        return this.rect == null || this.rect.width() == 0.0f || this.rect.height() == 0.0f;
    }

    public boolean isNewField() {
        return this.newField;
    }

    public boolean isPreClosed() {
        return this.preClosed;
    }

    public void preClose(HashMap exclusionSizes) throws IOException, DocumentException {
        if (this.preClosed) {
            throw new DocumentException("Document already pre closed.");
        }
        this.preClosed = true;
        AcroFields af = this.writer.getAcroFields();
        String name = this.getFieldName();
        boolean fieldExists = !this.isInvisible() && !this.isNewField();
        int flags = 132;
        PdfIndirectReference refSig = this.writer.getPdfIndirectReference();
        if (fieldExists && name.indexOf(46) >= 0) {
            ArrayList widgets = af.getFieldItem((String)name).widgets;
            PdfDictionary widget = (PdfDictionary)widgets.get(0);
            this.writer.markUsed(widget);
            widget.put(PdfName.P, this.writer.getPageReference(this.getPage()));
            widget.put(PdfName.V, refSig);
            PdfDictionary ap = new PdfDictionary();
            ap.put(PdfName.N, this.getAppearance().getIndirectReference());
            widget.put(PdfName.AP, ap);
        } else {
            if (fieldExists) {
                flags = 0;
                ArrayList merged = af.getFieldItem((String)name).merged;
                PdfObject obj = PdfReader.getPdfObjectRelease(((PdfDictionary)merged.get(0)).get(PdfName.F));
                if (obj != null && obj.isNumber()) {
                    flags = ((PdfNumber)obj).intValue();
                }
                af.removeField(name);
            }
            this.writer.setSigFlags(3);
            PdfFormField sigField = PdfFormField.createSignature(this.writer);
            sigField.setFieldName(name);
            sigField.put(PdfName.V, refSig);
            sigField.setFlags(flags);
            int pagen = this.getPage();
            if (!this.isInvisible()) {
                sigField.setWidget(this.getPageRect(), null);
                sigField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, this.getAppearance());
            } else {
                sigField.setWidget(new Rectangle(0.0f, 0.0f), null);
            }
            sigField.setPage(pagen);
            this.writer.addAnnotation((PdfAnnotation)sigField, pagen);
        }
        this.exclusionLocations = new HashMap();
        if (this.cryptoDictionary == null) {
            if (PdfName.ADOBE_PPKLITE.equals(this.getFilter())) {
                this.sigStandard = new PdfSigGenericPKCS.PPKLite(this.getProvider());
            } else if (PdfName.ADOBE_PPKMS.equals(this.getFilter())) {
                this.sigStandard = new PdfSigGenericPKCS.PPKMS(this.getProvider());
            } else if (PdfName.VERISIGN_PPKVS.equals(this.getFilter())) {
                this.sigStandard = new PdfSigGenericPKCS.VeriSign(this.getProvider());
            } else {
                throw new IllegalArgumentException("Unknown filter: " + this.getFilter());
            }
            this.sigStandard.setExternalDigest(this.externalDigest, this.externalRSAdata, this.digestEncryptionAlgorithm);
            if (this.getReason() != null) {
                this.sigStandard.setReason(this.getReason());
            }
            if (this.getLocation() != null) {
                this.sigStandard.setLocation(this.getLocation());
            }
            if (this.getContact() != null) {
                this.sigStandard.setContact(this.getContact());
            }
            this.sigStandard.put(PdfName.M, new PdfDate(this.getSignDate()));
            this.sigStandard.setSignInfo(this.getPrivKey(), this.getCertChain(), this.getCrlList());
            PdfString contents = (PdfString)this.sigStandard.get(PdfName.CONTENTS);
            PdfLiteral lit = new PdfLiteral((contents.toString().length() + (PdfName.ADOBE_PPKLITE.equals(this.getFilter()) ? 0 : 64)) * 2 + 2);
            this.exclusionLocations.put(PdfName.CONTENTS, lit);
            this.sigStandard.put(PdfName.CONTENTS, lit);
            lit = new PdfLiteral(80);
            this.exclusionLocations.put(PdfName.BYTERANGE, lit);
            this.sigStandard.put(PdfName.BYTERANGE, lit);
            if (this.certified) {
                this.addDocMDP(this.sigStandard);
            }
            if (this.signatureEvent != null) {
                this.signatureEvent.getSignatureDictionary(this.sigStandard);
            }
            this.writer.addToBody((PdfObject)this.sigStandard, refSig, false);
        } else {
            PdfLiteral lit = new PdfLiteral(80);
            this.exclusionLocations.put(PdfName.BYTERANGE, lit);
            this.cryptoDictionary.put(PdfName.BYTERANGE, lit);
            Iterator it = exclusionSizes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                PdfName key = (PdfName)entry.getKey();
                Integer v = (Integer)entry.getValue();
                lit = new PdfLiteral(v);
                this.exclusionLocations.put(key, lit);
                this.cryptoDictionary.put(key, lit);
            }
            if (this.certified) {
                this.addDocMDP(this.cryptoDictionary);
            }
            if (this.signatureEvent != null) {
                this.signatureEvent.getSignatureDictionary(this.cryptoDictionary);
            }
            this.writer.addToBody((PdfObject)this.cryptoDictionary, refSig, false);
        }
        if (this.certified) {
            PdfDictionary docmdp = new PdfDictionary();
            docmdp.put(new PdfName("DocMDP"), refSig);
            this.writer.reader.getCatalog().put(new PdfName("Perms"), docmdp);
        }
        this.writer.close(this.stamper.getMoreInfo());
        this.range = new int[this.exclusionLocations.size() * 2];
        int byteRangePosition = ((PdfLiteral)this.exclusionLocations.get(PdfName.BYTERANGE)).getPosition();
        this.exclusionLocations.remove(PdfName.BYTERANGE);
        int idx = 1;
        Iterator it = this.exclusionLocations.values().iterator();
        while (it.hasNext()) {
            PdfLiteral lit = (PdfLiteral)it.next();
            int n = lit.getPosition();
            this.range[idx++] = n;
            this.range[idx++] = lit.getPosLength() + n;
        }
        Arrays.sort(this.range, 1, this.range.length - 1);
        int k = 3;
        while (k < this.range.length - 2) {
            int n = k;
            this.range[n] = this.range[n] - this.range[k - 1];
            k += 2;
        }
        if (this.tempFile == null) {
            this.bout = this.sigout.getBuffer();
            this.boutLen = this.sigout.size();
            this.range[this.range.length - 1] = this.boutLen - this.range[this.range.length - 2];
            ByteBuffer bf = new ByteBuffer();
            bf.append('[');
            int k2 = 0;
            while (k2 < this.range.length) {
                bf.append(this.range[k2]).append(' ');
                ++k2;
            }
            bf.append(']');
            System.arraycopy(bf.getBuffer(), 0, this.bout, byteRangePosition, bf.size());
        } else {
            try {
                this.raf = new RandomAccessFile(this.tempFile, "rw");
                int boutLen = (int)this.raf.length();
                this.range[this.range.length - 1] = boutLen - this.range[this.range.length - 2];
                ByteBuffer bf = new ByteBuffer();
                bf.append('[');
                int k3 = 0;
                while (k3 < this.range.length) {
                    bf.append(this.range[k3]).append(' ');
                    ++k3;
                }
                bf.append(']');
                this.raf.seek(byteRangePosition);
                this.raf.write(bf.getBuffer(), 0, bf.size());
            }
            catch (IOException e) {
                try {
                    this.raf.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                try {
                    this.tempFile.delete();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    public void preClose() throws IOException, DocumentException {
        this.preClose(null);
    }

    public void setAcro6Layers(boolean acro6Layers) {
        this.acro6Layers = acro6Layers;
    }

    public void setCertified(boolean certified) {
        this.certified = certified;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public void setCrypto(PrivateKey privKey, Certificate[] certChain, CRL[] crlList, PdfName filter) {
        this.privKey = privKey;
        this.certChain = certChain;
        this.crlList = crlList;
        this.filter = filter;
    }

    public void setCryptoDictionary(PdfDictionary cryptoDictionary) {
        this.cryptoDictionary = cryptoDictionary;
    }

    public void setExternalDigest(byte[] digest, byte[] RSAdata, String digestEncryptionAlgorithm) {
        this.externalDigest = digest;
        this.externalRSAdata = RSAdata;
        this.digestEncryptionAlgorithm = digestEncryptionAlgorithm;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setImageScale(float imageScale) {
        this.imageScale = imageScale;
    }

    public void setLayer2Font(Font layer2Font) {
        this.layer2Font = layer2Font;
    }

    public void setLayer2Text(String text) {
        this.layer2Text = text;
    }

    public void setLayer4Text(String text) {
        this.layer4Text = text;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    void setOriginalout(OutputStream originalout) {
        this.originalout = originalout;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setRender(int render) {
        this.render = render;
    }

    public void setRunDirection(int runDirection) {
        if (runDirection < 0 || runDirection > 3) {
            throw new RuntimeException("Invalid run direction: " + runDirection);
        }
        this.runDirection = runDirection;
    }

    public void setSignDate(Calendar signDate) {
        this.signDate = signDate;
    }

    public void setSignatureEvent(SignatureEvent signatureEvent) {
        this.signatureEvent = signatureEvent;
    }

    public void setSignatureGraphic(Image signatureGraphic) {
        this.signatureGraphic = signatureGraphic;
    }

    void setSigout(ByteBuffer sigout) {
        this.sigout = sigout;
    }

    void setStamper(PdfStamper stamper) {
        this.stamper = stamper;
    }

    void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    public void setVisibleSignature(String fieldName) {
        AcroFields af = this.writer.getAcroFields();
        AcroFields.Item item = af.getFieldItem(fieldName);
        if (item == null) {
            throw new IllegalArgumentException("The field " + fieldName + " does not exist.");
        }
        PdfDictionary merged = (PdfDictionary)item.merged.get(0);
        if (!PdfName.SIG.equals(PdfReader.getPdfObject(merged.get(PdfName.FT)))) {
            throw new IllegalArgumentException("The field " + fieldName + " is not a signature field.");
        }
        this.fieldName = fieldName;
        PdfArray r = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.RECT));
        ArrayList ar = r.getArrayList();
        float llx = ((PdfNumber)PdfReader.getPdfObject((PdfObject)ar.get(0))).floatValue();
        float lly = ((PdfNumber)PdfReader.getPdfObject((PdfObject)ar.get(1))).floatValue();
        float urx = ((PdfNumber)PdfReader.getPdfObject((PdfObject)ar.get(2))).floatValue();
        float ury = ((PdfNumber)PdfReader.getPdfObject((PdfObject)ar.get(3))).floatValue();
        this.pageRect = new Rectangle(llx, lly, urx, ury);
        this.pageRect.normalize();
        this.page = (Integer)item.page.get(0);
        int rotation = this.writer.reader.getPageRotation(this.page);
        Rectangle pageSize = this.writer.reader.getPageSizeWithRotation(this.page);
        switch (rotation) {
            case 90: {
                this.pageRect = new Rectangle(this.pageRect.bottom(), pageSize.top() - this.pageRect.left(), this.pageRect.top(), pageSize.top() - this.pageRect.right());
                break;
            }
            case 180: {
                this.pageRect = new Rectangle(pageSize.right() - this.pageRect.left(), pageSize.top() - this.pageRect.bottom(), pageSize.right() - this.pageRect.right(), pageSize.top() - this.pageRect.top());
                break;
            }
            case 270: {
                this.pageRect = new Rectangle(pageSize.right() - this.pageRect.bottom(), this.pageRect.left(), pageSize.right() - this.pageRect.top(), this.pageRect.right());
            }
        }
        if (rotation != 0) {
            this.pageRect.normalize();
        }
        this.rect = new Rectangle(this.pageRect.width(), this.pageRect.height());
    }

    public void setVisibleSignature(Rectangle pageRect, int page, String fieldName) {
        if (fieldName != null) {
            if (fieldName.indexOf(46) >= 0) {
                throw new IllegalArgumentException("Field names cannot contain a dot.");
            }
            AcroFields af = this.writer.getAcroFields();
            AcroFields.Item item = af.getFieldItem(fieldName);
            if (item != null) {
                throw new IllegalArgumentException("The field " + fieldName + " already exists.");
            }
            this.fieldName = fieldName;
        }
        if (page < 1 || page > this.writer.reader.getNumberOfPages()) {
            throw new IllegalArgumentException("Invalid page number: " + page);
        }
        this.pageRect = new Rectangle(pageRect);
        this.pageRect.normalize();
        this.rect = new Rectangle(this.pageRect.width(), this.pageRect.height());
        this.page = page;
        this.newField = true;
    }

    public static interface SignatureEvent {
        public void getSignatureDictionary(PdfDictionary var1);
    }

    private static class RangeStream
    extends InputStream {
        private byte[] b = new byte[1];
        private byte[] bout;
        private RandomAccessFile raf;
        private int[] range;
        private int rangePosition = 0;

        private RangeStream(RandomAccessFile raf, byte[] bout, int[] range) {
            this.raf = raf;
            this.bout = bout;
            this.range = range;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.rangePosition >= this.range[this.range.length - 2] + this.range[this.range.length - 1]) {
                return -1;
            }
            int k = 0;
            while (k < this.range.length) {
                int start = this.range[k];
                int end = start + this.range[k + 1];
                if (this.rangePosition < start) {
                    this.rangePosition = start;
                }
                if (this.rangePosition >= start && this.rangePosition < end) {
                    int lenf = Math.min(len, end - this.rangePosition);
                    if (this.raf == null) {
                        System.arraycopy(this.bout, this.rangePosition, b, off, lenf);
                    } else {
                        this.raf.seek(this.rangePosition);
                        this.raf.readFully(b, off, lenf);
                    }
                    this.rangePosition += lenf;
                    return lenf;
                }
                k += 2;
            }
            return -1;
        }

        public int read() throws IOException {
            int n = this.read(this.b);
            if (n != 1) {
                return -1;
            }
            return this.b[0] & 0xFF;
        }
    }
}

