/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.PageResources;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfFormXObject;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfOCG;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfStream;
import com.lowagie2.text.pdf.PdfTransparencyGroup;
import com.lowagie2.text.pdf.PdfWriter;
import java.io.IOException;

public class PdfTemplate
extends PdfContentByte {
    public static final int TYPE_IMPORTED = 2;
    public static final int TYPE_PATTERN = 3;
    public static final int TYPE_TEMPLATE = 1;
    protected Rectangle bBox = new Rectangle(0.0f, 0.0f);
    protected PdfTransparencyGroup group;
    protected PdfOCG layer;
    protected PdfArray matrix;
    protected PageResources pageResources;
    protected PdfIndirectReference thisReference;
    protected int type = 1;

    PdfTemplate(PdfWriter wr) {
        super(wr);
        this.pageResources = new PageResources();
        this.pageResources.addDefaultColor(wr.getDefaultColorspace());
        this.thisReference = this.writer.getPdfIndirectReference();
    }

    protected PdfTemplate() {
        super(null);
    }

    public void beginVariableText() {
        this.content.append("/Tx BMC ");
    }

    public void endVariableText() {
        this.content.append("EMC ");
    }

    public Rectangle getBoundingBox() {
        return this.bBox;
    }

    public PdfContentByte getDuplicate() {
        PdfTemplate tpl = new PdfTemplate();
        tpl.writer = this.writer;
        tpl.pdf = this.pdf;
        tpl.thisReference = this.thisReference;
        tpl.pageResources = this.pageResources;
        tpl.bBox = new Rectangle(this.bBox);
        tpl.group = this.group;
        tpl.layer = this.layer;
        if (this.matrix != null) {
            tpl.matrix = new PdfArray(this.matrix);
        }
        tpl.separator = this.separator;
        return tpl;
    }

    PdfStream getFormXObject() throws IOException {
        return new PdfFormXObject(this);
    }

    public PdfTransparencyGroup getGroup() {
        return this.group;
    }

    public float getHeight() {
        return this.bBox.height();
    }

    public PdfIndirectReference getIndirectReference() {
        return this.thisReference;
    }

    public PdfOCG getLayer() {
        return this.layer;
    }

    PdfArray getMatrix() {
        return this.matrix;
    }

    PageResources getPageResources() {
        return this.pageResources;
    }

    PdfObject getResources() {
        return this.getPageResources().getResources();
    }

    public int getType() {
        return this.type;
    }

    public float getWidth() {
        return this.bBox.width();
    }

    public void setBoundingBox(Rectangle bBox) {
        this.bBox = bBox;
    }

    public void setGroup(PdfTransparencyGroup group) {
        this.group = group;
    }

    public void setHeight(float height) {
        this.bBox.setBottom(0.0f);
        this.bBox.setTop(height);
    }

    public void setLayer(PdfOCG layer) {
        this.layer = layer;
    }

    public void setMatrix(float a, float b, float c, float d, float e, float f) {
        this.matrix = new PdfArray();
        this.matrix.add(new PdfNumber(a));
        this.matrix.add(new PdfNumber(b));
        this.matrix.add(new PdfNumber(c));
        this.matrix.add(new PdfNumber(d));
        this.matrix.add(new PdfNumber(e));
        this.matrix.add(new PdfNumber(f));
    }

    public void setWidth(float width) {
        this.bBox.setLeft(0.0f);
        this.bBox.setRight(width);
    }
}

