/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf.events;

import com.lowagie2.text.Document;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfFormField;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfPCell;
import com.lowagie2.text.pdf.PdfPCellEvent;
import com.lowagie2.text.pdf.PdfPageEventHelper;
import com.lowagie2.text.pdf.PdfRectangle;
import com.lowagie2.text.pdf.PdfWriter;
import com.lowagie2.text.pdf.TextField;
import java.io.IOException;
import java.util.HashMap;

public class FieldPositioningEvents
extends PdfPageEventHelper
implements PdfPCellEvent {
    protected PdfFormField cellField = null;
    protected PdfWriter fieldWriter = null;
    protected HashMap genericChunkFields = new HashMap();
    public float padding;
    protected PdfFormField parent = null;

    public FieldPositioningEvents(PdfWriter writer, PdfFormField parent, String text) throws IOException, DocumentException {
        this.parent = parent;
        TextField tf = new TextField(writer, new Rectangle(0.0f, 0.0f), text);
        tf.setFontSize(14.0f);
        this.cellField = tf.getTextField();
    }

    public FieldPositioningEvents(PdfWriter writer, String text) throws IOException, DocumentException {
        this.fieldWriter = writer;
        TextField tf = new TextField(writer, new Rectangle(0.0f, 0.0f), text);
        tf.setFontSize(14.0f);
        this.cellField = tf.getTextField();
    }

    public FieldPositioningEvents(PdfFormField parent, PdfFormField field) {
        this.cellField = field;
        this.parent = parent;
    }

    public FieldPositioningEvents(PdfWriter writer, PdfFormField field) {
        this.cellField = field;
        this.fieldWriter = writer;
    }

    public FieldPositioningEvents() {
    }

    public void addField(String text, PdfFormField field) {
        this.genericChunkFields.put(text, field);
    }

    public void cellLayout(PdfPCell cell, Rectangle rect, PdfContentByte[] canvases) {
        if (this.cellField == null || this.fieldWriter == null && this.parent == null) {
            throw new ExceptionConverter(new IllegalArgumentException("You have used the wrong constructor for this FieldPositioningEvents class."));
        }
        this.cellField.put(PdfName.RECT, new PdfRectangle(rect.left(this.padding), rect.bottom(this.padding), rect.right(this.padding), rect.top(this.padding)));
        if (this.parent == null) {
            this.fieldWriter.addAnnotation(this.cellField);
        } else {
            this.parent.addKid(this.cellField);
        }
    }

    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {
        rect.setBottom(rect.bottom() - 3.0f);
        PdfFormField field = (PdfFormField)this.genericChunkFields.get(text);
        if (field == null) {
            TextField tf = new TextField(writer, new Rectangle(rect.left(this.padding), rect.bottom(this.padding), rect.right(this.padding), rect.top(this.padding)), text);
            tf.setFontSize(14.0f);
            try {
                field = tf.getTextField();
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        } else {
            field.put(PdfName.RECT, new PdfRectangle(rect.left(this.padding), rect.bottom(this.padding), rect.right(this.padding), rect.top(this.padding)));
        }
        if (this.parent == null) {
            writer.addAnnotation(field);
        } else {
            this.parent.addKid(field);
        }
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public void setParent(PdfFormField parent) {
        this.parent = parent;
    }
}

