/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf;

import com.lowagie2.text.Font;
import java.awt.Color;

public class RtfFont
extends Font {
    private String familyName = "";

    public RtfFont(String familyName, float size, int style, Color color) {
        super(-1, size, style, color);
        this.familyName = familyName;
    }

    public RtfFont(String familyName, float size, int style) {
        super(-1, size, style);
        this.familyName = familyName;
    }

    public RtfFont(String familyName, float size) {
        super(-1, size);
        this.familyName = familyName;
    }

    public RtfFont(String familyName) {
        super(-1);
        this.familyName = familyName;
    }

    public Font difference(Font font) {
        float dSize;
        String dFamilyname = font.getFamilyname();
        if (dFamilyname == null || dFamilyname.trim().equals("")) {
            dFamilyname = this.familyName;
        }
        if ((dSize = font.size()) == -1.0f) {
            dSize = this.size();
        }
        int dStyle = -1;
        if (this.style() != -1 && font.style() != -1) {
            dStyle = this.style() | font.style();
        } else if (this.style() != -1) {
            dStyle = this.style();
        } else if (font.style() != -1) {
            dStyle = font.style();
        }
        Color dColor = font.color();
        if (dColor == null) {
            dColor = this.color();
        }
        return new RtfFont(dFamilyname, dSize, dStyle, dColor);
    }

    public String getFamilyname() {
        return this.familyName;
    }
}

