/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Font;
import com.lowagie2.text.rtf.RtfField;
import com.lowagie2.text.rtf.RtfTOCEntry;
import com.lowagie2.text.rtf.RtfWriter;
import java.io.IOException;
import java.io.OutputStream;

public class RtfTOC
extends Chunk
implements RtfField {
    private boolean addTOCAsTOCEntry = false;
    private String defaultText = "Klicken Sie mit der rechten Maustaste auf diesen Text, um das Inhaltsverzeichnis zu aktualisieren!";
    private Font entryFont = null;
    private String entryName = null;

    public RtfTOC(String tocName, Font tocFont) {
        super(tocName, tocFont);
    }

    public void addTOCAsTOCEntry(String entryName, Font entryFont) {
        this.addTOCAsTOCEntry = true;
        this.entryFont = entryFont;
        this.entryName = entryName;
    }

    public void setDefaultText(String text) {
        this.defaultText = text;
    }

    public void write(RtfWriter writer, OutputStream out) throws IOException {
        writer.writeInitialFontSignature(out, this);
        out.write(RtfWriter.filterSpecialChar(this.content(), true).getBytes());
        writer.writeFinishingFontSignature(out, this);
        if (this.addTOCAsTOCEntry) {
            RtfTOCEntry entry = new RtfTOCEntry(this.entryName, this.entryFont);
            entry.hideText();
            try {
                writer.add(entry);
            }
            catch (DocumentException de) {
                throw new ExceptionConverter(de);
            }
        }
        out.write(92);
        out.write(RtfWriter.paragraph);
        out.write(32);
        out.write(123);
        out.write(92);
        out.write(RtfWriter.field);
        out.write(123);
        out.write(92);
        out.write(RtfWriter.fieldContent);
        out.write(32);
        out.write("TOC".getBytes());
        out.write(32);
        out.write(92);
        out.write(92);
        out.write("f".getBytes());
        out.write(32);
        out.write(92);
        out.write(92);
        out.write("h".getBytes());
        out.write(32);
        out.write(32);
        out.write(92);
        out.write(92);
        out.write("u".getBytes());
        out.write(32);
        out.write(32);
        out.write(92);
        out.write(92);
        out.write("o".getBytes());
        out.write(32);
        out.write("\"1-5\"".getBytes());
        out.write(32);
        out.write(125);
        out.write(123);
        out.write(92);
        out.write(RtfWriter.fieldDisplay);
        out.write(32);
        out.write(this.defaultText.getBytes());
        out.write(32);
        out.write(125);
        out.write(125);
    }
}

