/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.Font;
import com.lowagie2.text.rtf.RtfField;
import com.lowagie2.text.rtf.RtfWriter;
import java.io.IOException;
import java.io.OutputStream;

public class RtfTOCEntry
extends Chunk
implements RtfField {
    private Font contentFont;
    private Font entryFont;
    private String entryName;
    private boolean hidePageNumber = false;
    private boolean hideText = false;

    public RtfTOCEntry(String content, Font contentFont, String entryName, Font entryFont) {
        super(content, contentFont);
        this.entryName = entryName;
        this.entryFont = entryFont;
        this.contentFont = contentFont;
    }

    public RtfTOCEntry(String content, Font contentFont) {
        this(content, contentFont, content, contentFont);
    }

    public void hidePageNumber() {
        this.hidePageNumber = true;
    }

    public void hideText() {
        this.hideText = true;
    }

    public void write(RtfWriter writer, OutputStream out) throws IOException {
        if (!this.hideText) {
            writer.writeInitialFontSignature(out, new Chunk("", this.contentFont));
            out.write(RtfWriter.filterSpecialChar(this.content(), true).getBytes());
            writer.writeFinishingFontSignature(out, new Chunk("", this.contentFont));
        }
        if (!this.entryFont.equals(this.contentFont)) {
            writer.writeInitialFontSignature(out, new Chunk("", this.entryFont));
            this.writeField(out);
            writer.writeFinishingFontSignature(out, new Chunk("", this.entryFont));
        } else {
            writer.writeInitialFontSignature(out, new Chunk("", this.contentFont));
            this.writeField(out);
            writer.writeFinishingFontSignature(out, new Chunk("", this.contentFont));
        }
    }

    private void writeField(OutputStream out) throws IOException {
        out.write(123);
        out.write(92);
        out.write("v".getBytes());
        out.write(123);
        out.write(92);
        if (!this.hidePageNumber) {
            out.write("tc".getBytes());
        } else {
            out.write("tcn".getBytes());
        }
        out.write(32);
        out.write(RtfWriter.filterSpecialChar(this.entryName, true).getBytes());
        out.write(32);
        out.write(125);
        out.write(125);
    }
}

