/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.direct;

import com.lowagie2.text.rtf.direct.RtfColorTableParser;
import com.lowagie2.text.rtf.direct.RtfImportHeader;

public class RtfFontTableParser {
    private String fontName = "";
    private String fontNr = "";
    private RtfImportHeader importHeader = null;

    public RtfFontTableParser(RtfImportHeader importHeader) {
        this.importHeader = importHeader;
        this.fontNr = "";
        this.fontName = "";
    }

    public void handleCloseGroup(int groupLevel) {
        if (groupLevel == 3 && !this.fontNr.equals("") && !this.fontName.equals("")) {
            this.importHeader.importFont(this.fontNr, this.fontName);
            this.fontNr = "";
            this.fontName = "";
        }
    }

    public void handleCtrlWord(String ctrlWord, int groupLevel) {
        if (RtfColorTableParser.stringMatches(ctrlWord, "\\f") && groupLevel == 3) {
            this.fontNr = ctrlWord.substring(2);
        }
    }

    public void handleText(String text, int groupLevel) {
        if (text.indexOf(";") >= 0 && groupLevel == 3) {
            this.fontName = text.substring(0, text.indexOf(";"));
        }
    }
}

