/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.direct;

import com.lowagie2.text.DocumentException;
import com.lowagie2.text.rtf.direct.RtfParser;
import java.io.IOException;
import java.io.Reader;

public class RtfTokeniser {
    private static final int TOKENISER_STATE_IN_CTRL_WORD = 2;
    private static final int TOKENISER_STATE_IN_TEXT = 4;
    private static final int TOKENISER_STATE_READY = 0;
    private static final int TOKENISER_STATE_SLASH = 1;
    private int groupLevel = 0;
    private RtfParser rtfParser = null;
    private int state = 0;

    public RtfTokeniser(RtfParser rtfParser, int startGroupLevel) {
        this.rtfParser = rtfParser;
        this.groupLevel = startGroupLevel;
    }

    public void tokenise(Reader reader) throws IOException, DocumentException {
        char[] nextChar = new char[1];
        String temp = "";
        this.state = 0;
        this.groupLevel = 0;
        while (reader.read(nextChar) != -1) {
            if (this.state == 0) {
                if (nextChar[0] == '{') {
                    this.rtfParser.handleOpenGroup(this.groupLevel);
                    ++this.groupLevel;
                    continue;
                }
                if (nextChar[0] == '}') {
                    this.rtfParser.handleCloseGroup(this.groupLevel);
                    --this.groupLevel;
                    continue;
                }
                if (nextChar[0] == '\\') {
                    this.state = 1;
                    temp = "";
                    continue;
                }
                this.state = 4;
                temp = temp + nextChar[0];
                continue;
            }
            if ((this.state & 1) == 1) {
                if (nextChar[0] == '{') {
                    this.state = 4;
                    temp = temp + "\\{";
                    continue;
                }
                if (nextChar[0] == '}') {
                    this.state = 4;
                    temp = temp + "\\}";
                    continue;
                }
                if (nextChar[0] == '\\') {
                    this.state = 4;
                    temp = temp + "\\\\";
                    continue;
                }
                if ((this.state & 4) == 4) {
                    this.rtfParser.handleText(temp, this.groupLevel);
                    temp = "";
                }
                if (nextChar[0] == '|') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\|", this.groupLevel);
                    continue;
                }
                if (nextChar[0] == '~') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\~", this.groupLevel);
                    continue;
                }
                if (nextChar[0] == '-') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\-", this.groupLevel);
                    continue;
                }
                if (nextChar[0] == '_') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\_", this.groupLevel);
                    continue;
                }
                if (nextChar[0] == ':') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\:", this.groupLevel);
                    continue;
                }
                if (nextChar[0] == '*') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\*", this.groupLevel);
                    continue;
                }
                this.state = 2;
                temp = "\\" + nextChar[0];
                continue;
            }
            if (this.state == 2) {
                if (nextChar[0] == '\n' || nextChar[0] == '\r') {
                    nextChar[0] = 32;
                }
                if (nextChar[0] == '{') {
                    this.rtfParser.handleCtrlWord(temp, this.groupLevel);
                    this.rtfParser.handleOpenGroup(this.groupLevel);
                    ++this.groupLevel;
                    this.state = 0;
                    temp = "";
                    continue;
                }
                if (nextChar[0] == '}') {
                    this.rtfParser.handleCtrlWord(temp, this.groupLevel);
                    this.rtfParser.handleCloseGroup(this.groupLevel);
                    --this.groupLevel;
                    this.state = 0;
                    temp = "";
                    continue;
                }
                if (nextChar[0] == '\\') {
                    this.rtfParser.handleCtrlWord(temp, this.groupLevel);
                    this.state = 1;
                    temp = "";
                    continue;
                }
                if (nextChar[0] == ' ') {
                    this.rtfParser.handleCtrlWord(temp, this.groupLevel);
                    this.rtfParser.handleText(" ", this.groupLevel);
                    this.state = 0;
                    temp = "";
                    continue;
                }
                if (nextChar[0] == ';') {
                    this.rtfParser.handleCtrlWord(temp, this.groupLevel);
                    this.rtfParser.handleText(";", this.groupLevel);
                    this.state = 0;
                    temp = "";
                    continue;
                }
                temp = temp + nextChar[0];
                continue;
            }
            if (this.state != 4) continue;
            if (nextChar[0] == '{') {
                this.rtfParser.handleText(temp, this.groupLevel);
                this.rtfParser.handleOpenGroup(this.groupLevel);
                ++this.groupLevel;
                this.state = 0;
                temp = "";
                continue;
            }
            if (nextChar[0] == '}') {
                this.rtfParser.handleText(temp, this.groupLevel);
                this.rtfParser.handleCloseGroup(this.groupLevel);
                --this.groupLevel;
                this.state = 0;
                temp = "";
                continue;
            }
            if (nextChar[0] == '\\') {
                this.state = 5;
                continue;
            }
            temp = temp + nextChar[0];
        }
        if ((this.state & 4) == 4 && !temp.equals("")) {
            this.rtfParser.handleText(temp, this.groupLevel);
        }
    }
}

