/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.document;

import com.lowagie2.text.HeaderFooter;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.document.RtfCodePage;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.document.RtfInfoElement;
import com.lowagie2.text.rtf.document.RtfInfoGroup;
import com.lowagie2.text.rtf.document.RtfPageSetting;
import com.lowagie2.text.rtf.headerfooter.RtfHeaderFooter;
import com.lowagie2.text.rtf.headerfooter.RtfHeaderFooterGroup;
import com.lowagie2.text.rtf.list.RtfList;
import com.lowagie2.text.rtf.list.RtfListTable;
import com.lowagie2.text.rtf.style.RtfColor;
import com.lowagie2.text.rtf.style.RtfColorList;
import com.lowagie2.text.rtf.style.RtfFont;
import com.lowagie2.text.rtf.style.RtfFontList;
import com.lowagie2.text.rtf.style.RtfParagraphStyle;
import com.lowagie2.text.rtf.style.RtfStylesheetList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfDocumentHeader
extends RtfElement {
    private static final byte[] FACING_PAGES;
    private static final byte[] TITLE_PAGE;
    private RtfCodePage codePage = null;
    private RtfColorList colorList = null;
    private RtfFontList fontList = null;
    private RtfHeaderFooterGroup footer = null;
    private RtfHeaderFooterGroup header = null;
    private RtfInfoGroup infoGroup = null;
    private RtfListTable listTable = null;
    private RtfPageSetting pageSetting = null;
    private RtfStylesheetList stylesheetList = null;

    static {
        TITLE_PAGE = "\\titlepg".getBytes();
        FACING_PAGES = "\\facingp".getBytes();
    }

    protected RtfDocumentHeader(RtfDocument doc) {
        super(doc);
    }

    public void addInfoElement(RtfInfoElement rtfInfoElement) {
        this.infoGroup.add(rtfInfoElement);
    }

    public void freeListNumber(RtfList list) {
        this.listTable.freeListNumber(list);
    }

    public int getColorNumber(RtfColor color) {
        return this.colorList.getColorNumber(color);
    }

    public int getFontNumber(RtfFont font) {
        return this.fontList.getFontNumber(font);
    }

    public int getListNumber(RtfList list) {
        return this.listTable.getListNumber(list);
    }

    public RtfPageSetting getPageSetting() {
        return this.pageSetting;
    }

    public RtfParagraphStyle getRtfParagraphStyle(String styleName) {
        return this.stylesheetList.getRtfParagraphStyle(styleName);
    }

    protected void init() {
        this.codePage = new RtfCodePage(this.document);
        this.colorList = new RtfColorList(this.document);
        this.fontList = new RtfFontList(this.document);
        this.listTable = new RtfListTable(this.document);
        this.stylesheetList = new RtfStylesheetList(this.document);
        this.infoGroup = new RtfInfoGroup(this.document);
        this.pageSetting = new RtfPageSetting(this.document);
        this.header = new RtfHeaderFooterGroup(this.document, 1);
        this.footer = new RtfHeaderFooterGroup(this.document, 2);
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        this.stylesheetList.registerParagraphStyle(rtfParagraphStyle);
    }

    public void setFooter(HeaderFooter footer) {
        this.footer = footer != null ? (footer instanceof RtfHeaderFooterGroup ? new RtfHeaderFooterGroup(this.document, (RtfHeaderFooterGroup)footer, 2) : (footer instanceof RtfHeaderFooter ? new RtfHeaderFooterGroup(this.document, (RtfHeaderFooter)footer, 2) : new RtfHeaderFooterGroup(this.document, footer, 2))) : new RtfHeaderFooterGroup(this.document, 2);
    }

    public void setHeader(HeaderFooter header) {
        this.header = header != null ? (header instanceof RtfHeaderFooterGroup ? new RtfHeaderFooterGroup(this.document, (RtfHeaderFooterGroup)header, 1) : (header instanceof RtfHeaderFooter ? new RtfHeaderFooterGroup(this.document, (RtfHeaderFooter)header, 1) : new RtfHeaderFooterGroup(this.document, header, 1))) : new RtfHeaderFooterGroup(this.document, 1);
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(this.codePage.writeDefinition());
            result.write(this.fontList.writeDefinition());
            result.write(this.colorList.writeDefinition());
            result.write(this.stylesheetList.writeDefinition());
            result.write(this.listTable.writeDefinition());
            result.write(this.infoGroup.write());
            result.write(this.pageSetting.writeDefinition());
            result.write(this.writeSectionDefinition());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeSectionDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.header.hasTitlePage() || this.footer.hasTitlePage()) {
                result.write(TITLE_PAGE);
                this.header.setHasTitlePage();
                this.footer.setHasTitlePage();
            }
            if (this.header.hasFacingPages() || this.footer.hasFacingPages()) {
                result.write(FACING_PAGES);
                this.header.setHasFacingPages();
                this.footer.setHasFacingPages();
            }
            result.write(this.footer.write());
            result.write(this.header.write());
            result.write(this.pageSetting.writeSectionDefinition());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

