/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.document;

import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.style.RtfParagraphStyle;

public class RtfDocumentSettings {
    private boolean alwaysGenerateSoftLinebreaks = false;
    private boolean alwaysUseUnicode = true;
    private int dataCacheStyle = 2;
    private RtfDocument document = null;
    private boolean outputDebugLineBreaks = true;
    private boolean outputTableRowDefinitionAfter = true;

    public RtfDocumentSettings(RtfDocument document) {
        this.document = document;
    }

    public int getDataCacheStyle() {
        return this.dataCacheStyle;
    }

    public boolean isAlwaysGenerateSoftLinebreaks() {
        return this.alwaysGenerateSoftLinebreaks;
    }

    public boolean isAlwaysUseUnicode() {
        return this.alwaysUseUnicode;
    }

    public boolean isOutputDebugLineBreaks() {
        return this.outputDebugLineBreaks;
    }

    public boolean isOutputTableRowDefinitionAfter() {
        return this.outputTableRowDefinitionAfter;
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        this.document.getDocumentHeader().registerParagraphStyle(rtfParagraphStyle);
    }

    public void setAlwaysGenerateSoftLinebreaks(boolean alwaysGenerateSoftLinebreaks) {
        this.alwaysGenerateSoftLinebreaks = alwaysGenerateSoftLinebreaks;
    }

    public void setAlwaysUseUnicode(boolean alwaysUseUnicode) {
        this.alwaysUseUnicode = alwaysUseUnicode;
    }

    public void setDataCacheStyle(int dataCacheStyle) {
        switch (dataCacheStyle) {
            case 2: {
                this.dataCacheStyle = 2;
                break;
            }
            case 1: {
                this.dataCacheStyle = 1;
                break;
            }
            default: {
                this.dataCacheStyle = 2;
            }
        }
    }

    public void setOutputDebugLineBreaks(boolean outputDebugLineBreaks) {
        this.outputDebugLineBreaks = outputDebugLineBreaks;
    }

    public void setOutputTableRowDefinitionAfter(boolean outputTableRowDefinitionAfter) {
        this.outputTableRowDefinitionAfter = outputTableRowDefinitionAfter;
    }
}

