/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.field;

import com.lowagie2.text.Font;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.field.RtfField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfTOCEntry
extends RtfField {
    private static final byte[] TEXT_HIDDEN_OFF;
    private static final byte[] TEXT_HIDDEN_ON;
    private static final byte[] TOC_ENTRY_NO_PAGE_NUMBER;
    private static final byte[] TOC_ENTRY_PAGE_NUMBER;
    private String entry = "";
    private boolean showPageNumber = true;

    static {
        TEXT_HIDDEN_ON = "\\v".getBytes();
        TEXT_HIDDEN_OFF = "\\v0".getBytes();
        TOC_ENTRY_PAGE_NUMBER = "\\tc".getBytes();
        TOC_ENTRY_NO_PAGE_NUMBER = "\\tcn".getBytes();
    }

    public RtfTOCEntry(String entry) {
        super((RtfDocument)null, new Font());
        if (entry != null) {
            this.entry = entry;
        }
    }

    public void setShowPageNumber(boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(TEXT_HIDDEN_ON);
            result.write(RtfBasicElement.OPEN_GROUP);
            if (this.showPageNumber) {
                result.write(TOC_ENTRY_PAGE_NUMBER);
            } else {
                result.write(TOC_ENTRY_NO_PAGE_NUMBER);
            }
            result.write(RtfBasicElement.DELIMITER);
            result.write(this.document.filterSpecialChar(this.entry, true, false).getBytes());
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(TEXT_HIDDEN_OFF);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    protected byte[] writeFieldInstContent() throws IOException {
        return null;
    }

    protected byte[] writeFieldResultContent() throws IOException {
        return null;
    }
}

