/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.list;

import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.RtfExtendedElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.list.RtfList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfListTable
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] LIST;
    private static final byte[] LIST_HYBRID;
    private static final byte[] LIST_ID;
    protected static final byte[] LIST_NUMBER;
    private static final byte[] LIST_OVERRIDE;
    private static final byte[] LIST_OVERRIDE_COUNT;
    private static final byte[] LIST_OVERRIDE_TABLE;
    private static final byte[] LIST_TABLE;
    private static final byte[] LIST_TEMPLATE_ID;
    private ArrayList lists = new ArrayList();

    static {
        LIST_NUMBER = "\\ls".getBytes();
        LIST_TABLE = "\\*\\listtable".getBytes();
        LIST = "\\list".getBytes();
        LIST_TEMPLATE_ID = "\\listtemplateid".getBytes();
        LIST_HYBRID = "\\hybrid".getBytes();
        LIST_ID = "\\listid".getBytes();
        LIST_OVERRIDE_TABLE = "\\*\\listoverridetable".getBytes();
        LIST_OVERRIDE = "\\listoverride".getBytes();
        LIST_OVERRIDE_COUNT = "\\listoverridecount".getBytes();
    }

    public RtfListTable(RtfDocument doc) {
        super(doc);
    }

    public void freeListNumber(RtfList list) {
        int i = this.lists.indexOf(list);
        if (i >= 0) {
            this.lists.remove(i);
        }
    }

    public int getListNumber(RtfList list) {
        if (this.lists.contains(list)) {
            return this.lists.indexOf(list);
        }
        this.lists.add(list);
        return this.lists.size();
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int[] listIds = new int[this.lists.size()];
        try {
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(LIST_TABLE);
            result.write("\n".getBytes());
            int i = 0;
            while (i < this.lists.size()) {
                result.write(RtfBasicElement.OPEN_GROUP);
                result.write(LIST);
                result.write(LIST_TEMPLATE_ID);
                result.write(this.intToByteArray(this.document.getRandomInt()));
                result.write(LIST_HYBRID);
                result.write("\n".getBytes());
                result.write(((RtfList)this.lists.get(i)).writeDefinition());
                result.write(LIST_ID);
                listIds[i] = this.document.getRandomInt();
                result.write(this.intToByteArray(listIds[i]));
                result.write(RtfBasicElement.CLOSE_GROUP);
                result.write("\n".getBytes());
                ++i;
            }
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write("\n".getBytes());
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(LIST_OVERRIDE_TABLE);
            result.write("\n".getBytes());
            int i2 = 0;
            while (i2 < this.lists.size()) {
                result.write(RtfBasicElement.OPEN_GROUP);
                result.write(LIST_OVERRIDE);
                result.write(LIST_ID);
                result.write(this.intToByteArray(listIds[i2]));
                result.write(LIST_OVERRIDE_COUNT);
                result.write(this.intToByteArray(0));
                result.write(LIST_NUMBER);
                result.write(this.intToByteArray(((RtfList)this.lists.get(i2)).getListNumber()));
                result.write(RtfBasicElement.CLOSE_GROUP);
                result.write("\n".getBytes());
                ++i2;
            }
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write("\n".getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

