/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.style;

import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.RtfExtendedElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.style.RtfParagraphStyle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class RtfStylesheetList
extends RtfElement
implements RtfExtendedElement {
    private boolean defaultsLoaded = false;
    private HashMap styleMap = new HashMap();

    public RtfStylesheetList(RtfDocument doc) {
        super(doc);
    }

    public RtfParagraphStyle getRtfParagraphStyle(String styleName) {
        if (!this.defaultsLoaded) {
            this.registerDefaultStyles();
        }
        if (this.styleMap.containsKey(styleName)) {
            return (RtfParagraphStyle)this.styleMap.get(styleName);
        }
        return null;
    }

    private void registerDefaultStyles() {
        this.defaultsLoaded = true;
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_NORMAL.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_NORMAL);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_1.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_1);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_2.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_2);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_3.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_3);
        }
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        RtfParagraphStyle tempStyle = new RtfParagraphStyle(this.document, rtfParagraphStyle);
        tempStyle.setStyleNumber(this.styleMap.size());
        tempStyle.handleInheritance();
        this.styleMap.put(tempStyle.getStyleName(), tempStyle);
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write("{".getBytes());
            result.write("\\stylesheet".getBytes());
            result.write(RtfBasicElement.DELIMITER);
            if (this.document.getDocumentSettings().isOutputDebugLineBreaks()) {
                result.write("\n".getBytes());
            }
            Iterator it = this.styleMap.values().iterator();
            while (it.hasNext()) {
                result.write(((RtfParagraphStyle)it.next()).writeDefinition());
            }
            result.write("}".getBytes());
            if (this.document.getDocumentSettings().isOutputDebugLineBreaks()) {
                result.write(10);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

