/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.table;

import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.table.RtfBorder;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class RtfBorderGroup
extends RtfElement {
    private int borderType = 1;
    private Hashtable borders = null;

    protected RtfBorderGroup(RtfDocument doc, int borderType, int bordersToUse, float borderWidth, Color borderColor) {
        super(doc);
        this.borderType = borderType;
        this.borders = new Hashtable();
        this.addBorder(bordersToUse, 1, borderWidth, borderColor);
    }

    protected RtfBorderGroup(RtfDocument doc, int borderType, RtfBorderGroup borderGroup) {
        super(doc);
        this.borders = new Hashtable();
        this.borderType = borderType;
        if (borderGroup != null) {
            Enumeration borderEnum = borderGroup.getBorders().keys();
            while (borderEnum.hasMoreElements()) {
                Integer borderPos = (Integer)borderEnum.nextElement();
                RtfBorder border = (RtfBorder)borderGroup.getBorders().get(borderPos);
                this.borders.put(borderPos, new RtfBorder(this.document, this.borderType, border));
            }
        }
    }

    public RtfBorderGroup(int bordersToAdd, int borderStyle, float borderWidth, Color borderColor) {
        super(null);
        this.borders = new Hashtable();
        this.addBorder(bordersToAdd, borderStyle, borderWidth, borderColor);
    }

    public RtfBorderGroup() {
        super(null);
        this.borders = new Hashtable();
    }

    public void addBorder(int bordersToAdd, int borderStyle, float borderWidth, Color borderColor) {
        if ((bordersToAdd & 4) == 4) {
            this.setBorder(1, borderStyle, borderWidth, borderColor);
        }
        if ((bordersToAdd & 1) == 1) {
            this.setBorder(2, borderStyle, borderWidth, borderColor);
        }
        if ((bordersToAdd & 8) == 8) {
            this.setBorder(4, borderStyle, borderWidth, borderColor);
        }
        if ((bordersToAdd & 2) == 2) {
            this.setBorder(8, borderStyle, borderWidth, borderColor);
        }
        if ((bordersToAdd & 0xF) == 15 && this.borderType == 1) {
            this.setBorder(16, borderStyle, borderWidth, borderColor);
            this.setBorder(32, borderStyle, borderWidth, borderColor);
        }
    }

    protected Hashtable getBorders() {
        return this.borders;
    }

    public void removeBorder(int bordersToRemove) {
        if ((bordersToRemove & 4) == 4) {
            this.borders.remove(new Integer(1));
        }
        if ((bordersToRemove & 1) == 1) {
            this.borders.remove(new Integer(2));
        }
        if ((bordersToRemove & 8) == 8) {
            this.borders.remove(new Integer(4));
        }
        if ((bordersToRemove & 2) == 2) {
            this.borders.remove(new Integer(8));
        }
        if ((bordersToRemove & 0xF) == 15 && this.borderType == 1) {
            this.borders.remove(new Integer(16));
            this.borders.remove(new Integer(32));
        }
    }

    private void setBorder(int borderPosition, int borderStyle, float borderWidth, Color borderColor) {
        RtfBorder border = new RtfBorder(this.document, this.borderType, borderPosition, borderStyle, borderWidth, borderColor);
        this.borders.put(new Integer(borderPosition), border);
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            Enumeration borderEnum = this.borders.keys();
            while (borderEnum.hasMoreElements()) {
                result.write(((RtfBorder)this.borders.get(borderEnum.nextElement())).write());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

