/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.text;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfPhrase
extends RtfElement {
    public static final byte[] IN_TABLE;
    public static final byte[] LINE_SPACING;
    public static final byte[] PARAGRAPH_DEFAULTS;
    protected ArrayList chunks = new ArrayList();
    private int lineLeading = 0;

    static {
        PARAGRAPH_DEFAULTS = "\\pard".getBytes();
        IN_TABLE = "\\intbl".getBytes();
        LINE_SPACING = "\\sl".getBytes();
    }

    public RtfPhrase(RtfDocument doc, Phrase phrase) {
        super(doc);
        if (phrase == null) {
            return;
        }
        this.lineLeading = phrase.leadingDefined() ? (int)((double)phrase.leading() * 20.0) : 0;
        RtfFont phraseFont = new RtfFont(null, phrase.font());
        int i = 0;
        while (i < phrase.size()) {
            Element chunk = (Element)phrase.get(i);
            if (chunk instanceof Chunk) {
                ((Chunk)chunk).setFont(phraseFont.difference(((Chunk)chunk).font()));
            }
            try {
                this.chunks.add(doc.getMapper().mapElement(chunk));
            }
            catch (DocumentException de) {
            }
            ++i;
        }
    }

    protected RtfPhrase(RtfDocument doc) {
        super(doc);
    }

    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        int i = 0;
        while (i < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(i)).setInHeader(inHeader);
            ++i;
        }
    }

    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        int i = 0;
        while (i < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(i)).setInTable(inTable);
            ++i;
        }
    }

    public void setRtfDocument(RtfDocument doc) {
        super.setRtfDocument(doc);
        int i = 0;
        while (i < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(i)).setRtfDocument(this.document);
            ++i;
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                result.write(IN_TABLE);
            }
            if (this.lineLeading > 0) {
                result.write(LINE_SPACING);
                result.write(this.intToByteArray(this.lineLeading));
            }
            int i = 0;
            while (i < this.chunks.size()) {
                result.write(((RtfBasicElement)this.chunks.get(i)).write());
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

