/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.text;

import com.lowagie2.text.rtf.RtfAddableElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfTab
extends RtfAddableElement {
    public static final int TAB_CENTER_ALIGN = 1;
    public static final int TAB_DECIMAL_ALIGN = 3;
    public static final int TAB_LEFT_ALIGN = 0;
    public static final int TAB_RIGHT_ALIGN = 2;
    private int position = 0;
    private int type = 0;

    public RtfTab(float position, int type) {
        this.position = (int)Math.round((double)position * 20.0);
        switch (type) {
            case 0: {
                this.type = 0;
                break;
            }
            case 1: {
                this.type = 1;
                break;
            }
            case 2: {
                this.type = 2;
                break;
            }
            case 3: {
                this.type = 3;
                break;
            }
            default: {
                this.type = 0;
            }
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            switch (this.type) {
                case 1: {
                    result.write("\\tqc".getBytes());
                    break;
                }
                case 2: {
                    result.write("\\tqr".getBytes());
                    break;
                }
                case 3: {
                    result.write("\\tqdec".getBytes());
                }
            }
            result.write("\\tx".getBytes());
            result.write(this.intToByteArray(this.position));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

