/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.xml;

import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

public class XmlPeer {
    protected Properties attributeAliases = new Properties();
    protected Properties attributeValues = new Properties();
    protected String customTagname;
    protected String defaultContent = null;
    protected String tagname;

    public XmlPeer(String name, String alias) {
        this.tagname = name;
        this.customTagname = alias;
    }

    public void addAlias(String name, String alias) {
        this.attributeAliases.put(alias, name);
    }

    public void addValue(String name, String value) {
        this.attributeValues.put(name, value);
    }

    public String getAlias() {
        return this.customTagname;
    }

    public Properties getAttributes(Attributes attrs) {
        Properties attributes = new Properties();
        attributes.putAll((Map<?, ?>)this.attributeValues);
        if (this.defaultContent != null) {
            attributes.put("itext", this.defaultContent);
        }
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                String attribute = this.getName(attrs.getQName(i));
                attributes.setProperty(attribute, attrs.getValue(i));
                ++i;
            }
        }
        return attributes;
    }

    public Properties getDefaultValues() {
        return this.attributeValues;
    }

    public String getName(String name) {
        String value = this.attributeAliases.getProperty(name);
        if (value != null) {
            return value;
        }
        return name;
    }

    public String getTag() {
        return this.tagname;
    }

    public void setContent(String content) {
        this.defaultContent = content;
    }
}

