/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.tools;

import com.lowagie2.text.pdf.PdfEncryptor;
import com.lowagie2.text.pdf.PdfReader;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class encrypt_pdf {
    private static final int INPUT_FILE = 0;
    private static final int MOREINFO = 6;
    private static final int OUTPUT_FILE = 1;
    private static final int OWNER_PASSWORD = 3;
    private static final int PERMISSIONS = 4;
    private static final int STRENGTH = 5;
    private static final int USER_PASSWORD = 2;
    private static final int[] permit = new int[]{2052, 8, 16, 32, 256, 512, 1024, 4};

    public static void main(String[] args) {
        System.out.println("PDF document encryptor");
        if (args.length <= 5 || args[4].length() != 8) {
            encrypt_pdf.usage();
            return;
        }
        try {
            int permissions = 0;
            String p = args[4];
            int k = 0;
            while (k < p.length()) {
                permissions |= p.charAt(k) == '0' ? 0 : permit[k];
                ++k;
            }
            System.out.println("Reading " + args[0]);
            PdfReader reader = new PdfReader(args[0]);
            System.out.println("Writing " + args[1]);
            HashMap<String, String> moreInfo = new HashMap<String, String>();
            int k2 = 6;
            while (k2 < args.length - 1) {
                moreInfo.put(args[k2], args[k2 + 1]);
                k2 += 2;
            }
            PdfEncryptor.encrypt(reader, (OutputStream)new FileOutputStream(args[1]), args[2].getBytes(), args[3].getBytes(), permissions, args[5].equals("128"), moreInfo);
            System.out.println("Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("usage: input_file output_file user_password owner_password permissions 128|40 [new info string pairs]");
        System.out.println("permissions is 8 digit long 0 or 1. Each digit has a particular security function:");
        System.out.println();
        System.out.println("AllowPrinting");
        System.out.println("AllowModifyContents");
        System.out.println("AllowCopy");
        System.out.println("AllowModifyAnnotations");
        System.out.println("AllowFillIn (128 bit only)");
        System.out.println("AllowScreenReaders (128 bit only)");
        System.out.println("AllowAssembly (128 bit only)");
        System.out.println("AllowDegradedPrinting (128 bit only)");
        System.out.println("Example permissions to copy and print would be: 10100000");
    }
}

