/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.tools.plugins;

import com.lowagie2.text.pdf.PRStream;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNameTree;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfString;
import com.lowagie2.tools.arguments.FileArgument;
import com.lowagie2.tools.arguments.LabelAccessory;
import com.lowagie2.tools.arguments.PdfFilter;
import com.lowagie2.tools.arguments.ToolArgument;
import com.lowagie2.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.ListIterator;
import javax.swing.JInternalFrame;

public class ExtractAttachments
extends AbstractTool {
    static {
        AbstractTool.addVersion("$Id: ExtractAttachments.java,v 1.6 2006/08/24 09:42:46 blowagie Exp $");
    }

    public ExtractAttachments() {
        FileArgument f = new FileArgument(this, "srcfile", "The file you want to operate on", false, new PdfFilter());
        f.setLabel(new LabelAccessory());
        this.arguments.add(f);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("ExtractAttachments", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== ExtractAttachments OPENED ===");
    }

    public void execute() {
        try {
            ListIterator i;
            PdfDictionary embFiles;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            File parentFile = src.getParentFile();
            String outPath = parentFile != null ? parentFile.getAbsolutePath() : "";
            PdfDictionary catalog = reader.getCatalog();
            PdfDictionary names = (PdfDictionary)PdfReader.getPdfObject(catalog.get(PdfName.NAMES));
            if (names != null && (embFiles = (PdfDictionary)PdfReader.getPdfObject(names.get(new PdfName("EmbeddedFiles")))) != null) {
                HashMap embMap = PdfNameTree.readTree(embFiles);
                i = embMap.values().iterator();
                while (i.hasNext()) {
                    PdfDictionary filespec = (PdfDictionary)PdfReader.getPdfObject((PdfObject)i.next());
                    ExtractAttachments.unpackFile(reader, filespec, outPath);
                }
            }
            int k = 1;
            while (k <= reader.getNumberOfPages()) {
                PdfArray annots = (PdfArray)PdfReader.getPdfObject(reader.getPageN(k).get(PdfName.ANNOTS));
                if (annots != null) {
                    i = annots.listIterator();
                    while (i.hasNext()) {
                        PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)i.next());
                        PdfName subType = (PdfName)PdfReader.getPdfObject(annot.get(PdfName.SUBTYPE));
                        if (!PdfName.FILEATTACHMENT.equals(subType)) continue;
                        PdfDictionary filespec = (PdfDictionary)PdfReader.getPdfObject(annot.get(PdfName.FS));
                        ExtractAttachments.unpackFile(reader, filespec, outPath);
                    }
                }
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is more than one destfile.");
    }

    public static void main(String[] args) {
        ExtractAttachments tool = new ExtractAttachments();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    public static void unpackFile(PdfReader reader, PdfDictionary filespec, String outPath) throws IOException {
        if (filespec == null) {
            return;
        }
        PdfName type = (PdfName)PdfReader.getPdfObject(filespec.get(PdfName.TYPE));
        if (!PdfName.F.equals(type) && !PdfName.FILESPEC.equals(type)) {
            return;
        }
        PdfDictionary ef = (PdfDictionary)PdfReader.getPdfObject(filespec.get(PdfName.EF));
        if (ef == null) {
            return;
        }
        PdfString fn = (PdfString)PdfReader.getPdfObject(filespec.get(PdfName.F));
        System.out.println("Unpacking file '" + fn + "' to " + outPath);
        if (fn == null) {
            return;
        }
        File fLast = new File(fn.toUnicodeString());
        File fullPath = new File(outPath, fLast.getName());
        if (fullPath.exists()) {
            return;
        }
        PRStream prs = (PRStream)PdfReader.getPdfObject(ef.get(PdfName.F));
        if (prs == null) {
            return;
        }
        byte[] b = PdfReader.getStreamBytes(prs);
        FileOutputStream fout = new FileOutputStream(fullPath);
        fout.write(b);
        fout.close();
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }
}

