/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.tools.plugins;

import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfStamper;
import com.lowagie2.text.pdf.SimpleBookmark;
import com.lowagie2.tools.arguments.FileArgument;
import com.lowagie2.tools.arguments.PdfFilter;
import com.lowagie2.tools.arguments.ToolArgument;
import com.lowagie2.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class XML2Bookmarks
extends AbstractTool {
    static {
        AbstractTool.addVersion("$Id: XML2Bookmarks.java,v 1.3 2006/08/24 10:51:06 blowagie Exp $");
    }

    public XML2Bookmarks() {
        this.arguments.add(new FileArgument((AbstractTool)this, "xmlfile", "the bookmarks in XML", false));
        this.arguments.add(new FileArgument(this, "pdffile", "the PDF to which you want to add bookmarks", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "the resulting PDF", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("XML + PDF = PDF", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== XML2Bookmarks OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("xmlfile") == null) {
                throw new InstantiationException("You need to choose an xml file");
            }
            if (this.getValue("pdffile") == null) {
                throw new InstantiationException("You need to choose a source PDF file");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination PDF file");
            }
            FileInputStream bmReader = new FileInputStream((File)this.getValue("xmlfile"));
            List bookmarks = SimpleBookmark.importFromXML(bmReader);
            bmReader.close();
            PdfReader reader = new PdfReader(((File)this.getValue("pdffile")).getAbsolutePath());
            reader.consolidateNamedDestinations();
            PdfStamper stamper = new PdfStamper(reader, new FileOutputStream((File)this.getValue("destfile")));
            stamper.setOutlines(bookmarks);
            stamper.setViewerPreferences(reader.getViewerPreferences() | 0x20);
            stamper.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    public static void main(String[] args) {
        XML2Bookmarks tool = new XML2Bookmarks();
        if (args.length < 3) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }
}

