/*
 * Decompiled with CFR 0.152.
 */
package com.view.pdf;

import com.lowagie2.text.FontFactory;
import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfDocument;
import com.runqian.base4.tool.GC;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.control.CellBorder;
import com.runqian.report4.control.ControlUtils;
import com.runqian.report4.control.LeanLine;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.BackGraphConfig;
import com.runqian.report4.usermodel.CellGraphConfig;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.dmgraph.DMImageValue;
import com.runqian.report4.usermodel.graph.ImageValue;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.util.RichTextUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class PdfCell {
    short col;
    private Graphics2D _$253;
    private INormalCell _$251;
    private ReportParser _$252;
    private PdfContentByte _$254;
    int row;

    static {
        FontFactory.registerDirectories();
    }

    public PdfCell(ReportParser parser, int row, short col, Graphics2D g, PdfContentByte pcb) {
        this._$251 = this._$251 = parser.getCell(row, col);
        this.row = row;
        this.col = col;
        this._$252 = parser;
        this._$253 = g;
        this._$254 = pcb;
    }

    public PdfCell(ReportParser parser, int row, short col, Graphics2D g) {
        this(parser, row, col, g, null);
    }

    public boolean canDrawPdfText() {
        return this._$254 != null;
    }

    private void _$302(int x1, int y1, int w, int h) {
        int bk = this._$251.getBackColor();
        if (bk == 0xFFFFFF) {
            return;
        }
        Color color = new Color(bk);
        try {
            if (this._$254 != null) {
                this._$254.setColorFill(color);
            }
            this._$253.setColor(color);
            this._$253.fillRect(x1, y1, w, h);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void _$335(int x1, int y1, int w, int h) {
        CellBorder.setEnv((Graphics)this._$253, (ReportParser)this._$252, (int)this.row, (short)this.col, (boolean)false);
        CellBorder.setPageHeaderAndFooter((Area)this._$252.getPageHeader(), (Area)this._$252.getPageFooter());
        CellBorder.drawBorder((int)x1, (int)y1, (int)w, (int)h);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawCell(int[] xx, int[] yy) {
        Image cellImage;
        CellGraphConfig cgc;
        int h;
        int w;
        int y;
        int x;
        block19: {
            byte[] bytes;
            if (this._$252.isMerged(this.row, this.col) && !this._$252.isMergedFirstCell(this.row, this.col, false)) {
                return;
            }
            x = xx[this.col - 1];
            y = yy[this.row - 1];
            w = this._$252.getMergedWidth(this.row, this.col, false, 1.0f);
            h = this._$252.getMergedHeight(this.row, this.col, false, 1.0f);
            BackGraphConfig bgc = this._$252.getReport().getBackGraphConfig();
            boolean hasBackGraph = false;
            if (bgc != null && (bytes = bgc.getImageBytes()) != null) {
                hasBackGraph = true;
            }
            if (!hasBackGraph) {
                this._$302(x, y, w, h);
            }
            INormalCell cell = this._$252.getCell(this.row, this.col);
            cgc = cell.getCellGraphConfig();
            cellImage = null;
            if (cgc != null && cgc.getImageBytes() != null) {
                cellImage = new ImageIcon(cgc.getImageBytes()).getImage();
            }
            if (cellImage != null && cgc.getOrder() == 10) {
                this._$262(x, y, w, h, cellImage);
            }
            byte dataType = this._$251.getCellType();
            try {
                block21: {
                    block20: {
                        if (dataType == -64) {
                            byte lean = this._$251.getDiagonalStyle();
                            if (lean == 80) {
                                if (this._$252.isCellVisible(this.row, this.col)) {
                                    this._$316(x, y, w, h);
                                }
                                break block19;
                            }
                            new LeanLine(this._$252, this.row, this.col).drawPdfText((Graphics)this._$253, x, y, w, h, this);
                            break block19;
                        }
                        if (dataType == -60) {
                            Object sub = this._$251.getValue();
                            if (sub instanceof IReport) {
                                if (this._$252.isCellVisible(this.row, this.col)) {
                                    this._$320((IReport)sub, x, y, w, h);
                                }
                                break block19;
                            }
                            if (this._$252.isCellVisible(this.row, this.col)) {
                                this._$316(x, y, w, h);
                            }
                            break block19;
                        }
                        if (this._$251.isMerged() && !this._$252.isMergedFirstCell(this.row, this.col, false) || !this._$252.isCellVisible(this.row, this.col)) break block19;
                        if (dataType == -61) break block20;
                        if (dataType == -57) break block20;
                        if (dataType == -62) break block20;
                        if (dataType == -63) break block20;
                        if (dataType != -55) break block21;
                    }
                    this._$262(x, y, w, h);
                    break block19;
                }
                if (dataType == -58) {
                    Image img = this._$252.getHTMLCellImage(this.row, this.col, 1.0f, w, h);
                    this._$262(x, y, w, h, img);
                    break block19;
                }
                if (dataType == -56) {
                    ArrayList richLines = RichTextUtil.getRichTextLineList((IReport)this._$252.getReport(), (INormalCell)cell);
                    ControlUtils.drawPdfRichText((Graphics)this._$253, (ArrayList)richLines, (int)x, (int)y, (PdfCell)this);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        if (cellImage != null && cgc.getOrder() == 11) {
            this._$262(x, y, w, h, cellImage);
        }
        this._$335(x, y, w, h);
    }

    private void _$262(float x, float y, float w, float h) {
        Object val = this._$251.getValue();
        if (val == null) {
            return;
        }
        byte[] imageStream = null;
        if (val instanceof ImageValue) {
            ImageValue iv = (ImageValue)val;
            imageStream = iv.getValue();
        } else if (val instanceof DMImageValue) {
            int cellw = this._$252.getMergedWidth(this.row, this.col, false);
            int cellh = this._$252.getMergedHeight(this.row, this.col, false);
            try {
                imageStream = ((DMImageValue)val).calcImageBytes(null, cellw, cellh);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            imageStream = (byte[])val;
        }
        Image image = new ImageIcon(imageStream).getImage();
        this._$262(x, y, w, h, image);
    }

    private void _$262(float x, float y, float w, float h, Image image) {
        int[] size = this._$252.getImageWH(image, this.row, this.col, 1.0f);
        int ww = size[0];
        int hh = size[1];
        float xx = x;
        if (this._$251.getHAlign() == -47) {
            xx = x + (w - (float)ww) / 2.0f;
        } else if (this._$251.getHAlign() == -46) {
            xx = x + (w - (float)ww);
        }
        float yy = y;
        if (this._$251.getVAlign() == -31) {
            yy = y + (h - (float)hh) / 2.0f;
        } else if (this._$251.getVAlign() == -30) {
            yy = y + (h - (float)hh);
        }
        this._$253.drawImage(image, (int)xx, (int)yy, ww, hh, null);
    }

    public void drawPdfText(String text, int x, int y, Font font, Color pcbColor) {
        PdfDocument doc = this._$254.getPdfDocument();
        float leftBottomY = doc.getPageSize().height();
        y = (int)(leftBottomY - (float)y);
        try {
            this._$254.beginText();
            com.lowagie2.text.Font pdfFont = FontFactory.getFont(font.getName(), "Identity-H", font.getSize(), font.getStyle(), pcbColor);
            BaseFont bf = pdfFont.getBaseFont();
            if (bf == null) {
                switch (GC.LANGUAGE) {
                    case 1: {
                        bf = BaseFont.createFont("MSung-Light", "UniCNS-UCS2-H", false);
                        break;
                    }
                    case 2: {
                        bf = BaseFont.createFont("HeiseiKakuGo-W", "UniJIS-UCS2-H", false);
                        break;
                    }
                    case 3: {
                        bf = BaseFont.createFont("HYGoThic-Medium", "UniKS-UCS2-H", false);
                        break;
                    }
                    default: {
                        bf = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", false);
                    }
                }
            }
            this._$254.setColorFill(pcbColor);
            this._$254.setFontAndSize(bf, font.getSize());
            if (ControlUtils.displayG != null) {
                char[] chars = text.toCharArray();
                FontMetrics fm = ControlUtils.displayG.getFontMetrics(font);
                int i = 0;
                while (i < chars.length) {
                    String aChar = new String(chars, i, 1);
                    this._$254.setTextMatrix(x, y);
                    this._$254.showText(aChar);
                    x += fm.charsWidth(chars, i, 1);
                    ++i;
                }
            } else {
                this._$254.setTextMatrix(x, y);
                this._$254.showText(text);
            }
            this._$254.endText();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void _$320(IReport subReport, int x1, int y1, int w, int h) {
        ReportParser subParser = new ReportParser(subReport);
        try {
            int i;
            int height;
            int i2;
            int totalX;
            int subh = subParser.getReportHeight();
            int subw = subParser.getReportWidth();
            subw = subw > w ? w : subw;
            subh = subh > h ? h : subh;
            byte align = this._$251.getHAlign();
            if (align == -47) {
                x1 += (w - subw) / 2;
            } else if (align == -46) {
                x1 = x1 + w - subw;
            }
            byte valign = this._$251.getVAlign();
            if (valign == -31) {
                y1 += (h - subh) / 2;
            } else if (valign == -30) {
                y1 = y1 + h - subh;
            }
            w = subw;
            h = subh;
            short colCount = subParser.getColCount();
            int rowCount = subParser.getRowCount();
            int[] x = new int[colCount];
            x[0] = totalX = x1;
            short i3 = 1;
            while (i3 < colCount) {
                float width = subParser.getColWidth(i3);
                if (!subParser.isColVisible(i3)) {
                    width = 0.0f;
                }
                x[i3] = totalX = (int)((float)totalX + width);
                i3 = (short)(i3 + 1);
            }
            int[] y = new int[rowCount];
            int totalY = y1;
            int startHeader = 0;
            int endHeader = 0;
            int startFooter = 0;
            int endFooter = 0;
            Area headField = subParser.getPageHeader();
            if (headField != null) {
                startHeader = headField.getBeginRow();
                endHeader = headField.getEndRow();
                i2 = 0;
                while (i2 < endHeader) {
                    y[i2] = totalY;
                    height = subParser.getRowHeight(i2 + 1);
                    if (!subParser.isRowVisible(i2 + 1)) {
                        height = 0;
                    }
                    totalY += height;
                    ++i2;
                }
            }
            i2 = endHeader;
            while (i2 < rowCount) {
                y[i2] = totalY;
                height = subParser.getRowHeight(i2 + 1);
                if (!subParser.isRowVisible(i2 + 1)) {
                    height = 0;
                }
                totalY += height;
                ++i2;
            }
            Area footField = subParser.getPageFooter();
            totalY = y1 + h;
            if (footField != null) {
                startFooter = footField.getBeginRow();
                i = endFooter = footField.getEndRow();
                while (i >= startFooter) {
                    int height2 = subParser.getRowHeight(i);
                    if (!subParser.isRowVisible(i)) {
                        height2 = 0;
                    }
                    y[i - 1] = totalY -= height2;
                    --i;
                }
            }
            i = 1;
            while (i <= rowCount) {
                if (subParser.isRowVisible(i)) {
                    short j = 1;
                    while (j <= colCount) {
                        if (subParser.isColVisible(j) && subParser.isCellVisible(i, j)) {
                            PdfCell pc = new PdfCell(subParser, i, j, this._$253, this._$254);
                            pc.drawCell(x, y);
                        }
                        j = (short)(j + 1);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), (Throwable)e);
        }
    }

    private void _$316(int x1, int y1, int w, int h) {
        ControlUtils.drawPdfText((Graphics)this._$253, (String)this._$259(), (int)x1, (int)y1, (int)w, (int)h, (boolean)this._$251.getTextWrap(), (boolean)this._$251.isUnderline(), (byte)this._$251.getHAlign(), (byte)this._$251.getVAlign(), (int)((int)this._$251.getIndent()), (Font)this._$373(), (Color)new Color(this._$251.getForeColor()), (PdfCell)this);
    }

    private Font _$373() {
        String face = this._$251.getFontName();
        short size = this._$251.getFontSize();
        int fontStyle = 0;
        if (this._$251.isBold()) {
            ++fontStyle;
        }
        if (this._$251.isItalic()) {
            fontStyle += 2;
        }
        return new Font(face, fontStyle, size);
    }

    private String _$259() {
        return ControlUtils.getCellText((IReport)this._$252.getReport(), (int)this.row, (short)this.col, (boolean)false);
    }
}

