/*
 * Decompiled with CFR 0.152.
 */
package com.view.pdf;

import com.lowagie2.text.Document;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.PdfAction;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfWriter;
import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.tool.GM;
import com.runqian.base4.util.PwdUtils;
import com.runqian.base4.util.ReportError;
import com.runqian.base4.util.StringUtils;
import com.runqian.report4.control.ControlUtils;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.BackGraphConfig;
import com.runqian.report4.usermodel.ExportConfig;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.usermodel.PagerInfo;
import com.runqian.report4.usermodel.PrintSetup;
import com.runqian.report4.util.ReportParser;
import com.view.pdf.PdfCell;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.ImageIcon;

public class PdfReport {
    public static int MAX_SIZE = 14400;
    private int _$245;
    private Document _$252;
    private boolean _$256;
    private boolean _$255;
    private int _$242;
    private OutputStream _$246;
    private String _$249;
    private int _$241;
    private int _$240;
    private PdfContentByte _$254;
    private int _$250;
    private boolean _$251;
    private int _$243;
    private int _$244;
    private String _$248;
    private String _$247;
    private PdfWriter _$253;

    public PdfReport(OutputStream os) throws Exception {
        block8: {
            MessageManager mm;
            ExtCellSet lc;
            block9: {
                this._$247 = "";
                this._$250 = 0;
                this._$251 = false;
                this._$255 = true;
                this._$256 = true;
                this._$246 = os;
                lc = ExtCellSet.get();
                mm = EngineMessage.get();
                if (lc == null || !lc.checkExpiration() || !lc.getExportEnabled()) {
                    throw new Exception(mm.getMessage("pdfreport.licenseError"));
                }
                String forceExport = System.getProperty("forceExport");
                if (forceExport == null || !forceExport.equalsIgnoreCase("true")) {
                    if (lc.getType() == 0) {
                        if (!lc.checkDog()) {
                            throw new Exception(mm.getMessage("pdfreport.nodog"));
                        }
                    }
                }
                if (lc.getType() != 1) break block8;
                if (lc.getVersion() == 20) break block9;
                if (lc.getVersion() != 21) break block8;
            }
            this._$247 = lc.getPrompt();
            if (!GM.isValidString((Object)this._$247)) {
                this._$247 = lc.getVersion() == 20 ? mm.getMessage("pdfreport.demo1") : mm.getMessage("pdfreport.demo2");
            }
        }
    }

    private void _$351(Graphics2D g2, IReport pageReport, int leftMargin, int topMargin, int rightMargin, int bottomMargin, int paperHeight) {
        byte[] bytes;
        if (this._$247.length() > 0) {
            if (topMargin < 50) {
                topMargin = 50;
            }
            g2.setColor(Color.red);
            g2.setFont(new Font("Dialog", 0, 20));
            g2.drawString(this._$247, 100, 25);
        }
        ReportParser parser = new ReportParser(pageReport);
        PrintSetup ps = pageReport.getPrintSetup();
        int reportWidth = parser.getReportWidth();
        switch (ps.getHAlign()) {
            case 0: {
                break;
            }
            case 1: {
                leftMargin = (this._$240 - reportWidth) / 2;
                break;
            }
            case 2: {
                leftMargin = this._$240 - rightMargin - reportWidth;
            }
        }
        int reportHeight = parser.getReportHeight();
        switch (ps.getVAlign()) {
            case 0: {
                break;
            }
            case 1: {
                topMargin = (paperHeight - reportHeight) / 2;
                break;
            }
            case 2: {
                topMargin = paperHeight - bottomMargin - reportHeight;
            }
        }
        BackGraphConfig bgc = pageReport.getBackGraphConfig();
        if (bgc != null && (bytes = bgc.getImageBytes()) != null) {
            Image image = new ImageIcon(bytes).getImage();
            g2.drawImage(image, leftMargin, topMargin, image.getWidth(null), image.getHeight(null), null);
        }
        try {
            int height;
            int i;
            int totalX;
            short colCount = pageReport.getColCount();
            int rowCount = pageReport.getRowCount();
            int[] x = new int[colCount];
            x[0] = totalX = leftMargin;
            short i2 = 1;
            while (i2 < colCount) {
                float width = parser.getColWidth(i2);
                if (!parser.isColVisible(i2)) {
                    width = 0.0f;
                }
                x[i2] = totalX = (int)((float)totalX + width);
                i2 = (short)(i2 + 1);
            }
            int[] y = new int[rowCount];
            int totalY = topMargin;
            int startHeader = 0;
            int endHeader = 0;
            int startFooter = 0;
            int endFooter = 0;
            Area headField = parser.getPageHeader();
            if (headField != null) {
                startHeader = headField.getBeginRow();
                endHeader = headField.getEndRow();
                i = 0;
                while (i < endHeader) {
                    y[i] = totalY;
                    height = parser.getRowHeight(i + 1);
                    if (!parser.isRowVisible(i + 1)) {
                        height = 0;
                    }
                    totalY += height;
                    ++i;
                }
            }
            i = endHeader;
            while (i < rowCount) {
                y[i] = totalY;
                height = parser.getRowHeight(i + 1);
                if (!parser.isRowVisible(i + 1)) {
                    height = 0;
                }
                totalY += height;
                ++i;
            }
            Area footField = parser.getPageFooter();
            totalY = paperHeight - bottomMargin;
            if (footField != null) {
                startFooter = footField.getBeginRow();
                int i3 = endFooter = footField.getEndRow();
                while (i3 >= startFooter) {
                    int height2 = parser.getRowHeight(i3);
                    if (!parser.isRowVisible(i3)) {
                        height2 = 0;
                    }
                    y[i3 - 1] = totalY -= height2;
                    --i3;
                }
            }
            float leftBottomY = this._$252.getPageSize().height();
            int i4 = 1;
            while (i4 <= rowCount) {
                if (parser.isRowVisible(i4)) {
                    short j = 1;
                    while (j <= colCount) {
                        if (parser.isColVisible(j)) {
                            PdfCell pc = this._$256 ? new PdfCell(parser, i4, j, g2, this._$254) : new PdfCell(parser, i4, j, g2, null);
                            INormalCell nc = parser.getCell(i4, j);
                            if (nc.getHyperlink() != null && nc.getHyperlink().length() > 0) {
                                int h = parser.getRowHeight(i4);
                                int w = parser.getColWidth(j);
                                int lbx = x[j - 1];
                                int lby = y[i4 - 1] + h;
                                int rtx = x[j - 1] + w;
                                int rty = y[i4 - 1];
                                this._$254.setAction(new PdfAction(nc.getHyperlink()), lbx, leftBottomY - (float)lby, rtx, leftBottomY - (float)rty);
                            }
                            pc.drawCell(x, y);
                        }
                        j = (short)(j + 1);
                    }
                }
                ++i4;
            }
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), (Throwable)e);
        }
    }

    private void _$330(PageBuilder pb) throws Exception {
        this._$252.setPageSize(new Rectangle(0.0f, 0.0f, this._$240, this._$241));
        this._$252.setMargins(this._$242, this._$243, this._$244, this._$245);
        int i = 1;
        while (i <= pb.getPageCount()) {
            this._$252.newPage();
            this._$327(pb.getPage(i));
            ++i;
        }
    }

    public void export(PageBuilder pb) throws Exception {
        PagerInfo pi = pb.getPagerInfo();
        this._$290(pi.getPageFormat());
        if (this._$255) {
            this._$255 = false;
            this._$252 = new Document(new Rectangle(0.0f, 0.0f, this._$240, this._$241), this._$242, this._$243, this._$244, this._$245);
            this._$253 = PdfWriter.getInstance(this._$252, this._$246);
            if (this._$251) {
                // empty if block
            }
            this._$252.open();
            this._$254 = this._$253.getDirectContent();
        }
        this._$330(pb);
    }

    public void export(IReport report) throws Throwable {
        ReportParser parser = new ReportParser(report);
        PrintSetup ps = report.getPrintSetup();
        PagerInfo pi = new PagerInfo(ps);
        pi.setOrientation((byte)1);
        short columns = ps.getTableColumnNum();
        PageFormat pf = ps.getPageFormat();
        this._$290(pf);
        this._$240 = parser.getReportWidth() + this._$242 + this._$243;
        this._$241 = parser.getReportHeight() + this._$244 + this._$245;
        if (this._$240 > MAX_SIZE || this._$241 > MAX_SIZE) {
            if (this._$240 > MAX_SIZE) {
                this._$240 = MAX_SIZE;
            }
            if (this._$241 > MAX_SIZE) {
                this._$241 = MAX_SIZE;
            }
            System.out.println("Report is too large to draw on one PDF page.");
        }
        pi.setPaperSize((float)this._$240, (float)this._$241);
        try {
            if (this._$255) {
                ExportConfig ec;
                this._$255 = false;
                this._$252 = new Document(new Rectangle(0.0f, 0.0f, this._$240, this._$241), this._$242, this._$243, this._$244, this._$245);
                this._$253 = PdfWriter.getInstance(this._$252, this._$246);
                if (!this._$251 && (ec = report.getExportConfig()) != null) {
                    this.setUserPassword(PwdUtils.decrypt((String)ec.getPDFUserPassword()));
                    this.setOwnerPassword(PwdUtils.decrypt((String)ec.getPDFOwnerPassword()));
                    this.setPrivilege(ec.getPDFPrivilege());
                }
                if (this._$251) {
                    // empty if block
                }
                this._$252.open();
                this._$254 = this._$253.getDirectContent();
            }
            this._$252.setPageSize(new Rectangle(0.0f, 0.0f, this._$240, this._$241));
            this._$252.setMargins(this._$242, this._$243, this._$244, this._$245);
            this._$252.newPage();
            this._$327(report);
        }
        catch (Throwable e) {
            throw new ReportError(e.getMessage(), e);
        }
    }

    public String getOwnerPassword() {
        return this._$249;
    }

    public int getPrivilege() {
        return this._$250;
    }

    public String getUserPassword() {
        return this._$248;
    }

    private void _$290(PageFormat pf) {
        this._$240 = (int)pf.getWidth();
        this._$241 = (int)pf.getHeight();
        try {
            this._$242 = (int)pf.getImageableX();
        }
        catch (Exception e) {
            this._$242 = 5;
        }
        try {
            this._$243 = (int)(pf.getWidth() - pf.getImageableWidth()) - this._$242;
        }
        catch (Exception e) {
            this._$243 = 5;
        }
        try {
            this._$244 = (int)pf.getImageableY();
        }
        catch (Exception e) {
            this._$244 = 5;
        }
        try {
            this._$245 = (int)(pf.getHeight() - pf.getImageableHeight()) - this._$244;
        }
        catch (Exception e) {
            this._$245 = 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        FileOutputStream out = null;
        Document document = new Document(new Rectangle(0.0f, 0.0f, 595.0f, 842.0f), 5.0f, 5.0f, 5.0f, 5.0f);
        try {
            try {
                out = new FileOutputStream("d:\\b.pdf");
                PdfWriter writer = PdfWriter.getInstance(document, out);
                document.open();
                document.newPage();
                Phrase phrase = new Phrase("123");
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                Object var6_7 = null;
                document.close();
                return;
            }
            Object var6_6 = null;
            document.close();
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            document.close();
            throw throwable;
        }
    }

    private void _$327(IReport pageReport) throws Exception {
        Graphics2D g2 = this._$254.createGraphicsShapes(this._$240, this._$241);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this._$351(g2, pageReport, this._$242, this._$244, this._$243, this._$245, this._$241);
        g2.dispose();
    }

    public void resetExport() {
        this._$251 = false;
        this._$248 = "";
        this._$249 = "";
        this._$250 = 0;
    }

    public void save() {
        if (this._$252.isOpen()) {
            this._$252.close();
        }
        ControlUtils.displayG = null;
    }

    public void setAnamorphic(boolean anamorphic) {
        this._$256 = anamorphic;
        if (anamorphic) {
            BufferedImage bi = new BufferedImage(10, 10, 1);
            ControlUtils.displayG = bi.getGraphics();
        }
    }

    public void setOwnerPassword(String password) {
        if (!StringUtils.isSpaceString((String)password)) {
            this._$251 = true;
            this._$249 = password;
        }
    }

    public void setPrivilege(int privilege) {
        if (privilege != 2048) {
            this._$251 = true;
            this._$250 = privilege;
        }
    }

    public void setUserPassword(String password) {
        if (!StringUtils.isSpaceString((String)password)) {
            this._$251 = true;
            this._$248 = password;
        }
    }
}

