/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm.jni;

import com.marcnuri.helm.jni.NativeLibrary;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class RemoteJarLoader {
    private static final String TEMP_DIR = "java.io.tmpdir";
    private static final String VERSION = "com.marcnuri.jkube-helm.version";
    private static final String GROUP_ID = "com.marcnuri.jkube-helm.groupId";
    private static final String SNAPSHOTS = "com.marcnuri.jkube-helm.repository.snapshots";
    private static final String RELEASES = "com.marcnuri.jkube-helm.repository.releases";
    private static final String FORCE_UPDATE = "com.marcnuri.jkube-helm.forceUpdate";
    private static final String SKIP = "com.marcnuri.jkube-helm.skipRemoteJar";

    private RemoteJarLoader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ClassLoader remoteJar() {
        if (System.getProperty(SKIP) != null) {
            return null;
        }
        Properties nativeLibraries = new Properties();
        try (InputStream stream = NativeLibrary.class.getResourceAsStream("/META-INF/native-libraries.properties");){
            nativeLibraries.load(stream);
            String version = System.getProperty(VERSION) != null ? System.getProperty(VERSION) : nativeLibraries.getProperty(VERSION);
            String groupId = nativeLibraries.getProperty(GROUP_ID);
            boolean isSnapshot = version.endsWith("-SNAPSHOT");
            String repository = isSnapshot ? nativeLibraries.getProperty(SNAPSHOTS) : nativeLibraries.getProperty(RELEASES);
            String osName = RemoteJarLoader.osName();
            String archName = RemoteJarLoader.archName();
            if (osName == null) return null;
            if (archName == null) return null;
            String groupUrl = repository + "/" + groupId.replace('.', '/') + "/" + osName + "-" + archName + "/" + version;
            String jarName = isSnapshot ? RemoteJarLoader.latestSnapshot(version, osName, archName, groupUrl) : osName + "-" + archName + "-" + version + ".jar";
            URL jarUrl = new URL(groupUrl + "/" + jarName);
            Path jarFile = Paths.get(System.getProperty(TEMP_DIR), jarName);
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{RemoteJarLoader.cache(jarUrl, jarFile)}, NativeLibrary.class.getClassLoader());
            return uRLClassLoader;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException exception) {
            // empty catch block
        }
        return null;
    }

    private static String latestSnapshot(String version, String osName, String archName, String groupUrl) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        String metadataXml = groupUrl + "/maven-metadata.xml";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        Document xml = factory.newDocumentBuilder().parse(metadataXml);
        XPath xPath = XPathFactory.newInstance().newXPath();
        String versionFragment = version.replace("-SNAPSHOT", "");
        String timestamp = xPath.evaluate("//metadata/versioning/snapshot/timestamp", xml);
        String buildNumber = xPath.evaluate("//metadata/versioning/snapshot/buildNumber", xml);
        return osName + "-" + archName + "-" + versionFragment + "-" + timestamp + "-" + buildNumber + ".jar";
    }

    private static URL cache(URL jarUrl, Path jarFile) throws IOException {
        if (System.getProperty(FORCE_UPDATE) != null || !jarFile.toFile().exists() || !jarFile.toFile().isFile()) {
            Files.deleteIfExists(jarFile);
            try (ReadableByteChannel inChannel = Channels.newChannel(jarUrl.openStream());
                 FileOutputStream fos = new FileOutputStream(jarFile.toFile());
                 FileChannel outChannel = fos.getChannel();){
                outChannel.transferFrom(inChannel, 0L, Long.MAX_VALUE);
            }
        }
        return jarFile.toUri().toURL();
    }

    private static String osName() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return "windows";
        }
        if (osName.contains("mac")) {
            return "darwin";
        }
        if (osName.contains("nux") || osName.contains("nix") || osName.contains("aix")) {
            return "linux";
        }
        return null;
    }

    private static String archName() {
        String arch = System.getProperty("os.arch");
        if (arch.equals("amd64") || arch.equals("x86_64")) {
            return "amd64";
        }
        if (arch.equals("arm64") || arch.equals("aarch64")) {
            return "arm64";
        }
        return null;
    }
}

