/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault;

import com.microsoft.azure.keyvault.KeyOpRequestMessageWithRawJsonContent;
import com.microsoft.azure.keyvault.KeyOpResponseMessageWithRawJsonContent;
import com.microsoft.azure.keyvault.KeyOperations;
import com.microsoft.azure.keyvault.KeyVaultInternalClientImpl;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.StreamUtils;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class KeyOperationsImpl
implements ServiceOperations<KeyVaultInternalClientImpl>,
KeyOperations {
    private KeyVaultInternalClientImpl client;

    KeyOperationsImpl(KeyVaultInternalClientImpl client) {
        this.client = client;
    }

    public KeyVaultInternalClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> backupAsync(final String keyIdentifier) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.backup(keyIdentifier);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent backup(String keyIdentifier) throws IOException, ServiceException {
        if (keyIdentifier == null) {
            throw new NullPointerException("keyIdentifier");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("keyIdentifier", keyIdentifier);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"backupAsync", tracingParameters);
        }
        String url = "";
        url = url + keyIdentifier;
        url = url + "/backup";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> createAsync(final String vault, final String keyName, final KeyOpRequestMessageWithRawJsonContent keyOpRequest) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.create(vault, keyName, keyOpRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent create(String vault, String keyName, KeyOpRequestMessageWithRawJsonContent keyOpRequest) throws IOException, ServiceException {
        if (vault == null) {
            throw new NullPointerException("vault");
        }
        if (keyName == null) {
            throw new NullPointerException("keyName");
        }
        if (keyOpRequest == null) {
            throw new NullPointerException("keyOpRequest");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vault", vault);
            tracingParameters.put("keyName", keyName);
            tracingParameters.put("keyOpRequest", keyOpRequest);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        String url = "";
        url = url + vault;
        url = url + "/keys/";
        url = url + URLEncoder.encode(keyName, "UTF-8");
        url = url + "/create";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = keyOpRequest.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> decryptDataAsync(final String keyIdentifier, final KeyOpRequestMessageWithRawJsonContent keyOpRequest) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.decryptData(keyIdentifier, keyOpRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent decryptData(String keyIdentifier, KeyOpRequestMessageWithRawJsonContent keyOpRequest) throws IOException, ServiceException {
        if (keyIdentifier == null) {
            throw new NullPointerException("keyIdentifier");
        }
        if (keyOpRequest == null) {
            throw new NullPointerException("keyOpRequest");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("keyIdentifier", keyIdentifier);
            tracingParameters.put("keyOpRequest", keyOpRequest);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"decryptDataAsync", tracingParameters);
        }
        String url = "";
        url = url + keyIdentifier;
        url = url + "/decrypt";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = keyOpRequest.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> deleteKeyAsync(final String vault, final String keyName) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.deleteKey(vault, keyName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent deleteKey(String vault, String keyName) throws IOException, ServiceException {
        if (vault == null) {
            throw new NullPointerException("vault");
        }
        if (keyName == null) {
            throw new NullPointerException("keyName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("vault", vault);
            tracingParameters.put("keyName", keyName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteKeyAsync", tracingParameters);
        }
        String url = "";
        url = url + vault;
        url = url + "/keys/";
        url = url + URLEncoder.encode(keyName, "UTF-8");
        url = url + "/delete";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> encryptDataAsync(final String keyIdentifier, final KeyOpRequestMessageWithRawJsonContent keyOpRequest) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.encryptData(keyIdentifier, keyOpRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent encryptData(String keyIdentifier, KeyOpRequestMessageWithRawJsonContent keyOpRequest) throws IOException, ServiceException {
        if (keyIdentifier == null) {
            throw new NullPointerException("keyIdentifier");
        }
        if (keyOpRequest == null) {
            throw new NullPointerException("keyOpRequest");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("keyIdentifier", keyIdentifier);
            tracingParameters.put("keyOpRequest", keyOpRequest);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"encryptDataAsync", tracingParameters);
        }
        String url = "";
        url = url + keyIdentifier;
        url = url + "/encrypt";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = keyOpRequest.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> getAsync(final String keyIdentifier) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.get(keyIdentifier);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent get(String keyIdentifier) throws IOException, ServiceException {
        if (keyIdentifier == null) {
            throw new NullPointerException("keyIdentifier");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("keyIdentifier", keyIdentifier);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + keyIdentifier;
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> importMethodAsync(final String keyIdentifier, final KeyOpRequestMessageWithRawJsonContent keyOpRequest) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.importMethod(keyIdentifier, keyOpRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent importMethod(String keyIdentifier, KeyOpRequestMessageWithRawJsonContent keyOpRequest) throws IOException, ServiceException {
        if (keyIdentifier == null) {
            throw new NullPointerException("keyIdentifier");
        }
        if (keyOpRequest == null) {
            throw new NullPointerException("keyOpRequest");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("keyIdentifier", keyIdentifier);
            tracingParameters.put("keyOpRequest", keyOpRequest);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"importMethodAsync", tracingParameters);
        }
        String url = "";
        url = url + keyIdentifier;
        url = url + "/import";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = keyOpRequest.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> listAsync(final String vault, final Integer top) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.list(vault, top);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent list(String vault, Integer top) throws IOException, ServiceException {
        if (vault == null) {
            throw new NullPointerException("vault");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vault", vault);
            tracingParameters.put("top", top);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + vault;
        url = url + "/keys/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (top != null) {
            queryParameters.add("maxresults=" + URLEncoder.encode(Integer.toString(top), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent listNext(String nextLink) throws IOException, ServiceException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> listVersionsAsync(final String vault, final String keyName, final Integer top) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.listVersions(vault, keyName, top);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent listVersions(String vault, String keyName, Integer top) throws IOException, ServiceException {
        if (vault == null) {
            throw new NullPointerException("vault");
        }
        if (keyName == null) {
            throw new NullPointerException("keyName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vault", vault);
            tracingParameters.put("keyName", keyName);
            tracingParameters.put("top", top);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listVersionsAsync", tracingParameters);
        }
        String url = "";
        url = url + vault;
        url = url + "/keys/";
        url = url + URLEncoder.encode(keyName, "UTF-8");
        url = url + "/versions";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (top != null) {
            queryParameters.add("maxresults=" + URLEncoder.encode(Integer.toString(top), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> listVersionsNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.listVersionsNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent listVersionsNext(String nextLink) throws IOException, ServiceException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listVersionsNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> restoreAsync(final String vault, final KeyOpRequestMessageWithRawJsonContent keyOpRequest) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.restore(vault, keyOpRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent restore(String vault, KeyOpRequestMessageWithRawJsonContent keyOpRequest) throws IOException, ServiceException {
        if (vault == null) {
            throw new NullPointerException("vault");
        }
        if (keyOpRequest == null) {
            throw new NullPointerException("keyOpRequest");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vault", vault);
            tracingParameters.put("keyOpRequest", keyOpRequest);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"restoreAsync", tracingParameters);
        }
        String url = "";
        url = url + vault;
        url = url + "/keys/restore";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = keyOpRequest.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> signAsync(final String keyIdentifier, final KeyOpRequestMessageWithRawJsonContent keyOpRequest) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.sign(keyIdentifier, keyOpRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent sign(String keyIdentifier, KeyOpRequestMessageWithRawJsonContent keyOpRequest) throws IOException, ServiceException {
        if (keyIdentifier == null) {
            throw new NullPointerException("keyIdentifier");
        }
        if (keyOpRequest == null) {
            throw new NullPointerException("keyOpRequest");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("keyIdentifier", keyIdentifier);
            tracingParameters.put("keyOpRequest", keyOpRequest);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"signAsync", tracingParameters);
        }
        String url = "";
        url = url + keyIdentifier;
        url = url + "/sign";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = keyOpRequest.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> unwrapKeyAsync(final String keyIdentifier, final KeyOpRequestMessageWithRawJsonContent keyOpRequest) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.unwrapKey(keyIdentifier, keyOpRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent unwrapKey(String keyIdentifier, KeyOpRequestMessageWithRawJsonContent keyOpRequest) throws IOException, ServiceException {
        if (keyIdentifier == null) {
            throw new NullPointerException("keyIdentifier");
        }
        if (keyOpRequest == null) {
            throw new NullPointerException("keyOpRequest");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("keyIdentifier", keyIdentifier);
            tracingParameters.put("keyOpRequest", keyOpRequest);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"unwrapKeyAsync", tracingParameters);
        }
        String url = "";
        url = url + keyIdentifier;
        url = url + "/unwrapkey";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = keyOpRequest.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> updateAsync(final String keyIdentifier, final KeyOpRequestMessageWithRawJsonContent keyOpRequest) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.update(keyIdentifier, keyOpRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent update(String keyIdentifier, KeyOpRequestMessageWithRawJsonContent keyOpRequest) throws IOException, ServiceException {
        if (keyIdentifier == null) {
            throw new NullPointerException("keyIdentifier");
        }
        if (keyOpRequest == null) {
            throw new NullPointerException("keyOpRequest");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("keyIdentifier", keyIdentifier);
            tracingParameters.put("keyOpRequest", keyOpRequest);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String url = "";
        url = url + keyIdentifier;
        url = url + "/update";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPatch httpRequest = new HttpPatch(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = keyOpRequest.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> verifyAsync(final String keyIdentifier, final KeyOpRequestMessageWithRawJsonContent keyOpRequest) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.verify(keyIdentifier, keyOpRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent verify(String keyIdentifier, KeyOpRequestMessageWithRawJsonContent keyOpRequest) throws IOException, ServiceException {
        if (keyIdentifier == null) {
            throw new NullPointerException("keyIdentifier");
        }
        if (keyOpRequest == null) {
            throw new NullPointerException("keyOpRequest");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("keyIdentifier", keyIdentifier);
            tracingParameters.put("keyOpRequest", keyOpRequest);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"verifyAsync", tracingParameters);
        }
        String url = "";
        url = url + keyIdentifier;
        url = url + "/verify";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = keyOpRequest.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<KeyOpResponseMessageWithRawJsonContent> wrapKeyAsync(final String keyIdentifier, final KeyOpRequestMessageWithRawJsonContent keyOpRequest) {
        return this.getClient().getExecutorService().submit(new Callable<KeyOpResponseMessageWithRawJsonContent>(){

            @Override
            public KeyOpResponseMessageWithRawJsonContent call() throws Exception {
                return KeyOperationsImpl.this.wrapKey(keyIdentifier, keyOpRequest);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyOpResponseMessageWithRawJsonContent wrapKey(String keyIdentifier, KeyOpRequestMessageWithRawJsonContent keyOpRequest) throws IOException, ServiceException {
        if (keyIdentifier == null) {
            throw new NullPointerException("keyIdentifier");
        }
        if (keyOpRequest == null) {
            throw new NullPointerException("keyOpRequest");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("keyIdentifier", keyIdentifier);
            tracingParameters.put("keyOpRequest", keyOpRequest);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"wrapKeyAsync", tracingParameters);
        }
        String url = "";
        url = url + keyIdentifier;
        url = url + "/wrapkey";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = keyOpRequest.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            KeyOpResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new KeyOpResponseMessageWithRawJsonContent();
            result.setKeyOpResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            KeyOpResponseMessageWithRawJsonContent keyOpResponseMessageWithRawJsonContent = result;
            return keyOpResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

