/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault;

import com.microsoft.azure.keyvault.BackupKeyResponseMessageFuture;
import com.microsoft.azure.keyvault.JsonSupport;
import com.microsoft.azure.keyvault.KeyBundleFuture;
import com.microsoft.azure.keyvault.KeyOpRequestMessageWithRawJsonContent;
import com.microsoft.azure.keyvault.KeyOpResponseMessageWithRawJsonContent;
import com.microsoft.azure.keyvault.KeyOperationFuture;
import com.microsoft.azure.keyvault.KeyOperations;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.KeyVaultInternalClient;
import com.microsoft.azure.keyvault.KeyVaultInternalClientImpl;
import com.microsoft.azure.keyvault.ListKeysFuture;
import com.microsoft.azure.keyvault.ListSecretsFuture;
import com.microsoft.azure.keyvault.SecretFuture;
import com.microsoft.azure.keyvault.SecretOperations;
import com.microsoft.azure.keyvault.SecretRequestMessageWithRawJsonContent;
import com.microsoft.azure.keyvault.SecretResponseMessageWithRawJsonContent;
import com.microsoft.azure.keyvault.VerifyFuture;
import com.microsoft.azure.keyvault.authentication.BearerAuthenticationSetup;
import com.microsoft.azure.keyvault.models.CreateKeyRequestMessage;
import com.microsoft.azure.keyvault.models.ImportKeyRequestMessage;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyIdentifier;
import com.microsoft.azure.keyvault.models.KeyOperationRequest;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.models.ListKeysResponseMessage;
import com.microsoft.azure.keyvault.models.ListSecretsResponseMessage;
import com.microsoft.azure.keyvault.models.RestoreKeyRequestMessage;
import com.microsoft.azure.keyvault.models.Secret;
import com.microsoft.azure.keyvault.models.SecretAttributes;
import com.microsoft.azure.keyvault.models.SecretIdentifier;
import com.microsoft.azure.keyvault.models.UpdateKeyRequestMessage;
import com.microsoft.azure.keyvault.models.VerifyRequestMessage;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.credentials.CloudCredentials;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.impl.client.HttpClientBuilder;

public class KeyVaultClientImpl
implements KeyVaultClient {
    private final KeyVaultInternalClient internalClient;

    public KeyVaultClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        this.internalClient = new KeyVaultInternalClientImpl(httpBuilder, executorService);
    }

    @Inject
    public KeyVaultClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(value="com.microsoft.windowsazure.Configuration.credentials") CloudCredentials credentials) {
        BearerAuthenticationSetup.configureClientBuilder(httpBuilder, credentials);
        this.internalClient = new KeyVaultInternalClientImpl(httpBuilder, executorService, credentials);
    }

    private KeyVaultClientImpl(KeyVaultInternalClient internalClient) {
        this.internalClient = internalClient;
    }

    @Override
    public void close() throws IOException {
        this.internalClient.close();
    }

    public KeyVaultClient withRequestFilterFirst(ServiceRequestFilter serviceRequestFilter) {
        KeyVaultInternalClient newClient = (KeyVaultInternalClient)this.internalClient.withRequestFilterFirst(serviceRequestFilter);
        if (newClient != this.internalClient) {
            return new KeyVaultClientImpl(newClient);
        }
        return this;
    }

    public KeyVaultClient withRequestFilterLast(ServiceRequestFilter serviceRequestFilter) {
        KeyVaultInternalClient newClient = (KeyVaultInternalClient)this.internalClient.withRequestFilterLast(serviceRequestFilter);
        if (newClient != this.internalClient) {
            return new KeyVaultClientImpl(newClient);
        }
        return this;
    }

    public KeyVaultClient withResponseFilterFirst(ServiceResponseFilter serviceResponseFilter) {
        KeyVaultInternalClient newClient = (KeyVaultInternalClient)this.internalClient.withResponseFilterFirst(serviceResponseFilter);
        if (newClient != this.internalClient) {
            return new KeyVaultClientImpl(newClient);
        }
        return this;
    }

    public KeyVaultClient withResponseFilterLast(ServiceResponseFilter serviceResponseFilter) {
        KeyVaultInternalClient newClient = (KeyVaultInternalClient)this.internalClient.withResponseFilterLast(serviceResponseFilter);
        if (newClient != this.internalClient) {
            return new KeyVaultClientImpl(newClient);
        }
        return this;
    }

    @Override
    public String getApiVersion() {
        return this.internalClient.getApiVersion();
    }

    @Override
    public URI getBaseUri() {
        return this.internalClient.getBaseUri();
    }

    @Override
    public CloudCredentials getCredentials() {
        return this.internalClient.getCredentials();
    }

    @Override
    public void setCredentials(CloudCredentials credentialsValue) {
        this.internalClient.setCredentials(credentialsValue);
    }

    @Override
    public int getLongRunningOperationInitialTimeout() {
        return this.internalClient.getLongRunningOperationInitialTimeout();
    }

    @Override
    public void setLongRunningOperationInitialTimeout(int longRunningOperationInitialTimeoutValue) {
        this.internalClient.setLongRunningOperationInitialTimeout(longRunningOperationInitialTimeoutValue);
    }

    @Override
    public int getLongRunningOperationRetryTimeout() {
        return this.internalClient.getLongRunningOperationRetryTimeout();
    }

    @Override
    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeoutValue) {
        this.internalClient.setLongRunningOperationRetryTimeout(longRunningOperationRetryTimeoutValue);
    }

    @Override
    public ServiceClient<?> getServiceClient() {
        return (ServiceClient)this.internalClient;
    }

    @Override
    public Future<KeyOperationResult> encryptAsync(String vault, String keyName, String keyVersion, String algorithm, byte[] plainText) {
        String keyIdentifier = KeyVaultClientImpl.createKeyIdentifier(vault, keyName, keyVersion);
        return this.encryptAsync(keyIdentifier, algorithm, plainText);
    }

    @Override
    public Future<KeyOperationResult> encryptAsync(String keyIdentifier, String algorithm, byte[] plainText) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = KeyVaultClientImpl.createKeyOpRequest(algorithm, plainText);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().encryptDataAsync(keyIdentifier, keyOpRequest);
        KeyOperationFuture result = new KeyOperationFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyOperationResult> decryptAsync(String keyIdentifier, String algorithm, byte[] cipherText) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = KeyVaultClientImpl.createKeyOpRequest(algorithm, cipherText);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().decryptDataAsync(keyIdentifier, keyOpRequest);
        KeyOperationFuture result = new KeyOperationFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyOperationResult> signAsync(String vault, String keyName, String keyVersion, String algorithm, byte[] digest) {
        String keyIdentifier = KeyVaultClientImpl.createKeyIdentifier(vault, keyName, keyVersion);
        return this.signAsync(keyIdentifier, algorithm, digest);
    }

    @Override
    public Future<KeyOperationResult> signAsync(String keyIdentifier, String algorithm, byte[] digest) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = KeyVaultClientImpl.createKeyOpRequest(algorithm, digest);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().signAsync(keyIdentifier, keyOpRequest);
        KeyOperationFuture result = new KeyOperationFuture(rawResult);
        return result;
    }

    @Override
    public Future<Boolean> verifyAsync(String keyIdentifier, String algorithm, byte[] digest, byte[] signature) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = KeyVaultClientImpl.createVerifyOpRequest(algorithm, digest, signature);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().verifyAsync(keyIdentifier, keyOpRequest);
        VerifyFuture result = new VerifyFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyOperationResult> wrapKeyAsync(String vault, String keyName, String keyVersion, String algorithm, byte[] key) {
        String keyIdentifier = KeyVaultClientImpl.createKeyIdentifier(vault, keyName, keyVersion);
        return this.wrapKeyAsync(keyIdentifier, algorithm, key);
    }

    @Override
    public Future<KeyOperationResult> wrapKeyAsync(String keyIdentifier, String algorithm, byte[] key) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = KeyVaultClientImpl.createKeyOpRequest(algorithm, key);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().wrapKeyAsync(keyIdentifier, keyOpRequest);
        KeyOperationFuture result = new KeyOperationFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyOperationResult> unwrapKeyAsync(String keyIdentifier, String algorithm, byte[] wrappedKey) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = KeyVaultClientImpl.createKeyOpRequest(algorithm, wrappedKey);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().unwrapKeyAsync(keyIdentifier, keyOpRequest);
        KeyOperationFuture result = new KeyOperationFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> createKeyAsync(String vault, String keyName, String keyType, Integer keySize, String[] keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = KeyVaultClientImpl.createCreateKeyRequest(keyType, keySize, keyOps, keyAttributes, tags);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().createAsync(vault, keyName, keyOpRequest);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> getKeyAsync(String vault, String keyName, String keyVersion) {
        String keyIdentifier = KeyVaultClientImpl.createKeyIdentifier(vault, keyName, keyVersion);
        return this.getKeyAsync(keyIdentifier);
    }

    @Override
    public Future<KeyBundle> getKeyAsync(String keyIdentifier) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().getAsync(keyIdentifier);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListKeysResponseMessage> getKeysAsync(String vault, Integer maxresults) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().listAsync(vault, maxresults);
        ListKeysFuture result = new ListKeysFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListKeysResponseMessage> getKeysNextAsync(String nextLink) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().listNextAsync(nextLink);
        ListKeysFuture result = new ListKeysFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListKeysResponseMessage> getKeyVersionsAsync(String vault, String keyName, Integer maxresults) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().listVersionsAsync(vault, keyName, maxresults);
        ListKeysFuture result = new ListKeysFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListKeysResponseMessage> getKeyVersionsNextAsync(String nextLink) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().listVersionsNextAsync(nextLink);
        ListKeysFuture result = new ListKeysFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> deleteKeyAsync(String vault, String keyName) {
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().deleteKeyAsync(vault, keyName);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> updateKeyAsync(String vault, String keyName, String[] keyOps, KeyAttributes attributes, Map<String, String> tags) {
        String keyIdentifier = KeyVaultClientImpl.createKeyIdentifier(vault, keyName);
        return this.updateKeyAsync(keyIdentifier, keyOps, attributes, tags);
    }

    @Override
    public Future<KeyBundle> updateKeyAsync(String keyIdentifier, String[] keyOps, KeyAttributes attributes, Map<String, String> tags) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = KeyVaultClientImpl.createUpdateKeyRequest(keyOps, attributes, tags);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().updateAsync(keyIdentifier, keyOpRequest);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> importKeyAsync(String vault, String keyName, KeyBundle keyBundle, Boolean importToHardware) {
        String keyIdentifier = KeyVaultClientImpl.createKeyIdentifier(vault, keyName);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = KeyVaultClientImpl.createImportKeyRequest(keyBundle, importToHardware);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().importMethodAsync(keyIdentifier, keyOpRequest);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<byte[]> backupKeyAsync(String vault, String keyName) {
        String keyIdentifier = KeyVaultClientImpl.createKeyIdentifier(vault, keyName);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().backupAsync(keyIdentifier);
        BackupKeyResponseMessageFuture result = new BackupKeyResponseMessageFuture(rawResult);
        return result;
    }

    @Override
    public Future<KeyBundle> restoreKeyAsync(String vault, byte[] keyBundleBackup) {
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = KeyVaultClientImpl.createRestoreKeyRequest(keyBundleBackup);
        Future<KeyOpResponseMessageWithRawJsonContent> rawResult = this.getKeysOperations().restoreAsync(vault, keyOpRequest);
        KeyBundleFuture result = new KeyBundleFuture(rawResult);
        return result;
    }

    @Override
    public Future<Secret> getSecretAsync(String vault, String secretName, String secretVersion) {
        String secretIdentifier = KeyVaultClientImpl.createSecretIdentifier(vault, secretName, secretVersion);
        return this.getSecretAsync(secretIdentifier);
    }

    @Override
    public Future<Secret> getSecretAsync(String secretIdentifier) {
        Future<SecretResponseMessageWithRawJsonContent> rawResult = this.getSecretsOperations().getAsync(secretIdentifier);
        SecretFuture result = new SecretFuture(rawResult);
        return result;
    }

    @Override
    public Future<Secret> setSecretAsync(String vault, String secretName, String value, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        String secretIdentifier = KeyVaultClientImpl.createSecretIdentifier(vault, secretName);
        SecretRequestMessageWithRawJsonContent secretOpRequest = KeyVaultClientImpl.createSetSecretRequest(value, contentType, secretAttributes, tags);
        Future<SecretResponseMessageWithRawJsonContent> rawResult = this.getSecretsOperations().setAsync(secretIdentifier, secretOpRequest);
        SecretFuture result = new SecretFuture(rawResult);
        return result;
    }

    @Override
    public Future<Secret> updateSecretAsync(String vault, String secretName, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        String secretIdentifier = KeyVaultClientImpl.createSecretIdentifier(vault, secretName);
        return this.updateSecretAsync(secretIdentifier, contentType, secretAttributes, tags);
    }

    @Override
    public Future<Secret> updateSecretAsync(String secretIdentifier, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        SecretRequestMessageWithRawJsonContent secretOpRequest = KeyVaultClientImpl.createUpdateSecretRequest(contentType, secretAttributes, tags);
        Future<SecretResponseMessageWithRawJsonContent> rawResult = this.getSecretsOperations().updateAsync(secretIdentifier, secretOpRequest);
        SecretFuture result = new SecretFuture(rawResult);
        return result;
    }

    @Override
    public Future<Secret> deleteSecretAsync(String vault, String secretName) {
        String secretIdentifier = KeyVaultClientImpl.createSecretIdentifier(vault, secretName);
        Future<SecretResponseMessageWithRawJsonContent> rawResult = this.getSecretsOperations().deleteAsync(secretIdentifier);
        SecretFuture result = new SecretFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListSecretsResponseMessage> getSecretsAsync(String vault, Integer maxresults) {
        Future<SecretResponseMessageWithRawJsonContent> rawResult = this.getSecretsOperations().listAsync(vault, maxresults);
        ListSecretsFuture result = new ListSecretsFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListSecretsResponseMessage> getSecretsNextAsync(String nextLink) {
        Future<SecretResponseMessageWithRawJsonContent> rawResult = this.getSecretsOperations().listNextAsync(nextLink);
        ListSecretsFuture result = new ListSecretsFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListSecretsResponseMessage> getSecretVersionsAsync(String vault, String secretName, Integer maxresults) {
        Future<SecretResponseMessageWithRawJsonContent> rawResult = this.getSecretsOperations().listVersionsAsync(vault, secretName, maxresults);
        ListSecretsFuture result = new ListSecretsFuture(rawResult);
        return result;
    }

    @Override
    public Future<ListSecretsResponseMessage> getSecretVersionsNextAsync(String nextLink) {
        Future<SecretResponseMessageWithRawJsonContent> rawResult = this.getSecretsOperations().listVersionsNextAsync(nextLink);
        ListSecretsFuture result = new ListSecretsFuture(rawResult);
        return result;
    }

    private KeyOperations getKeysOperations() {
        return this.internalClient.getKeysOperations();
    }

    private SecretOperations getSecretsOperations() {
        return this.internalClient.getSecretsOperations();
    }

    private static String createKeyIdentifier(String vault, String keyName) {
        return new KeyIdentifier(vault, keyName).getIdentifier();
    }

    private static String createKeyIdentifier(String vault, String keyName, String keyVersion) {
        return new KeyIdentifier(vault, keyName, keyVersion).getIdentifier();
    }

    private static String createSecretIdentifier(String vault, String secretName) {
        return new SecretIdentifier(vault, secretName).getIdentifier();
    }

    private static String createSecretIdentifier(String vault, String secretName, String secretVersion) {
        return new SecretIdentifier(vault, secretName, secretVersion).getIdentifier();
    }

    private static KeyOpRequestMessageWithRawJsonContent createKeyOpRequest(String algorithm, byte[] data) {
        KeyOperationRequest request = new KeyOperationRequest();
        request.setAlg(algorithm);
        request.setValue(data);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static KeyOpRequestMessageWithRawJsonContent createVerifyOpRequest(String algorithm, byte[] digest, byte[] signature) {
        VerifyRequestMessage request = new VerifyRequestMessage();
        request.setAlg(algorithm);
        request.setDigest(digest);
        request.setValue(signature);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static KeyOpRequestMessageWithRawJsonContent createCreateKeyRequest(String keyType, Integer keySize, String[] keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        CreateKeyRequestMessage request = new CreateKeyRequestMessage();
        request.setKty(keyType);
        request.setKeySize(keySize);
        request.setKeyOps(keyOps);
        request.setAttributes(keyAttributes);
        request.setTags(tags);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static KeyOpRequestMessageWithRawJsonContent createUpdateKeyRequest(String[] keyOps, KeyAttributes attributes, Map<String, String> tags) {
        UpdateKeyRequestMessage request = new UpdateKeyRequestMessage();
        request.setKeyOps(keyOps);
        request.setAttributes(attributes);
        request.setTags(tags);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static KeyOpRequestMessageWithRawJsonContent createImportKeyRequest(KeyBundle keyBundle, Boolean importToHardware) {
        ImportKeyRequestMessage request = new ImportKeyRequestMessage();
        request.setKey(keyBundle.getKey());
        request.setAttributes(keyBundle.getAttributes());
        request.setTags(keyBundle.getTags());
        request.setHsm(importToHardware);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static KeyOpRequestMessageWithRawJsonContent createRestoreKeyRequest(byte[] keyBundleBackup) {
        RestoreKeyRequestMessage request = new RestoreKeyRequestMessage();
        request.setValue(keyBundleBackup);
        KeyOpRequestMessageWithRawJsonContent keyOpRequest = JsonSupport.serializeKeyOpRequest(request);
        return keyOpRequest;
    }

    private static SecretRequestMessageWithRawJsonContent createSetSecretRequest(String value, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        Secret request = new Secret();
        request.setValue(value);
        request.setContentType(contentType);
        request.setAttributes(secretAttributes);
        request.setTags(tags);
        SecretRequestMessageWithRawJsonContent secretOpRequest = JsonSupport.serializeSecretOpRequest(request);
        return secretOpRequest;
    }

    private static SecretRequestMessageWithRawJsonContent createUpdateSecretRequest(String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        Secret request = new Secret();
        request.setContentType(contentType);
        request.setAttributes(secretAttributes);
        request.setTags(tags);
        SecretRequestMessageWithRawJsonContent secretOpRequest = JsonSupport.serializeSecretOpRequest(request);
        return secretOpRequest;
    }
}

