/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault;

import com.microsoft.azure.keyvault.KeyOperations;
import com.microsoft.azure.keyvault.KeyOperationsImpl;
import com.microsoft.azure.keyvault.KeyVaultInternalClient;
import com.microsoft.azure.keyvault.SecretOperations;
import com.microsoft.azure.keyvault.SecretOperationsImpl;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.credentials.CloudCredentials;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.impl.client.HttpClientBuilder;

class KeyVaultInternalClientImpl
extends ServiceClient<KeyVaultInternalClient>
implements KeyVaultInternalClient {
    private String apiVersion = "2015-06-01";
    private URI baseUri;
    private CloudCredentials credentials;
    private int longRunningOperationInitialTimeout = -1;
    private int longRunningOperationRetryTimeout = -1;
    private KeyOperations keys = new KeyOperationsImpl(this);
    private SecretOperations secrets = new SecretOperationsImpl(this);

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public CloudCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(CloudCredentials credentialsValue) {
        this.credentials = credentialsValue;
    }

    @Override
    public int getLongRunningOperationInitialTimeout() {
        return this.longRunningOperationInitialTimeout;
    }

    @Override
    public void setLongRunningOperationInitialTimeout(int longRunningOperationInitialTimeoutValue) {
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }

    @Override
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeoutValue) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }

    @Override
    public KeyOperations getKeysOperations() {
        return this.keys;
    }

    @Override
    public SecretOperations getSecretsOperations() {
        return this.secrets;
    }

    public KeyVaultInternalClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
    }

    @Inject
    public KeyVaultInternalClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(value="com.microsoft.windowsazure.Configuration.credentials") CloudCredentials credentials, @Named(value="management.uri") URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = baseUri;
    }

    public KeyVaultInternalClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, CloudCredentials credentials) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = null;
    }

    public KeyVaultInternalClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, CloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    protected KeyVaultInternalClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new KeyVaultInternalClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri(), this.getApiVersion(), this.getLongRunningOperationInitialTimeout(), this.getLongRunningOperationRetryTimeout());
    }
}

