/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.models;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;

public class ObjectIdentifier {
    private final String vault;
    private final String name;
    private final String version;
    private final String baseIdentifier;
    private final String identifier;

    protected static boolean isObjectIdentifier(String collection, String identifier) {
        URI baseUri;
        collection = ObjectIdentifier.verifyNonEmpty(collection, "collection");
        identifier = ObjectIdentifier.verifyNonEmpty(identifier, "identifier");
        try {
            baseUri = new URI(identifier);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String[] segments = baseUri.getPath().split("/");
        if (segments.length != 3 && segments.length != 4) {
            return false;
        }
        return collection.equals(segments[1]);
    }

    private static String verifyNonEmpty(String value, String argName) {
        if (value != null && (value = value.trim()).isEmpty()) {
            value = null;
        }
        if (value == null) {
            throw new IllegalArgumentException(argName);
        }
        return value;
    }

    protected ObjectIdentifier(String vault, String collection, String name) {
        this(vault, collection, name, null);
    }

    protected ObjectIdentifier(String vault, String collection, String name, String version) {
        URI baseUri;
        vault = ObjectIdentifier.verifyNonEmpty(vault, "vault");
        collection = ObjectIdentifier.verifyNonEmpty(collection, "collection");
        name = ObjectIdentifier.verifyNonEmpty(name, "name");
        if (version != null && (version = version.trim()).isEmpty()) {
            version = null;
        }
        try {
            baseUri = new URI(vault);
        }
        catch (URISyntaxException e) {
            throw new InvalidParameterException(String.format("Invalid ObjectIdentifier: %s. Not a valid URI", vault));
        }
        this.name = name;
        this.version = version;
        this.vault = String.format("%s://%s", baseUri.getScheme(), ObjectIdentifier.getFullAuthority(baseUri));
        this.baseIdentifier = String.format("%s/%s/%s", this.vault, collection, this.name);
        this.identifier = version == null ? this.baseIdentifier : String.format("%s/%s", this.baseIdentifier, version);
    }

    protected ObjectIdentifier(String collection, String identifier) {
        URI baseUri;
        if (collection == null || collection.length() == 0) {
            throw new IllegalArgumentException("collection");
        }
        if (identifier == null || identifier.length() == 0) {
            throw new IllegalArgumentException("identifier");
        }
        try {
            baseUri = new URI(identifier);
        }
        catch (URISyntaxException e) {
            throw new InvalidParameterException(String.format("Invalid ObjectIdentifier: %s. Not a valid URI", identifier));
        }
        String[] segments = baseUri.getPath().split("/");
        if (segments.length != 3 && segments.length != 4) {
            throw new InvalidParameterException(String.format("Invalid ObjectIdentifier: %s. Bad number of segments: %d", identifier, segments.length));
        }
        if (!collection.equals(segments[1])) {
            throw new InvalidParameterException(String.format("Invalid ObjectIdentifier: %s. segment [1] should be '%s', found '%s'", identifier, collection, segments[1]));
        }
        this.name = segments[2];
        this.version = segments.length == 4 ? segments[3] : null;
        this.vault = String.format("%s://%s", baseUri.getScheme(), ObjectIdentifier.getFullAuthority(baseUri));
        this.baseIdentifier = String.format("%s/%s/%s", this.vault, collection, this.name);
        this.identifier = this.version == null ? this.baseIdentifier : String.format("%s/%s", this.baseIdentifier, this.version);
    }

    private static String getFullAuthority(URI uri) {
        String authority = uri.getAuthority();
        if (!authority.contains(":") && uri.getPort() > 0) {
            authority = String.format("%s:%d", uri.getAuthority(), uri.getPort());
        }
        return authority;
    }

    public String getBaseIdentifier() {
        return this.baseIdentifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getVault() {
        return this.vault;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.identifier;
    }
}

