/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.http.ICollectionResponse;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BaseCollectionPage<T, T2 extends BaseRequestBuilder<T>>
implements IJsonBackedObject {
    private AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);
    private final List<T> pageContents;
    private final T2 requestBuilder;
    private static final String odataCountKey = "@odata.count";

    public BaseCollectionPage(@Nonnull ICollectionResponse<T> response, @Nullable T2 builder) {
        this(response.values(), builder, response.additionalDataManager());
    }

    public BaseCollectionPage(@Nonnull List<T> pageContents, @Nullable T2 nextRequestBuilder) {
        this.pageContents = Collections.unmodifiableList(pageContents == null ? new ArrayList() : pageContents);
        this.requestBuilder = nextRequestBuilder;
    }

    public BaseCollectionPage(@Nonnull List<T> pageContents, @Nullable T2 nextRequestBuilder, @Nonnull AdditionalDataManager responseAdditionalData) {
        this(pageContents, nextRequestBuilder);
        this.additionalDataManager().putAll(responseAdditionalData);
    }

    @Nullable
    public T2 getNextPage() {
        return this.requestBuilder;
    }

    @Nonnull
    public List<T> getCurrentPage() {
        return new ArrayList<T>(this.pageContents);
    }

    @Override
    public void setRawObject(@Nonnull ISerializer serializer, @Nonnull JsonObject json) {
    }

    @Override
    @Nullable
    @SuppressFBWarnings
    public final AdditionalDataManager additionalDataManager() {
        return this.additionalDataManager;
    }

    @Nullable
    public final Long getCount() {
        return this.additionalDataManager == null || !this.additionalDataManager.containsKey(odataCountKey) || !((JsonElement)this.additionalDataManager.get(odataCountKey)).isJsonPrimitive() ? null : Long.valueOf(((JsonElement)this.additionalDataManager.get(odataCountKey)).getAsLong());
    }
}

